/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value={"/api/v1/resources"})
@Controller
public class ResourceController {
    private final Map<UUID, Resource> rsrcMap = new ConcurrentHashMap<UUID, Resource>();

    @GetMapping(value={"/download/{resId}"})
    public ResponseEntity<Resource> getResource(@PathVariable(value="resId") UUID resId) {
        Resource rsrc = this.rsrcMap.get(resId);
        if (rsrc == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)rsrc);
    }

    public String coordinate(UUID resId) {
        return "/api/v1/resources/download/" + resId.toString();
    }

    public void put(UUID id, Resource rsrc) {
        this.rsrcMap.put(id, rsrc);
    }

    public void clear() {
        this.rsrcMap.clear();
    }
}

