/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithGridGainSecurityTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.TaskResponse;
import org.gridgain.control.agent.dto.action.query.CancelQueryArgument;
import org.gridgain.control.agent.dto.action.query.QueryArgument;
import org.gridgain.control.agent.dto.action.query.QueryHistoryArgument;
import org.gridgain.control.agent.dto.action.query.RunningQueriesArgument;
import org.gridgain.control.agent.dto.action.query.ScanQueryArgument;
import org.gridgain.control.agent.test.TestSqlTestFunctions;
import org.junit.Assert;
import org.junit.Test;

public class QueryActionsControllerWithGridGainSecurityTest
extends AbstractActionControllerWithGridGainSecurityTest {
    private static final String KILL_QUERY_ACCOUNT = "killQuery";

    @Override
    protected Map<SecurityCredentials, String> prepareCustomCredentials() {
        HashMap<SecurityCredentials, String> creds = new HashMap<SecurityCredentials, String>(1);
        creds.put(new SecurityCredentials(KILL_QUERY_ACCOUNT, "123456"), "{     defaultAllow: false,    {        system:[KILL_QUERY]    }}");
        return creds;
    }

    @Test
    public void shouldSendNotEnoughPermissionsOnExecutingSecuredAction() {
        GridKernalContext ctx = ((IgniteEx)this.cluster.ignite()).context();
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("no_access", "123456")).setAddress(InetSocketAddress.createUnresolved("localhost", 8090)));
        Request req = new Request().setId(UUID.randomUUID()).setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new QueryArgument().setQueryId("qry").setQueryText("create table people (id int primary key, name varchar);").setPageSize(10)).setSessionId(sesId);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(req.getId());
            Assert.assertEquals((Object)Status.FAILED, (Object)taskRes.getStatus());
            Assert.assertEquals((long)-32002L, (long)r.getError().getCode());
            Assert.assertTrue((boolean)r.getError().getMessage().startsWith("Authorization failed [perm=CACHE_CREATE"));
            return true;
        });
        IgniteCache cache = this.cluster.ignite().createCache("test_cache");
        cache.put((Object)"key_1", (Object)"value_1");
        Request scanReq = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1)).setSessionId(sesId);
        this.executeAction((AbstractRequest)scanReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(scanReq.getId());
            Assert.assertEquals((Object)Status.FAILED, (Object)taskRes.getStatus());
            Assert.assertEquals((long)-32002L, (long)r.getError().getCode());
            Assert.assertTrue((boolean)r.getError().getMessage().startsWith("Authorization failed [perm=CACHE_READ"));
            return true;
        });
        UUID adminSesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("admin", "123456")).setAddress(InetSocketAddress.createUnresolved("localhost", 8090)));
        cache = this.createCacheWithSqlTestFunctions(0);
        cache.put((Object)1, (Object)"value_2");
        cache.put((Object)2, (Object)"value_2");
        cache.put((Object)3, (Object)"value_3");
        TestSqlTestFunctions.sleepMs = 5000L;
        Request createReq = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*), sleep() AS SLEEP FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache")).setSessionId(adminSesId);
        this.executeAction((AbstractRequest)createReq, res -> {
            TaskResponse taskRes = this.taskResult(createReq.getId());
            return taskRes != null && taskRes.getStatus() == Status.RUNNING;
        });
        GridRunningQueryInfo runQry = (GridRunningQueryInfo)F.first((Iterable)ctx.query().runningQueries(-1L));
        Request killReq = new Request().setAction("QueryActions.kill").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new CancelQueryArgument().setQueryId(runQry.globalQueryId())).setSessionId(sesId);
        this.executeAction((AbstractRequest)killReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(killReq.getId());
            Assert.assertEquals((Object)Status.FAILED, (Object)taskRes.getStatus());
            Assert.assertEquals((long)-32002L, (long)r.getError().getCode());
            Assert.assertTrue((boolean)r.getError().getMessage().startsWith("Authorization failed [perm=KILL_QUERY"));
            return true;
        });
        Request runningQryReq = new Request().setAction("QueryActions.runningQueries").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new RunningQueriesArgument().setDuration(-1L)).setSessionId(sesId);
        this.executeAction((AbstractRequest)runningQryReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(runningQryReq.getId());
            Assert.assertEquals((Object)Status.FAILED, (Object)taskRes.getStatus());
            Assert.assertEquals((long)-32002L, (long)r.getError().getCode());
            Assert.assertTrue((boolean)r.getError().getMessage().startsWith("Authorization failed [perm=GET_QUERY_VIEWS"));
            return true;
        });
        Request qryHistoryReq = new Request().setAction("QueryActions.history").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryHistoryArgument()).setSessionId(sesId);
        this.executeAction((AbstractRequest)qryHistoryReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(qryHistoryReq.getId());
            Assert.assertEquals((Object)Status.FAILED, (Object)taskRes.getStatus());
            Assert.assertEquals((long)-32002L, (long)r.getError().getCode());
            Assert.assertTrue((boolean)r.getError().getMessage().startsWith("Authorization failed [perm=GET_QUERY_VIEWS"));
            return true;
        });
    }

    @Test
    public void shouldExecuteSecuredAction() {
        GridKernalContext ctx = ((IgniteEx)this.cluster.ignite()).context();
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("admin", "123456")).setAddress(InetSocketAddress.createUnresolved("localhost", 8090)));
        IgniteCache cache = this.cluster.ignite().createCache("test_cache");
        cache.put((Object)"key_1", (Object)"value_1");
        Request scanReq = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1)).setSessionId(sesId);
        this.executeAction((AbstractRequest)scanReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        cache = this.createCacheWithSqlTestFunctions(0);
        cache.put((Object)1, (Object)"value_2");
        cache.put((Object)2, (Object)"value_2");
        cache.put((Object)3, (Object)"value_3");
        TestSqlTestFunctions.sleepMs = 5000L;
        Request createReq = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*), sleep() AS SLEEP FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache")).setSessionId(sesId);
        this.executeAction((AbstractRequest)createReq, res -> {
            TaskResponse taskRes = this.taskResult(createReq.getId());
            return taskRes != null && taskRes.getStatus() == Status.RUNNING;
        });
        GridRunningQueryInfo runQry = (GridRunningQueryInfo)F.first((Iterable)ctx.query().runningQueries(-1L));
        Request killReq = new Request().setAction("QueryActions.kill").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new CancelQueryArgument().setQueryId(runQry.globalQueryId())).setSessionId(sesId);
        this.executeAction((AbstractRequest)killReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        Request runningQryReq = new Request().setAction("QueryActions.runningQueries").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new RunningQueriesArgument().setDuration(-1L)).setSessionId(sesId);
        this.executeAction((AbstractRequest)runningQryReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        Request qryHistoryReq = new Request().setAction("QueryActions.history").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryHistoryArgument()).setSessionId(sesId);
        this.executeAction((AbstractRequest)qryHistoryReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
    }

    @Test
    public void shouldPerformClearWithKillQueryAccount() {
        this.checkSecureCancelQuery(KILL_QUERY_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailClearWithNoAccessAccount() {
        this.checkSecureCancelQuery("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    private <K, V> IgniteCache<K, V> createCacheWithSqlTestFunctions(int qryDetailMetricsSz) {
        CacheConfiguration cfg = this.cacheConfiguration("TestCache").setQueryDetailMetricsSize(qryDetailMetricsSz).setIndexedTypes(new Class[]{Integer.class, String.class}).setSqlFunctionClasses(new Class[]{TestSqlTestFunctions.class});
        return this.cluster.ignite().getOrCreateCache(cfg);
    }

    private void checkSecureCancelQuery(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID adminSesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("admin", "123456")));
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        GridKernalContext ctx = ((IgniteEx)this.cluster.ignite()).context();
        IgniteCache cache = this.createCacheWithSqlTestFunctions(0);
        cache.put((Object)1, (Object)"value_2");
        cache.put((Object)2, (Object)"value_2");
        cache.put((Object)3, (Object)"value_3");
        TestSqlTestFunctions.sleepMs = 5000L;
        Request createReq = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*), sleep() AS SLEEP FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache")).setSessionId(adminSesId);
        this.executeAction((AbstractRequest)createReq, res -> {
            TaskResponse taskRes = this.taskResult(createReq.getId());
            return taskRes != null && taskRes.getStatus() == Status.RUNNING;
        });
        GridRunningQueryInfo runQry = (GridRunningQueryInfo)F.first((Iterable)ctx.query().runningQueries(-1L));
        Request cancelReq = new Request().setAction("QueryActions.cancel").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new CancelQueryArgument().setQueryId(runQry.globalQueryId())).setSessionId(sesId);
        this.executeAction((AbstractRequest)cancelReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }
}

