/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.awaitility.core.ConditionTimeoutException;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.configuration.DistributedRunningQueryExporterConfiguration;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.ResponseError;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.TaskResponse;
import org.gridgain.control.agent.dto.action.query.CancelQueryArgument;
import org.gridgain.control.agent.dto.action.query.NextPageQueryArgument;
import org.gridgain.control.agent.dto.action.query.QueryArgument;
import org.gridgain.control.agent.dto.action.query.QueryHistoryArgument;
import org.gridgain.control.agent.dto.action.query.RunningQueriesArgument;
import org.gridgain.control.agent.dto.action.query.RunningQueryConfiguration;
import org.gridgain.control.agent.dto.action.query.RunningQueryConfigurationArgument;
import org.gridgain.control.agent.dto.action.query.ScanQueryArgument;
import org.gridgain.control.agent.test.TestSqlTestFunctions;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentUtils;
import org.gridgain.internal.h2.message.DbException;
import org.junit.Assert;
import org.junit.Test;

public class QueryActionsControllerTest
extends AbstractActionControllerTest {
    @Override
    protected int clusterSize() {
        return 3;
    }

    @Test
    public void shouldExecuteQuery() {
        Request req = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId("qry").setQueryText(this.getCreateQuery() + this.getInsertQuery(1, 2) + this.getSelectQuery()).setPageSize(10));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray resArr = (JSONArray)ctx.read("$[*]]", new Predicate[0]);
                int id = (Integer)ctx.read("$[2].rows[0][0]", new Predicate[0]);
                int val = (Integer)ctx.read("$[2].rows[0][1]", new Predicate[0]);
                return resArr.size() == 3 && id == 1 && val == 2;
            }
            return false;
        });
    }

    @Test
    public void shouldExecuteQueryWithParameters() {
        Request req = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId("qry").setQueryText(this.getCreateQuery() + this.getInsertQuery(1, 2) + this.getInsertQuery(2, 3) + this.getSelectQueryWithParameter()).setPageSize(10).setParameters(new Object[]{1}));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray resArr = (JSONArray)ctx.read("$[*]]", new Predicate[0]);
                JSONArray arr = (JSONArray)ctx.read("$[3].rows[*]", new Predicate[0]);
                int id = (Integer)ctx.read("$[3].rows[0][0]", new Predicate[0]);
                int val = (Integer)ctx.read("$[3].rows[0][1]", new Predicate[0]);
                return resArr.size() == 4 && arr.size() == 1 && id == 1 && val == 2;
            }
            return false;
        });
    }

    @Test
    public void shouldExecuteQueryWithDefaultSchema() {
        String testSchema = "MC_AGENT_TEST_SCHEMA";
        String testTbl = "MC_AGENT_TEST_TABLE";
        String testClsName = "test.data.MC_AGENT_TEST_TABLE";
        QueryEntity qryEntity = new QueryEntity().setKeyType("java.lang.Integer").setValueType("test.data.MC_AGENT_TEST_TABLE").setTableName("MC_AGENT_TEST_TABLE").setKeyFieldName("id").setKeyFields(Collections.singleton("id")).setFields(new LinkedHashMap(F.asMap((Object)"id", (Object)"java.lang.Integer", (Object)"Name", (Object)"java.lang.String")));
        IgniteCache cache = this.cluster.ignite().getOrCreateCache(this.cacheConfiguration("DEFAULT_CACHE_NAME").setSqlSchema("MC_AGENT_TEST_SCHEMA").setQueryEntities(Collections.singleton(qryEntity)));
        Integer testId = 1;
        BinaryObjectBuilder b = this.cluster.ignite().binary().builder("test.data.MC_AGENT_TEST_TABLE");
        b.setField("id", (Object)testId);
        b.setField("name", (Object)"name");
        cache.put((Object)testId, (Object)b.build());
        Request req = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId("qry").setDefaultSchema("MC_AGENT_TEST_SCHEMA").setQueryText(this.getSelectQuery("MC_AGENT_TEST_SCHEMA.MC_AGENT_TEST_TABLE") + this.getSelectQuery("MC_AGENT_TEST_TABLE")).setPageSize(10));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray resArr = (JSONArray)ctx.read("$[*]]", new Predicate[0]);
                Integer id1 = (Integer)ctx.read("$[0].rows[0][0]", new Predicate[0]);
                String val1 = (String)ctx.read("$[0].rows[0][1]", new Predicate[0]);
                Integer id2 = (Integer)ctx.read("$[1].rows[0][0]", new Predicate[0]);
                String val2 = (String)ctx.read("$[1].rows[0][1]", new Predicate[0]);
                return resArr.size() == 2 && id1 == 1 && "name".equals(val1) && id1.equals(id2) && val1.equals(val2);
            }
            return false;
        });
    }

    @Test
    public void shouldGetNextPage() {
        AtomicReference cursorId = new AtomicReference();
        Request req = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId("qry").setQueryText(this.getCreateQuery() + this.getInsertQuery(1, 2) + this.getInsertQuery(2, 3) + this.getSelectQuery()).setPageSize(1));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray resArr = (JSONArray)ctx.read("$[*]]", new Predicate[0]);
                JSONArray arr = (JSONArray)ctx.read("$[3].rows[*]", new Predicate[0]);
                boolean hasMore = (Boolean)ctx.read("$[3].hasMore", new Predicate[0]);
                cursorId.set(ctx.read("$[3].cursorId", new Predicate[0]));
                return resArr.size() == 4 && hasMore && arr.size() == 1;
            }
            return false;
        });
        Request nextPageReq = new Request().setAction("QueryActions.nextPage").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new NextPageQueryArgument().setQueryId("qry").setCursorId((String)cursorId.get()).setPageSize(1));
        this.executeAction((AbstractRequest)nextPageReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray arr = (JSONArray)ctx.read("$.rows[*]", new Predicate[0]);
                boolean hasMore = (Boolean)ctx.read("$.hasMore", new Predicate[0]);
                int id = (Integer)ctx.read("$.rows[0][0]", new Predicate[0]);
                int val = (Integer)ctx.read("$.rows[0][1]", new Predicate[0]);
                return arr.size() == 1 && !hasMore && id == 2 && val == 3;
            }
            return false;
        });
    }

    @Test
    public void shouldCancelQueryAndCleanup() {
        AtomicReference cursorId = new AtomicReference();
        Request req = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId("qry").setQueryText(this.getCreateQuery() + this.getInsertQuery(1, 2) + this.getInsertQuery(2, 3) + this.getSelectQuery()).setPageSize(1));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED) {
                DocumentContext ctx = this.parse(r.getResult());
                cursorId.set(ctx.read("$[3].cursorId", new Predicate[0]));
                return true;
            }
            return false;
        });
        Request cancelReq = new Request().setAction("QueryActions.cancel").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new CancelQueryArgument().setQueryId("qry"));
        this.executeAction((AbstractRequest)cancelReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        Request nextPageReq = new Request().setAction("QueryActions.nextPage").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new NextPageQueryArgument().setQueryId("qry").setCursorId((String)cursorId.get()).setPageSize(1));
        this.executeAction((AbstractRequest)nextPageReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.FAILED;
        });
    }

    @Test
    public void shouldCancelLongQuery() {
        StringBuilder qryText = new StringBuilder(this.getCreateQuery());
        for (int i = 0; i <= 1000; ++i) {
            qryText.append(this.getInsertQuery(i, i + 1));
        }
        qryText.append(this.getSelectQuery());
        Request req = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId("qry").setQueryText(qryText.toString()).setPageSize(1000));
        this.executeAction((AbstractRequest)req, res -> {
            TaskResponse taskRes = this.taskResult(req.getId());
            return taskRes != null && taskRes.getStatus() == Status.RUNNING;
        });
        Request cancelReq = new Request().setAction("QueryActions.cancel").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new CancelQueryArgument().setQueryId("qry"));
        this.executeAction((AbstractRequest)cancelReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        TestUtils.assertWithPoll(() -> {
            JobResponse res = this.jobResult(req.getId());
            return res != null && res.getStatus() == Status.FAILED;
        });
    }

    @Test
    public void shouldKillRunningQuery() {
        GridKernalContext ctx = ((IgniteEx)this.cluster.ignite()).context();
        this.createCacheWithSqlTestFunctions(0);
        TestSqlTestFunctions.sleepMs = 5000L;
        Request req = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*), sleep() AS SLEEP FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache"));
        this.executeAction((AbstractRequest)req, res -> {
            TaskResponse taskRes = this.taskResult(req.getId());
            return taskRes != null && taskRes.getStatus() == Status.RUNNING;
        });
        GridRunningQueryInfo runQry = (GridRunningQueryInfo)F.first((Iterable)ctx.query().runningQueries(-1L));
        Request killReq = new Request().setAction("QueryActions.kill").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new CancelQueryArgument().setQueryId(runQry.globalQueryId()));
        this.executeAction((AbstractRequest)killReq, res -> {
            TaskResponse taskRes = this.taskResult(killReq.getId());
            if (taskRes != null && taskRes.getStatus() == Status.COMPLETED) {
                Collection infos = ctx.query().runningQueries(-1L);
                return infos.isEmpty();
            }
            return false;
        });
    }

    @Test
    public void shouldKillRunningQueryWhichRunByDirectApi() {
        GridKernalContext ctx = ((IgniteEx)this.cluster.ignite()).context();
        this.createCacheWithSqlTestFunctions(0);
        TestSqlTestFunctions.sleepMs = 5000L;
        CompletableFuture.runAsync(() -> {
            SqlFieldsQuery qry = new SqlFieldsQuery("SELECT count(*), sleep() AS SLEEP FROM \"TestCache\".STRING");
            qry.setSchema("TestCache");
            try (FieldsQueryCursor cursor = ctx.query().querySqlFields(qry, true);){
                cursor.iterator().next();
            }
        });
        TestUtils.assertWithPoll(() -> !ctx.query().runningQueries(-1L).isEmpty());
        GridRunningQueryInfo runQry = (GridRunningQueryInfo)F.first((Iterable)ctx.query().runningQueries(-1L));
        Request killReq = new Request().setAction("QueryActions.kill").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new CancelQueryArgument().setQueryId(runQry.globalQueryId()));
        this.executeAction((AbstractRequest)killReq, res -> {
            TaskResponse taskRes = this.taskResult(killReq.getId());
            if (taskRes != null && taskRes.getStatus() == Status.COMPLETED) {
                Collection infos = ctx.query().runningQueries(-1L);
                return infos.isEmpty();
            }
            return false;
        });
    }

    @Test
    public void shouldExecuteScanQuery() {
        IgniteCache cache = this.cluster.ignite().createCache("test_cache");
        cache.put((Object)"key_1", (Object)"value_1");
        Request req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1));
        this.assertRequestExecution(req, "key_1", "value_1");
    }

    @Test
    public void shouldExecuteScanQueryWithFilter() {
        IgniteCache cache = this.cluster.ignite().createCache("test_cache");
        cache.put((Object)"key_1", (Object)"value_1");
        cache.put((Object)"key_2", (Object)"value_2");
        cache.put((Object)"key_3", (Object)"value_3");
        Request req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1).setKeyFilterRegex("key_1").setValueFilterRegex("value_1"));
        this.assertRequestExecution(req, "key_1", "value_1");
        req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1).setKeyFilterRegex("key_2"));
        this.assertRequestExecution(req, "key_2", "value_2");
        req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1).setValueFilterRegex("value_3"));
        this.assertRequestExecution(req, "key_3", "value_3");
    }

    @Test
    public void shouldExecuteLocalScanQuery() {
        IgniteCache cache = this.cluster.ignite().createCache("test_cache");
        cache.put((Object)"key_1", (Object)"value_1");
        int partition = this.cluster.ignite().affinity("test_cache").partition((Object)"key_1");
        ClusterNode primaryNode = this.cluster.ignite().affinity("test_cache").mapPartitionToNode(partition);
        ClusterNode nPrimaryNode = this.cluster.nodes().stream().filter(node1 -> !node1.equals(primaryNode)).findAny().get();
        int nPartition = this.cluster.ignite().affinity("test_cache").primaryPartitions(nPrimaryNode)[0];
        Request req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(primaryNode.id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1).setLocal(Boolean.valueOf(true)).setKeyFilterRegex("k[a-zA-Z]+_\\d+$").setValueFilterRegex("v[a-zA-Z]+_\\d+$"));
        this.assertRequestExecution(req, "key_1", "value_1");
        req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(nPrimaryNode.id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1).setLocal(Boolean.valueOf(true)).setPartition(Integer.valueOf(partition)).setKeyFilterRegex("k[a-zA-Z]+_\\d+$").setValueFilterRegex("v[a-zA-Z]+_\\d+$"));
        this.assertRequestExecutionEmpty(req);
        req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(nPrimaryNode.id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1).setLocal(Boolean.valueOf(true)).setPartition(Integer.valueOf(nPartition)).setKeyFilterRegex("k[a-zA-Z]+_\\d+$").setValueFilterRegex("v[a-zA-Z]+_\\d+$"));
        this.assertRequestExecutionEmpty(req);
    }

    @Test
    public void executeScanQueryPassIllegalPartition() {
        IgniteCache cache = this.cluster.ignite().createCache("test_cache");
        cache.put((Object)"key_1", (Object)"value_1");
        int iPartition = this.cluster.ignite().affinity("test_cache").partitions() + 1;
        Request req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1).setPartition(Integer.valueOf(iPartition)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.FAILED;
        });
        req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1).setPartition(Integer.valueOf(-1)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.FAILED;
        });
    }

    @Test
    public void shouldExecuteDistributedScanQueryOnSpecifiedPartition() {
        IgniteCache cache = this.cluster.ignite().createCache("test_cache");
        cache.put((Object)"key_1", (Object)"value_1");
        int partition = this.cluster.ignite().affinity("test_cache").partition((Object)"key_1");
        ClusterNode primaryNode = this.cluster.ignite().affinity("test_cache").mapPartitionToNode(partition);
        ClusterNode nPrimaryNode = this.cluster.nodes().stream().filter(node1 -> !node1.equals(primaryNode)).findAny().get();
        Request req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(primaryNode.id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1).setLocal(Boolean.valueOf(false)).setPartition(Integer.valueOf(partition)).setKeyFilterRegex("k[a-zA-Z]+_\\d+$").setValueFilterRegex("v[a-zA-Z]+_\\d+$"));
        this.assertRequestExecution(req, "key_1", "value_1");
        req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(nPrimaryNode.id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(1).setLocal(Boolean.valueOf(false)).setPartition(Integer.valueOf(partition)).setKeyFilterRegex("k[a-zA-Z]+_\\d+$").setValueFilterRegex("v[a-zA-Z]+_\\d+$"));
        this.assertRequestExecution(req, "key_1", "value_1");
    }

    @Test
    public void shouldGetScanQueryNextPage() {
        IgniteCache cache = this.cluster.ignite().createCache("test_cache");
        cache.put((Object)"key_1", (Object)"value_1");
        cache.put((Object)"key_2", (Object)"value_2");
        cache.put((Object)"key_3", (Object)"value_3");
        AtomicReference cursorId = new AtomicReference();
        ConcurrentHashMap<String, String> entries = new ConcurrentHashMap<String, String>();
        Request req = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setCacheName("test_cache").setQueryId("qry").setPageSize(2).setKeyFilterRegex("k[a-zA-Z]+_\\d+$").setValueFilterRegex("v[a-zA-Z]+_\\d+$"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray resArr = (JSONArray)ctx.read("$[*]]", new Predicate[0]);
                JSONArray arr = (JSONArray)ctx.read("$[0].rows[*]", new Predicate[0]);
                boolean hasMore = (Boolean)ctx.read("$[0].hasMore", new Predicate[0]);
                cursorId.set(ctx.read("$[0].cursorId", new Predicate[0]));
                entries.put((String)ctx.read("$[0].rows[0][1]", new Predicate[0]), (String)ctx.read("$[0].rows[0][3]", new Predicate[0]));
                entries.put((String)ctx.read("$[0].rows[1][1]", new Predicate[0]), (String)ctx.read("$[0].rows[1][3]", new Predicate[0]));
                return resArr.size() == 1 && hasMore && arr.size() == 2;
            }
            return false;
        });
        Request nextPageReq = new Request().setAction("QueryActions.nextPage").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new NextPageQueryArgument().setQueryId("qry").setCursorId((String)cursorId.get()).setPageSize(1));
        this.executeAction((AbstractRequest)nextPageReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray arr = (JSONArray)ctx.read("$.rows[*]", new Predicate[0]);
                boolean hasMore = (Boolean)ctx.read("$.hasMore", new Predicate[0]);
                entries.put((String)ctx.read("$.rows[0][1]", new Predicate[0]), (String)ctx.read("$.rows[0][3]", new Predicate[0]));
                return !hasMore && arr.size() == 1;
            }
            return false;
        });
        Assert.assertEquals((long)3L, (long)entries.size());
        entries.forEach((key, value) -> Assert.assertEquals((Object)cache.get(key), (Object)value));
    }

    @Test
    public void shouldReturnRunningQueryAtClientNode() {
        String longRunningQry = "SELECT count(*), sleep() AS \"1\" FROM \"TestCache\".STRING";
        this.createCacheWithSqlTestFunctions(0);
        TestSqlTestFunctions.sleepMs = 10000L;
        IgniteEx client = this.startClient();
        Thread longRunningQryThread = new Thread(() -> {
            try (FieldsQueryCursor qry = client.cache("TestCache").query(new SqlFieldsQuery("SELECT count(*), sleep() AS \"1\" FROM \"TestCache\".STRING"));){
                qry.getAll();
            }
        });
        longRunningQryThread.start();
        Request req = new Request().setAction("QueryActions.runningQueries").setId(UUID.randomUUID()).setArgument((Object)new RunningQueriesArgument().setDuration(0L));
        this.executeAction((AbstractRequest)req, res -> {
            TaskResponse taskRes = this.taskResult(req.getId());
            if (taskRes != null && taskRes.getStatus() == Status.COMPLETED && taskRes.getJobCount() == 4) {
                List clientJobs = res.stream().filter(r -> r.getNodeConsistentId().equals(client.localNode().consistentId().toString())).collect(Collectors.toList());
                Assert.assertEquals((long)1L, (long)clientJobs.size());
                List queries = ((Collection)((JobResponse)clientJobs.get(0)).getResult()).stream().map(row -> (String)row.get("query")).collect(Collectors.toList());
                Assert.assertEquals((long)1L, (long)queries.size());
                Assert.assertEquals((Object)"SELECT count(*), sleep() AS \"1\" FROM \"TestCache\".STRING", queries.get(0));
                return true;
            }
            return false;
        });
        longRunningQryThread.interrupt();
    }

    @Test
    public void shouldReturnQueryHistoryFromClientNode() {
        String historicalQry = "SELECT count(*) AS \"1\" FROM \"TestCache\".STRING";
        this.createCacheWithSqlTestFunctions(0);
        IgniteEx client = this.startClient();
        try (FieldsQueryCursor qry = client.cache("TestCache").query(new SqlFieldsQuery("SELECT count(*) AS \"1\" FROM \"TestCache\".STRING"));){
            qry.getAll();
        }
        Request req = new Request().setAction("QueryActions.history").setId(UUID.randomUUID()).setNodeIds(Collections.singleton(this.ignite(0).localNode().id())).setArgument((Object)new QueryHistoryArgument());
        this.executeAction((AbstractRequest)req, res -> {
            TaskResponse taskRes = this.taskResult(req.getId());
            if (taskRes != null && taskRes.getStatus() == Status.COMPLETED && taskRes.getJobCount() == 1) {
                List historicalQueries = (List)((JobResponse)res.get(0)).getResult();
                Assert.assertEquals((long)1L, (long)historicalQueries.size());
                String qry = (String)((Map)historicalQueries.get(0)).get("query");
                return qry.equals("SELECT count(*) AS \"1\" FROM \"TestCache\".STRING");
            }
            return false;
        });
    }

    @Test
    public void shouldReturnRunningQueriesFromAllNodes() {
        this.createCacheWithSqlTestFunctions(0);
        TestSqlTestFunctions.sleepMs = 10000L;
        for (UUID nid : this.allNodeIds) {
            Request req = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(nid)).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*), sleep() AS \"" + nid + "\" FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache"));
            this.executeAction((AbstractRequest)req, res -> {
                TaskResponse taskRes = this.taskResult(req.getId());
                return taskRes != null && taskRes.getStatus() == Status.RUNNING;
            });
        }
        Request req = new Request().setAction("QueryActions.runningQueries").setId(UUID.randomUUID()).setArgument((Object)new RunningQueriesArgument().setDuration(1L));
        this.executeAction((AbstractRequest)req, res -> {
            TaskResponse taskRes = this.taskResult(req.getId());
            if (taskRes != null && taskRes.getStatus() == Status.COMPLETED && taskRes.getJobCount() == 3) {
                boolean isAllResponsesNotEmpty = res.stream().noneMatch(r -> ((Collection)r.getResult()).isEmpty());
                long queriesCnt = res.stream().flatMap(r -> ((Collection)r.getResult()).stream()).map(m -> (String)m.get("query")).distinct().count();
                return isAllResponsesNotEmpty && queriesCnt == 3L;
            }
            return false;
        });
    }

    @Test
    public void shouldReturnRunningQueriesFromCoordinatorNode() {
        this.createCacheWithSqlTestFunctions(0);
        TestSqlTestFunctions.sleepMs = 5000L;
        Request qryReq = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*), sleep() FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache"));
        this.executeAction((AbstractRequest)qryReq, res -> {
            TaskResponse taskRes = this.taskResult(qryReq.getId());
            return taskRes != null && taskRes.getStatus() == Status.RUNNING;
        });
        Request req = new Request().setAction("QueryActions.runningQueries").setId(UUID.randomUUID()).setArgument((Object)new RunningQueriesArgument().setDuration(1L));
        this.executeAction((AbstractRequest)req, res -> {
            TaskResponse taskRes = this.taskResult(req.getId());
            if (taskRes != null && taskRes.getStatus() == Status.COMPLETED && taskRes.getJobCount() == 3) {
                boolean hasCorrectRes = res.stream().filter(r -> r.getNodeConsistentId().equals(this.cluster.localNode().consistentId().toString())).anyMatch(r -> !((Collection)r.getResult()).isEmpty());
                boolean isOtherResponsesEmpty = res.stream().filter(r -> !r.getNodeConsistentId().equals(this.cluster.localNode().consistentId().toString())).allMatch(r -> ((Collection)r.getResult()).isEmpty());
                return hasCorrectRes && isOtherResponsesEmpty;
            }
            return false;
        });
    }

    @Test
    public void shouldReturnQueryParamsInHistory() {
        IgniteCache cache = this.createCacheWithSqlTestFunctions(1);
        this.populateCache(cache);
        Request sqlQryReq = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*) FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache").setDistributedJoins(true).setEnforceJoinOrder(true).setLocal(true).setLazy(true));
        this.executeAction((AbstractRequest)sqlQryReq, res -> {
            TaskResponse taskRes = this.taskResult(sqlQryReq.getId());
            return taskRes != null && taskRes.getStatus() == Status.COMPLETED;
        });
        Request req = new Request().setAction("QueryActions.history").setId(UUID.randomUUID()).setArgument((Object)new QueryHistoryArgument().setSince(1L)).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(req.getId());
            if (taskRes != null && taskRes.getStatus() == Status.COMPLETED && taskRes.getJobCount() == 1) {
                DocumentContext ctx = this.parse(r.getResult());
                boolean enforceJoinOrder = (Boolean)ctx.read("$[0].enforceJoinOrder", new Predicate[0]);
                boolean lazy = (Boolean)ctx.read("$[0].lazy", new Predicate[0]);
                boolean distributedJoins = (Boolean)ctx.read("$[0].distributedJoins", new Predicate[0]);
                boolean loc = (Boolean)ctx.read("$[0].local", new Predicate[0]);
                String nodeId = (String)ctx.read("$[0].nodeId", new Predicate[0]);
                String queries = (String)ctx.read("$[0].query", new Predicate[0]);
                JSONArray results = (JSONArray)ctx.read("$[*]", new Predicate[0]);
                return results.size() == 1 && enforceJoinOrder && lazy && distributedJoins && loc && queries.equals("SELECT count(*) FROM \"TestCache\".STRING") && this.cluster.localNode().id().toString().equals(nodeId);
            }
            return false;
        });
    }

    @Test
    public void shouldReturnQueryParamsInRunning() {
        String longRunningQry = "SELECT count(*), sleep() AS \"1\" FROM \"TestCache\".STRING";
        this.createCacheWithSqlTestFunctions(0);
        TestSqlTestFunctions.sleepMs = 10000L;
        IgniteEx client = this.startClient();
        Thread longRunningQryThread = new Thread(() -> {
            try (FieldsQueryCursor qry = client.cache("TestCache").query(new SqlFieldsQuery("SELECT count(*), sleep() AS \"1\" FROM \"TestCache\".STRING").setDistributedJoins(true).setEnforceJoinOrder(true).setLazy(true));){
                qry.getAll();
            }
        });
        longRunningQryThread.start();
        Request req = new Request().setAction("QueryActions.runningQueries").setId(UUID.randomUUID()).setArgument((Object)new RunningQueriesArgument().setDuration(0L));
        this.executeAction((AbstractRequest)req, res -> {
            TaskResponse taskRes = this.taskResult(req.getId());
            if (taskRes != null && taskRes.getStatus() == Status.COMPLETED && taskRes.getJobCount() == 4) {
                List clientJobs = res.stream().filter(r -> r.getNodeConsistentId().equals(client.localNode().consistentId().toString())).collect(Collectors.toList());
                Assert.assertEquals((long)1L, (long)clientJobs.size());
                Map field = (Map)((ArrayList)((JobResponse)clientJobs.get(0)).getResult()).get(0);
                List queries = ((Collection)((JobResponse)clientJobs.get(0)).getResult()).stream().map(row -> (String)row.get("query")).collect(Collectors.toList());
                Assert.assertEquals((long)1L, (long)queries.size());
                Assert.assertEquals((Object)"SELECT count(*), sleep() AS \"1\" FROM \"TestCache\".STRING", queries.get(0));
                boolean enforceJoinOrder = (Boolean)field.get("enforceJoinOrder");
                boolean lazy = (Boolean)field.get("lazy");
                boolean distributedJoins = (Boolean)field.get("distributedJoins");
                boolean loc = (Boolean)field.get("local");
                String nodeId = (String)field.get("nodeId");
                return enforceJoinOrder && lazy && distributedJoins && !loc && client.localNode().id().toString().equals(nodeId);
            }
            return false;
        });
        longRunningQryThread.interrupt();
    }

    @Test
    public void shouldReturnQueryHistory() {
        IgniteCache cache = this.createCacheWithSqlTestFunctions(1);
        this.populateCache(cache);
        TestSqlTestFunctions.sleepMs = 5000L;
        Request sqlQryReq = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*), sleep() FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache"));
        this.executeAction((AbstractRequest)sqlQryReq, res -> {
            TaskResponse taskRes = this.taskResult(sqlQryReq.getId());
            return taskRes != null && taskRes.getStatus() == Status.COMPLETED;
        });
        Request scanQryReq = new Request().setAction("QueryActions.executeScanQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new ScanQueryArgument().setQueryId(UUID.randomUUID().toString()).setCacheName("TestCache").setPageSize(1000));
        this.executeAction((AbstractRequest)scanQryReq, res -> {
            TaskResponse taskRes = this.taskResult(scanQryReq.getId());
            return taskRes != null && taskRes.getStatus() == Status.COMPLETED;
        });
        Request req = new Request().setAction("QueryActions.history").setId(UUID.randomUUID()).setArgument((Object)new QueryHistoryArgument().setSince(1L)).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(req.getId());
            if (taskRes != null && taskRes.getStatus() == Status.COMPLETED && taskRes.getJobCount() == 1) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray results = (JSONArray)ctx.read("$[*]", new Predicate[0]);
                JSONArray qryTypes = (JSONArray)ctx.read("$[*].queryType", new Predicate[0]);
                JSONArray queries = (JSONArray)ctx.read("$[*].query", new Predicate[0]);
                return results.size() == 2 && qryTypes.stream().allMatch(t -> t.equals("SCAN") || t.equals("SQL_FIELDS")) && queries.stream().allMatch(q -> q.equals("SELECT count(*), sleep() FROM \"TestCache\".STRING") || q.equals("TestCache"));
            }
            return false;
        });
    }

    @Test
    public void shouldReturnQueryHistoryForQueriesInvokedByDirectApi() {
        GridQueryProcessor qryProc = ((IgniteEx)this.cluster.ignite()).context().query();
        IgniteCache cache = this.createCacheWithSqlTestFunctions(1);
        this.populateCache(cache);
        TestSqlTestFunctions.sleepMs = 5000L;
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT count(*), sleep() FROM \"TestCache\".STRING");
        qry.setSchema("TestCache");
        try (FieldsQueryCursor lists = qryProc.querySqlFields(qry, true);){
            lists.getAll();
        }
        cache.withKeepBinary().query((Query)new ScanQuery()).getAll();
        Request req = new Request().setAction("QueryActions.history").setId(UUID.randomUUID()).setArgument((Object)new QueryHistoryArgument().setSince(1L)).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(req.getId());
            if (taskRes != null && taskRes.getStatus() == Status.COMPLETED && taskRes.getJobCount() == 1) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray results = (JSONArray)ctx.read("$[*]", new Predicate[0]);
                JSONArray qryTypes = (JSONArray)ctx.read("$[*].queryType", new Predicate[0]);
                JSONArray queries = (JSONArray)ctx.read("$[*].query", new Predicate[0]);
                return results.size() == 2 && qryTypes.stream().allMatch(t -> t.equals("SCAN") || t.equals("SQL_FIELDS")) && queries.stream().allMatch(q -> q.equals("SELECT count(*), sleep() FROM \"TestCache\".STRING") || q.equals("TestCache"));
            }
            return false;
        });
    }

    @Test
    public void shouldReturnQueryHistoryWithFailedQuery() {
        IgniteCache cache = this.createCacheWithSqlTestFunctions(1);
        this.populateCache(cache);
        Request sqlQryReq = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*), can_fail(TRUE) FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache"));
        this.executeAction((AbstractRequest)sqlQryReq, res -> {
            TaskResponse taskRes = this.taskResult(sqlQryReq.getId());
            return taskRes != null && taskRes.getStatus() == Status.FAILED;
        });
        Request req = new Request().setAction("QueryActions.history").setId(UUID.randomUUID()).setArgument((Object)new QueryHistoryArgument().setSince(1L)).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(req.getId());
            if (taskRes != null && taskRes.getStatus() == Status.COMPLETED && taskRes.getJobCount() == 1) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray results = (JSONArray)ctx.read("$[*]", new Predicate[0]);
                JSONArray queries = (JSONArray)ctx.read("$[*].query", new Predicate[0]);
                return results.size() == 1 && queries.stream().allMatch(q -> q.equals("SELECT count(*), can_fail(TRUE) FROM \"TestCache\".STRING"));
            }
            return false;
        });
    }

    @Test
    public void shouldReturnNonWrappedExceptionInJobResponse() {
        Request sqlQryReq = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*), can_fail(TRUE) FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache"));
        this.executeAction((AbstractRequest)sqlQryReq, res -> {
            JobResponse jobRes = this.jobResult(sqlQryReq.getId());
            if (jobRes == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)jobRes.getStatus());
            ResponseError err = jobRes.getError();
            Assert.assertEquals((long)-32603L, (long)err.getCode());
            Assert.assertEquals((Object)DbException.class.getName(), (Object)err.getStackTrace()[0].getClassName());
            return true;
        });
    }

    @Test
    public void shouldCancelQueryOnClose() {
        IgniteCache cache = this.createCacheWithSqlTestFunctions(1);
        this.populateCache(cache);
        TestSqlTestFunctions.sleepMs = 5000L;
        UUID reqId = UUID.randomUUID();
        Request sqlTimeoutQryReq = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(reqId).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*), sleep() FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache"));
        Assert.assertThrows(ConditionTimeoutException.class, () -> this.executeAction(sqlTimeoutQryReq, Duration.ofSeconds(2L), res -> {
            TaskResponse taskRes = this.taskResult(sqlTimeoutQryReq.getId());
            return taskRes != null && taskRes.getStatus() == Status.COMPLETED;
        }));
        Request sqlQryReq = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(reqId).setArgument((Object)new QueryArgument().setQueryId(UUID.randomUUID().toString()).setQueryText("SELECT count(*) FROM \"TestCache\".STRING").setPageSize(1).setDefaultSchema("TestCache"));
        this.executeAction(sqlQryReq, Duration.ofSeconds(2L), res -> {
            TaskResponse taskRes = this.taskResult(sqlQryReq.getId());
            return taskRes != null && taskRes.getStatus() == Status.COMPLETED;
        });
    }

    @Test
    public void shouldUpdateRunningQueriesConfiguration() {
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)this.ignite(0));
        DistributedRunningQueryExporterConfiguration exporterCfg = agent.runningQueryExporterConfiguration();
        long dfltRunningQryMinDuration = exporterCfg.getDefaultRunningQueryMinDuration();
        Assert.assertEquals((long)0L, (long)dfltRunningQryMinDuration);
        Request updateQryCfgReq = new Request().setAction("QueryActions.updateRunningQueryConfiguration").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new RunningQueryConfigurationArgument().setDuration(2000L));
        this.executeAction(updateQryCfgReq, Duration.ofSeconds(2L), res -> {
            TaskResponse taskRes = this.taskResult(updateQryCfgReq.getId());
            return taskRes.getStatus() == Status.COMPLETED && exporterCfg.getDefaultRunningQueryMinDuration() == 2000L;
        });
    }

    @Test
    public void shouldGetRunningQueriesConfiguration() throws IgniteCheckedException {
        Request getQryCfgReq = new Request().setAction("QueryActions.getRunningQueryConfiguration").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setId(UUID.randomUUID());
        this.executeAction(getQryCfgReq, Duration.ofSeconds(2L), res -> {
            JobResponse jobRes = this.jobResult(getQryCfgReq.getId());
            if (jobRes == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)jobRes.getStatus());
            RunningQueryConfiguration cfg = this.result(jobRes, new TypeReference<RunningQueryConfiguration>(){});
            Assert.assertEquals((long)0L, (long)cfg.getDuration());
            return true;
        });
        DistributedChangeableProperty prop = this.ignite(0).context().distributedConfiguration().property("runningQueryMinimumDuration");
        prop.propagate((Serializable)Long.valueOf(3333L));
        getQryCfgReq.setId(UUID.randomUUID());
        this.executeAction(getQryCfgReq, Duration.ofSeconds(2L), res -> {
            JobResponse jobRes = (JobResponse)F.first((List)res);
            if (jobRes == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)jobRes.getStatus());
            RunningQueryConfiguration cfg = this.result(jobRes, new TypeReference<RunningQueryConfiguration>(){});
            Assert.assertEquals((long)3333L, (long)cfg.getDuration());
            return true;
        });
    }

    private String getCreateQuery() {
        return this.getCreateQuery("mc_agent_test_table", null);
    }

    private String getCreateQuery(String name, String additionalParams) {
        return "CREATE TABLE " + name + " (id int, value int, PRIMARY KEY (id)) " + (additionalParams != null ? "WITH \"" + additionalParams + "\"" : "") + ";";
    }

    private String getInsertQuery(int id, int val) {
        return this.getInsertQuery("mc_agent_test_table", id, val);
    }

    private String getInsertQuery(String name, int id, int val) {
        return String.format("INSERT INTO " + name + " VALUES(%s, %s);", id, val);
    }

    private String getSelectQuery() {
        return this.getSelectQuery("mc_agent_test_table");
    }

    private String getSelectQuery(String name) {
        return "SELECT * FROM " + name + " ORDER BY ID;";
    }

    private String getSelectQueryWithParameter() {
        return "SELECT * FROM mc_agent_test_table WHERE id = ?;";
    }

    private DocumentContext parse(Object obj) {
        try {
            return JsonPath.parse((String)this.mapper.writeValueAsString(obj));
        }
        catch (JsonProcessingException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private <K, V> IgniteCache<K, V> createCacheWithSqlTestFunctions(int qryDetailMetricsSz) {
        CacheConfiguration cfg = this.cacheConfiguration("TestCache").setQueryDetailMetricsSize(qryDetailMetricsSz).setIndexedTypes(new Class[]{Integer.class, String.class}).setSqlFunctionClasses(new Class[]{TestSqlTestFunctions.class});
        return this.cluster.ignite().getOrCreateCache(cfg);
    }

    private void populateCache(IgniteCache<Integer, String> cache) {
        HashMap data = U.newHashMap((int)1000);
        for (int i = 0; i < 1000; ++i) {
            data.put(i, Integer.toString(i));
        }
        cache.putAll((Map)data);
    }

    private void assertRequestExecution(Request req, String expKey, String expVal) {
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray resArr = (JSONArray)ctx.read("$[*]]", new Predicate[0]);
                JSONArray arr = (JSONArray)ctx.read("$[0].rows[*]", new Predicate[0]);
                boolean hasMore = (Boolean)ctx.read("$[0].hasMore", new Predicate[0]);
                String id = (String)ctx.read("$[0].rows[0][1]", new Predicate[0]);
                String val = (String)ctx.read("$[0].rows[0][3]", new Predicate[0]);
                return resArr.size() == 1 && arr.size() == 1 && !hasMore && expKey.equals(id) && expVal.equals(val);
            }
            return false;
        });
    }

    private void assertRequestExecutionEmpty(Request req) {
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r != null && r.getStatus() == Status.COMPLETED) {
                DocumentContext ctx = this.parse(r.getResult());
                JSONArray resArr = (JSONArray)ctx.read("$[*]]", new Predicate[0]);
                JSONArray arr = (JSONArray)ctx.read("$[0].rows[*]", new Predicate[0]);
                boolean hasMore = (Boolean)ctx.read("$[0].hasMore", new Predicate[0]);
                return resArr.size() == 1 && arr.isEmpty() && !hasMore;
            }
            return false;
        });
    }
}

