/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.resource.DependencyResolver;
import org.apache.ignite.internal.util.typedef.F;
import org.assertj.core.api.Assertions;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.junit.Assert;
import org.junit.Test;

public class NodeActionsControllerTest
extends AbstractActionControllerTest {
    @Test
    public void configuration() {
        List<String> cfgProps = Arrays.asList("\"igniteInstanceName\":\"node-0\"", "\"daemon\":false", "\"clientMode\":false", "\"sqlQueryHistorySize\":1000");
        UUID nid = this.cluster.localNode().id();
        Request req = new Request().setId(UUID.randomUUID()).setAction("NodeActions.configuration").setNodeIds(Collections.singleton(nid));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            Assert.assertTrue((boolean)ClusterState.active((ClusterState)this.cluster.state()));
            Assert.assertTrue((boolean)(r.getResult() instanceof String));
            String json = (String)r.getResult();
            cfgProps.forEach(s -> Assert.assertTrue((boolean)json.contains((CharSequence)s)));
            return true;
        });
    }

    @Test
    public void configurationFailure() throws Exception {
        try (IgniteEx grid = this.startGrid(new FailureDependencyResolver());){
            UUID nid = grid.cluster().localNode().id();
            Request req = new Request().setId(UUID.randomUUID()).setAction("NodeActions.configuration").setNodeIds(Collections.singleton(nid));
            this.executeAction((AbstractRequest)req, res -> {
                JobResponse r = (JobResponse)F.first((List)res);
                if (r == null) {
                    return false;
                }
                Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
                Assertions.assertThat((String)r.getError().getMessage()).startsWith((CharSequence)"Failed to get configuration for node ");
                return true;
            });
        }
    }

    @Test
    public void gc() {
        UUID nid = this.cluster.localNode().id();
        Request req = new Request().setId(UUID.randomUUID()).setAction("NodeActions.gc").setNodeIds(Collections.singleton(nid));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            return true;
        });
    }

    @Test
    public void threadDump() {
        UUID nid = this.cluster.localNode().id();
        Request req = new Request().setId(UUID.randomUUID()).setAction("NodeActions.threadDump").setNodeIds(Collections.singleton(nid));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertNotNull((Object)r.getResult());
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            return true;
        });
    }

    private static class FailureDependencyResolver
    implements DependencyResolver {
        private static final ObjectMapper testMapper = new ObjectMapper();

        private FailureDependencyResolver() {
        }

        public <T> T resolve(T instance) {
            if (instance instanceof ObjectMapper) {
                return (T)testMapper;
            }
            return instance;
        }
    }
}

