/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.UpdateClusterLicenseArgument;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.product.ProductLicense;
import org.gridgain.grid.product.ProductLicenseException;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;

public class LicenseActionsControllerTest
extends AbstractActionControllerTest {
    protected static final String VALID_LICENSE = "src/test/resources/license/valid-license.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUpdateLicense() throws IOException, ProductLicenseException {
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        ProductLicense oldLicense = gg.product().license();
        String curLic = FileUtils.readFileToString((File)new File(this.getDefaultLicensePath()), (Charset)Charset.defaultCharset());
        try {
            String newLic = FileUtils.readFileToString((File)new File(VALID_LICENSE), (Charset)Charset.defaultCharset());
            Request req = new Request().setId(UUID.randomUUID()).setAction("LicenseActions.uploadLicense").setArgument((Object)new UpdateClusterLicenseArgument().setLicense(newLic));
            this.executeAction((AbstractRequest)req, res -> {
                JobResponse r = (JobResponse)F.first((List)res);
                if (r == null) {
                    return false;
                }
                ProductLicense newLicense = gg.product().license();
                Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
                Assertions.assertNotEquals((Object)oldLicense.id(), (Object)newLicense.id());
                return true;
            });
        }
        finally {
            gg.product().updateLicense(curLic);
        }
    }

    @Test
    public void shouldThrowErrorIfLicenseIsEmpty() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("LicenseActions.uploadLicense").setArgument((Object)new UpdateClusterLicenseArgument().setLicense(""));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assertions.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assertions.assertEquals((int)-32700, (int)r.getError().getCode());
            Assertions.assertEquals((Object)"License content is empty", (Object)r.getError().getMessage());
            return true;
        });
    }

    @Test
    public void shouldReturnLicense() {
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        ProductLicense actualLicense = gg.product().license();
        Request req = new Request().setId(UUID.randomUUID()).setAction("LicenseActions.getLicense");
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            String licenseId = (String)JsonPath.read((String)((String)r.getResult()), (String)"$.id", (Predicate[])new Predicate[0]);
            Assertions.assertEquals((Object)actualLicense.id().toString(), (Object)licenseId);
            return true;
        });
    }
}

