/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithGridGainSecurityTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.compute.ChangePriorityTaskArgument;
import org.gridgain.control.agent.dto.action.compute.TaskArgument;
import org.gridgain.control.agent.dto.action.compute.TaskStatisticArgument;
import org.gridgain.control.agent.dto.action.compute.TaskStatisticResponse;
import org.gridgain.control.agent.test.TestTask;
import org.junit.Test;

public class ComputeActionsControllerWithGridGainSecurityTest
extends AbstractActionControllerWithGridGainSecurityTest {
    private static final String FULL_ACCESS_USERNAME = "fullAccess";
    private static final String ADMIN_OPS_ACCOUNT = "adminOps";
    private static final String TASK_CANCEL_ACCOUNT = "taskCancel";

    @Override
    protected Map<SecurityCredentials, String> prepareCustomCredentials() {
        HashMap<SecurityCredentials, String> creds = new HashMap<SecurityCredentials, String>(2);
        creds.put(new SecurityCredentials(FULL_ACCESS_USERNAME, "123456"), "{     defaultAllow: true}");
        creds.put(new SecurityCredentials("server", "123456"), "{    defaultAllow: false,    {        cache:'*',        permissions:[CACHE_PUT, CACHE_READ, CACHE_REMOVE, CACHE_CREATE]    },     {        task:'org.gridgain.control.agent.commandline.*',        permissions:[TASK_EXECUTE]    },     {        task:'org.gridgain.control.agent.test.*',        permissions:[TASK_EXECUTE]    },     {        system:[JOIN_AS_SERVER, EVENTS_ENABLE, ADMIN_OPS]    }}");
        creds.put(new SecurityCredentials(ADMIN_OPS_ACCOUNT, "123456"), "{     defaultAllow: false,    {        system:[ADMIN_OPS]    }}");
        creds.put(new SecurityCredentials(TASK_CANCEL_ACCOUNT, "123456"), "{     defaultAllow: false,    {        task:'*',        permissions:[TASK_CANCEL]    }}");
        return creds;
    }

    @Override
    protected int clusterSize() {
        return 2;
    }

    private boolean checkSecureTaskStatisticExecution(String acc, String psw, UUID nid, IgniteUuid taskSesId, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, psw)));
        Request req = new Request().setId(UUID.randomUUID()).setSessionId(sesId).setAction("ComputeActions.taskStatistics").setNodeIds(Collections.singleton(nid)).setArgument((Object)new TaskStatisticArgument().setSessionId(taskSesId));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            return resChecker.test(r);
        });
        return false;
    }

    @Test
    public void taskStatisticsWithDeniedUser() {
        ComputeTaskFuture fut = this.cluster.ignite().compute().executeAsync(TestTask.class, (Object)5000L);
        UUID nid = fut.getTaskSession().getTaskNodeId();
        IgniteUuid taskSesId = fut.getTaskSession().getId();
        this.checkSecureTaskStatisticExecution("server", "123456", nid, taskSesId, r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void taskStatisticsWithAllowedUser() {
        ComputeTaskFuture fut = this.cluster.ignite().compute().executeAsync(TestTask.class, (Object)5000L);
        UUID nid = fut.getTaskSession().getTaskNodeId();
        IgniteUuid taskSesId = fut.getTaskSession().getId();
        this.checkSecureTaskStatisticExecution(FULL_ACCESS_USERNAME, "123456", nid, taskSesId, r -> {
            if (Status.COMPLETED != r.getStatus()) {
                return false;
            }
            List<TaskStatisticResponse> rows = this.result((JobResponse)r, new TypeReference<List<TaskStatisticResponse>>(){});
            if (this.clusterSize() != rows.size()) {
                return false;
            }
            TaskStatisticResponse row1 = rows.get(0);
            TaskStatisticResponse row2 = rows.get(1);
            return Objects.equals(1L, row1.getRunning() + row2.getRunning()) && Objects.equals(row1.getRunning(), row1.getTotal()) && Objects.equals(row2.getRunning(), row2.getTotal());
        });
    }

    @Test
    public void shouldPerformCancelWithTaskCancelAccount() {
        this.checkSecureCancel(TASK_CANCEL_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailCancelWithNoAccessAccount() {
        this.checkSecureCancel("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformChangePriorityWithAdminOpsAccount() throws InterruptedException {
        this.changePriority(ADMIN_OPS_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailChangePriorityWithNoAccessAccount() throws InterruptedException {
        this.changePriority("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    private void checkSecureCancel(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        ComputeTaskFuture fut = this.cluster.ignite().compute().executeAsync(TestTask.class, (Object)5000L);
        Request req = new Request().setId(UUID.randomUUID()).setAction("ComputeActions.cancel").setNodeIds(Collections.singleton(fut.getTaskSession().getTaskNodeId())).setSessionId(sesId).setArgument((Object)new TaskArgument().setSessionIds(Collections.singletonList(fut.getTaskSession().getId())));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void changePriority(String acc, String pwd, Predicate<JobResponse> resChecker) throws InterruptedException {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        ComputeTaskFuture fut = this.cluster.ignite().compute().executeAsync(TestTask.class, (Object)5000L);
        fut.getTaskSession().waitForAttribute((Object)"grid.task.priority", (Object)0, 1000L);
        Request req = new Request().setId(UUID.randomUUID()).setAction("ComputeActions.changePriority").setNodeIds(Collections.singleton(fut.getTaskSession().getTaskNodeId())).setSessionId(sesId).setArgument((Object)new ChangePriorityTaskArgument().setPriority(10).setSessionIds(Collections.singletonList(fut.getTaskSession().getId())));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }
}

