/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.spi.collision.CollisionSpi;
import org.apache.ignite.spi.collision.priorityqueue.PriorityQueueCollisionSpi;
import org.assertj.core.api.Assertions;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.compute.ChangePriorityTaskArgument;
import org.gridgain.control.agent.dto.action.compute.TaskArgument;
import org.gridgain.control.agent.dto.action.compute.TaskStatisticArgument;
import org.gridgain.control.agent.dto.action.compute.TaskStatisticResponse;
import org.gridgain.control.agent.test.TestTask;
import org.junit.Assert;
import org.junit.Test;

public class ComputeActionsControllerTest
extends AbstractActionControllerTest {
    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        return super.getConfiguration(instanceName).setCollisionSpi((CollisionSpi)new PriorityQueueCollisionSpi());
    }

    @Override
    protected int clusterSize() {
        return 2;
    }

    @Test
    public void cancel() {
        ComputeTaskFuture fut = this.cluster.ignite().compute().executeAsync(TestTask.class, (Object)5000L);
        Request req = new Request().setId(UUID.randomUUID()).setAction("ComputeActions.cancel").setNodeIds(Collections.singleton(fut.getTaskSession().getTaskNodeId())).setArgument((Object)new TaskArgument().setSessionIds(Collections.singletonList(fut.getTaskSession().getId())));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            return true;
        });
        Assert.assertThrows(IgniteFutureCancelledException.class, () -> {
            Void cfr_ignored_0 = (Void)fut.get(5000L);
        });
    }

    @Test
    public void cancelOnMultipleNodes() {
        ComputeTaskFuture fut1 = this.ignite(0).compute().executeAsync(TestTask.class, (Object)5000L);
        ComputeTaskFuture fut2 = this.ignite(1).compute().executeAsync(TestTask.class, (Object)5000L);
        Request req = new Request().setId(UUID.randomUUID()).setAction("ComputeActions.cancel").setNodeIds(F.asSet((Object[])new UUID[]{fut1.getTaskSession().getTaskNodeId(), fut2.getTaskSession().getTaskNodeId()})).setArgument((Object)new TaskArgument().setSessionIds(Arrays.asList(fut1.getTaskSession().getId(), fut2.getTaskSession().getId())));
        this.executeAction((AbstractRequest)req, res -> {
            if (res.size() < 2) {
                return false;
            }
            Assertions.assertThat((List)res).allMatch(response -> response.getStatus() == Status.COMPLETED);
            return true;
        });
        Assert.assertThrows(IgniteFutureCancelledException.class, () -> {
            Void cfr_ignored_0 = (Void)fut1.get(5000L);
        });
        Assert.assertThrows(IgniteFutureCancelledException.class, () -> {
            Void cfr_ignored_0 = (Void)fut2.get(5000L);
        });
    }

    @Test
    public void changePriority() throws InterruptedException {
        ComputeTaskFuture fut = this.cluster.ignite().compute().executeAsync(TestTask.class, (Object)5000L);
        fut.getTaskSession().waitForAttribute((Object)"grid.task.priority", (Object)0, 1000L);
        Request req = new Request().setId(UUID.randomUUID()).setAction("ComputeActions.changePriority").setNodeIds(Collections.singleton(fut.getTaskSession().getTaskNodeId())).setArgument((Object)new ChangePriorityTaskArgument().setPriority(10).setSessionIds(Collections.singletonList(fut.getTaskSession().getId())));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            return true;
        });
        fut.getTaskSession().waitForAttribute((Object)"grid.task.priority", (Object)10, 1000L);
    }

    @Test
    public void changePriorityOnMultipleNodes() throws InterruptedException {
        this.changePriority(10);
        this.changePriority(-10);
    }

    @Test
    public void taskStatistics() {
        ComputeTaskFuture fut = this.cluster.ignite().compute().executeAsync(TestTask.class, (Object)5000L);
        Request req = new Request().setId(UUID.randomUUID()).setAction("ComputeActions.taskStatistics").setNodeIds(Collections.singleton(fut.getTaskSession().getTaskNodeId())).setArgument((Object)new TaskStatisticArgument().setSessionId(fut.getTaskSession().getId()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            List<TaskStatisticResponse> rows = this.result(r, new TypeReference<List<TaskStatisticResponse>>(){});
            Assert.assertEquals((long)this.clusterSize(), (long)rows.size());
            TaskStatisticResponse row1 = rows.get(0);
            TaskStatisticResponse row2 = rows.get(1);
            Assert.assertEquals((long)1L, (long)(row1.getRunning() + row2.getRunning()));
            Assert.assertEquals((long)row1.getRunning(), (long)row1.getTotal());
            Assert.assertEquals((long)row2.getRunning(), (long)row2.getTotal());
            return true;
        });
    }

    private void changePriority(int pri) throws InterruptedException {
        ComputeTaskFuture fut1 = this.ignite(0).compute().executeAsync(TestTask.class, (Object)5000L);
        ComputeTaskFuture fut2 = this.ignite(1).compute().executeAsync(TestTask.class, (Object)5000L);
        fut1.getTaskSession().waitForAttribute((Object)"grid.task.priority", (Object)0, 1000L);
        fut2.getTaskSession().waitForAttribute((Object)"grid.task.priority", (Object)0, 1000L);
        Request req = new Request().setId(UUID.randomUUID()).setAction("ComputeActions.changePriority").setNodeIds(F.asSet((Object[])new UUID[]{fut1.getTaskSession().getTaskNodeId(), fut2.getTaskSession().getTaskNodeId()})).setArgument((Object)new ChangePriorityTaskArgument().setPriority(pri).setSessionIds(Arrays.asList(fut1.getTaskSession().getId(), fut2.getTaskSession().getId())));
        this.executeAction((AbstractRequest)req, res -> {
            if (res.size() < 2) {
                return false;
            }
            Assertions.assertThat((List)res).allMatch(response -> response.getStatus() == Status.COMPLETED);
            return true;
        });
        fut1.getTaskSession().waitForAttribute((Object)"grid.task.priority", (Object)pri, 1000L);
        fut2.getTaskSession().waitForAttribute((Object)"grid.task.priority", (Object)pri, 1000L);
    }
}

