/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.builder.BinaryObjectBuilderImpl;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.awaitility.Awaitility;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.action.controller.ResourceController;
import org.gridgain.control.agent.action.controller.UploadedBinaryMetaController;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.BinarySchema;
import org.gridgain.control.agent.dto.action.BinaryTypeArgument;
import org.gridgain.control.agent.dto.action.BinaryTypeExportResponse;
import org.gridgain.control.agent.dto.action.BinaryTypeMetaInfo;
import org.gridgain.control.agent.dto.action.BinaryTypeMetaInfoResponse;
import org.gridgain.control.agent.dto.action.BinaryTypeMetaResponse;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.UpdateBinaryTypeArgument;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.web.multipart.MultipartFile;

public class BinaryTypeActionsControllerTest
extends AbstractActionControllerTest {
    @Autowired
    ResourceController rsrcController;
    @Autowired
    UploadedBinaryMetaController uploadedBinaryMetaController;

    private static Connection connect() throws Exception {
        return DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");
    }

    @Override
    public void teardown() {
        this.rsrcController.clear();
        this.uploadedBinaryMetaController.clear();
        super.teardown();
    }

    @Test
    public void metaAll() throws Exception {
        GridKernalContext ctx = ((IgniteEx)this.cluster.ignite()).context();
        this.assertEmptyBinaryMeta();
        this.createBinaryCache();
        Integer typeId = this.assertBinaryTypeMeta();
        this.cluster.ignite().destroyCache("testCache");
        ctx.cacheObjects().removeType(typeId.intValue());
        this.assertEmptyBinaryMeta();
    }

    @Test
    public void meta() throws Exception {
        this.createBinaryCache();
        Integer typeId = this.assertBinaryTypeMeta();
        Request req = new Request().setId(UUID.randomUUID()).setAction("BinaryTypeActions.meta").setArgument((Object)new BinaryTypeArgument().setTypeId(typeId.intValue())).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            BinaryTypeMetaResponse actRes = this.result(r, new TypeReference<BinaryTypeMetaResponse>(){});
            org.junit.jupiter.api.Assertions.assertEquals((Integer)typeId, (int)actRes.getId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Person", (Object)actRes.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"name", (Object)actRes.getAffinityKeyFieldName());
            Assertions.assertThat((List)actRes.getFields()).extracting(new String[]{"name", "typeName"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"id", "int"}), Tuple.tuple((Object[])new Object[]{"name", "String"}), Tuple.tuple((Object[])new Object[]{"age", "int"})});
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)actRes.getSchemas().size());
            Assertions.assertThat((List)((BinarySchema)actRes.getSchemas().get(0)).getFieldNames()).containsExactlyInAnyOrder((Object[])new String[]{"id", "name", "age"});
            return true;
        });
    }

    @Test
    public void meta_TypeNotFound() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("BinaryTypeActions.meta").setArgument((Object)new BinaryTypeArgument().setTypeId(1)).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            return true;
        });
    }

    @Test
    public void update() throws Exception {
        this.createBinaryCache();
        Integer typeId = this.assertBinaryTypeMeta();
        UUID rsrcId = UUID.fromString("3ae02bd5-f7ab-4600-b875-7898f0395c74");
        this.putTypeToResource(typeId, rsrcId);
        this.assertUpdate(rsrcId);
        this.assertBinaryTypeMeta();
    }

    @Test
    public void update_RemovedType() throws Exception {
        GridKernalContext ctx = ((IgniteEx)this.cluster.ignite()).context();
        this.createBinaryCache();
        Integer typeId = this.assertBinaryTypeMeta();
        UUID rsrcId = UUID.fromString("3ae02bd5-f7ab-4600-b875-7898f0395c74");
        this.putTypeToResource(typeId, rsrcId);
        ctx.cacheObjects().removeType(typeId.intValue());
        this.assertEmptyBinaryMeta();
        this.assertUpdate(rsrcId);
        this.assertBinaryTypeMeta();
    }

    @Test
    public void update_resourceNotFound() throws Exception {
        Request req = new Request().setId(UUID.randomUUID()).setAction("BinaryTypeActions.update").setArgument((Object)new UpdateBinaryTypeArgument().setCoordinate(this.rsrcController.coordinate(UUID.randomUUID()))).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            org.junit.jupiter.api.Assertions.assertEquals((int)-32603, (int)r.getError().getCode());
            return true;
        });
    }

    @Test
    public void update_invalidResource() {
        UUID rsrcId = UUID.fromString("3ae02bd5-f7ab-4600-b875-7898f0395c74");
        this.rsrcController.put(rsrcId, (Resource)new ByteArrayResource("data".getBytes()));
        Request req = new Request().setId(UUID.randomUUID()).setAction("BinaryTypeActions.update").setArgument((Object)new UpdateBinaryTypeArgument().setCoordinate(this.rsrcController.coordinate(rsrcId))).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            org.junit.jupiter.api.Assertions.assertEquals((int)-32603, (int)r.getError().getCode());
            return true;
        });
    }

    @Test
    public void remove() throws Exception {
        this.createBinaryCache();
        Integer typeId = this.assertBinaryTypeMeta();
        Request req = new Request().setId(UUID.randomUUID()).setAction("BinaryTypeActions.remove").setArgument((Object)new BinaryTypeArgument().setTypeId(typeId.intValue())).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        try (Connection connect0 = BinaryTypeActionsControllerTest.connect();
             Statement statement0 = connect0.createStatement();
             Statement statement1 = connect0.createStatement();){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)statement0.execute("SELECT 1"));
            this.executeAction((AbstractRequest)req, res -> {
                JobResponse r = (JobResponse)F.first((List)res);
                if (r == null) {
                    return false;
                }
                org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
                return true;
            });
            this.assertEmptyBinaryMeta();
            this.assertStatementClosed(statement1);
        }
    }

    @Test
    public void remove_TypeNotFound() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("BinaryTypeActions.remove").setArgument((Object)new BinaryTypeArgument().setTypeId(123)).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            return true;
        });
    }

    @Test
    public void export() throws Exception {
        this.createBinaryCache();
        Integer typeId = this.assertBinaryTypeMeta();
        GridKernalContext ctx = ((IgniteEx)this.cluster.ignite()).context();
        BinaryMetadata meta = ((CacheObjectBinaryProcessorImpl)ctx.cacheObjects()).binaryMetadata(typeId.intValue());
        byte[] marshalled = U.marshal((GridKernalContext)ctx, (Object)meta);
        Request req = new Request().setId(UploadedBinaryMetaController.SUFFICIENT_REQUEST_ID).setAction("BinaryTypeActions.export").setArgument((Object)new BinaryTypeArgument().setTypeId(typeId.intValue())).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        CompletableFuture resIdFut = new CompletableFuture();
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            BinaryTypeExportResponse actRes = this.result(r, new TypeReference<BinaryTypeExportResponse>(){});
            org.junit.jupiter.api.Assertions.assertNotNull((Object)actRes.getResourceId());
            resIdFut.complete(actRes.getResourceId());
            return true;
        });
        UUID resId = UUID.fromString((String)resIdFut.get());
        MultipartFile multipartFile = this.uploadedBinaryMetaController.getMultipartFileMap().get(resId);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)multipartFile);
        org.junit.jupiter.api.Assertions.assertEquals((Object)(typeId + ".bin"), (Object)multipartFile.getOriginalFilename());
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])marshalled, (byte[])multipartFile.getBytes());
    }

    @Test
    public void export_TypeNotFound() throws Exception {
        Request req = new Request().setId(UploadedBinaryMetaController.SUFFICIENT_REQUEST_ID).setAction("BinaryTypeActions.export").setArgument((Object)new BinaryTypeArgument().setTypeId(123)).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            return true;
        });
    }

    @Test
    public void export_BadRequestId() throws Exception {
        this.createBinaryCache();
        Integer typeId = this.assertBinaryTypeMeta();
        Request req = new Request().setId(UUID.randomUUID()).setAction("BinaryTypeActions.export").setArgument((Object)new BinaryTypeArgument().setTypeId(typeId.intValue())).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            return true;
        });
    }

    private void putTypeToResource(Integer typeId, UUID rsrcId) throws IgniteCheckedException {
        GridKernalContext ctx = ((IgniteEx)this.cluster.ignite()).context();
        BinaryMetadata meta = ((CacheObjectBinaryProcessorImpl)ctx.cacheObjects()).binaryMetadata(typeId.intValue());
        byte[] marshalled = U.marshal((GridKernalContext)ctx, (Object)meta);
        this.rsrcController.put(rsrcId, (Resource)new ByteArrayResource(marshalled));
    }

    private void assertUpdate(UUID rsrcId) {
        Request req = new Request().setId(UUID.randomUUID()).setAction("BinaryTypeActions.update").setArgument((Object)new UpdateBinaryTypeArgument().setCoordinate(this.rsrcController.coordinate(rsrcId))).setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            return true;
        });
    }

    private Integer assertBinaryTypeMeta() throws Exception {
        Request req = new Request().setId(UUID.randomUUID()).setAction("BinaryTypeActions.metaAll").setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        CompletableFuture typeIdFut = new CompletableFuture();
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            BinaryTypeMetaInfoResponse actRes = this.result(r, new TypeReference<BinaryTypeMetaInfoResponse>(){});
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)actRes.getMetaInfoList().size());
            BinaryTypeMetaInfo info = (BinaryTypeMetaInfo)actRes.getMetaInfoList().get(0);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Person", (Object)info.getName());
            typeIdFut.complete(info.getId());
            return true;
        });
        return (Integer)typeIdFut.get(2L, TimeUnit.SECONDS);
    }

    private void createBinaryCache() {
        BinaryObjectBuilderImpl builder = (BinaryObjectBuilderImpl)this.cluster.ignite().binary().builder("Person").setField("id", (Object)1, Integer.TYPE).setField("name", (Object)"Joe", String.class).setField("age", (Object)30, Integer.class);
        builder.affinityFieldName("name");
        this.cluster.ignite().getOrCreateCache("testCache").withKeepBinary().put((Object)1, (Object)builder.build());
    }

    private void assertEmptyBinaryMeta() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("BinaryTypeActions.metaAll").setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            BinaryTypeMetaInfoResponse actRes = this.result(r, new TypeReference<BinaryTypeMetaInfoResponse>(){});
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)actRes.getMetaInfoList().size());
            return true;
        });
    }

    private void assertStatementClosed(Statement statement) {
        Awaitility.with().pollInterval(500L, TimeUnit.MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS).until(() -> {
            try {
                statement.execute("SELECT 1;SELECT 1;");
            }
            catch (SQLException e) {
                return true;
            }
            return false;
        });
    }
}

