/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.baseline.AutoAdjustAwaitingTimeArgument;
import org.gridgain.control.agent.dto.action.baseline.AutoAdjustEnableArgument;
import org.gridgain.control.agent.dto.action.baseline.BaselineTopologyArgument;
import org.junit.Test;

public class BaselineActionsControllerTest
extends AbstractActionControllerTest {
    @Test
    public void updateAutoAdjustEnabledToTrue() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("BaselineActions.updateAutoAdjustEnabled").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new AutoAdjustEnableArgument().setAutoAdjustEnabled(true));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED && this.cluster.isBaselineAutoAdjustEnabled();
        });
    }

    @Test
    public void updateAutoAdjustEnabledToFalse() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("BaselineActions.updateAutoAdjustEnabled").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new AutoAdjustEnableArgument().setAutoAdjustEnabled(false));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED && !this.cluster.isBaselineAutoAdjustEnabled();
        });
    }

    @Test
    public void updateAutoAdjustAwaitingTime() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("BaselineActions.updateAutoAdjustAwaitingTime").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new AutoAdjustAwaitingTimeArgument().setAwaitingTime(10000L));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED && this.cluster.baselineAutoAdjustTimeout() == 10000L;
        });
    }

    @Test
    public void setBaselineTopology() {
        this.cluster.baselineAutoAdjustEnabled(false);
        IgniteEx ignite_2 = this.startGrid(2);
        IgniteEx ignite_3 = this.startGrid(3);
        List<String> ids = Arrays.asList(this.cluster.localNode().consistentId().toString(), ignite_2.cluster().localNode().consistentId().toString(), ignite_3.cluster().localNode().consistentId().toString());
        Request req = new Request().setId(UUID.randomUUID()).setAction("BaselineActions.setBaselineTopology").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new BaselineTopologyArgument().setConsistentIds(ids));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED && this.cluster.currentBaselineTopology().size() == 3;
        });
    }
}

