/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action;

import java.util.UUID;
import org.apache.ignite.IgniteAuthenticationException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.action.Session;
import org.gridgain.control.agent.action.SessionRegistry;
import org.gridgain.control.agent.configuration.ControlCenterAgentConfiguration;
import org.gridgain.control.agent.test.TestLogger;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentUtils;
import org.junit.Assert;
import org.junit.Test;

public class SessionRegistryTest
extends AgentCommonAbstractTest {
    private IgniteEx ignite;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.ignite = this.startGrid();
        this.ignite.cluster().state(ClusterState.ACTIVE);
    }

    @Test
    public void shouldSaveSession() throws Exception {
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)this.ignite);
        SessionRegistry registry = agent.sessionRegistry();
        Session ses = Session.random();
        registry.saveSession(ses);
        Assert.assertNotNull((Object)registry.getSession(ses.id()));
    }

    @Test
    public void shouldThrowExceptionWhenTryToGetSessionByNullId() {
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)this.ignite);
        SessionRegistry registry = agent.sessionRegistry();
        TestUtils.assertThrows(() -> registry.getSession(null), IgniteAuthenticationException.class, "Invalid session ID: null");
    }

    @Test
    public void shouldThrowExceptionWhenTryToGetSessionByNotExistingId() {
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)this.ignite);
        SessionRegistry registry = agent.sessionRegistry();
        UUID sesId = UUID.randomUUID();
        TestUtils.assertThrows(() -> registry.getSession(sesId), IgniteAuthenticationException.class, "Session not found for ID: " + sesId);
    }

    @Test
    public void shouldRemoveTimeoutedSession() throws Exception {
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)this.ignite);
        SessionRegistry registry = agent.sessionRegistry();
        Session ses = Session.random();
        ControlCenterAgentConfiguration testCfg = agent.configuration().setSecuritySessionTimeout(100L);
        agent.configuration(testCfg);
        registry.saveSession(ses);
        Thread.sleep(200L);
        TestUtils.assertThrows(() -> registry.getSession(ses.id()), IgniteAuthenticationException.class, "Session not found for ID: " + ses.id());
    }

    @Test
    public void shouldNotRemoveSessionIfWeTouchIt() throws Exception {
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)this.ignite);
        SessionRegistry registry = agent.sessionRegistry();
        Session ses = Session.random();
        ControlCenterAgentConfiguration testCfg = agent.configuration().setSecuritySessionTimeout(100L);
        agent.configuration(testCfg);
        registry.saveSession(ses);
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(50L);
            registry.getSession(ses.id());
        }
        Assert.assertNotNull((Object)registry.getSession(ses.id()));
    }

    @Test
    public void shouldUpdateLastInvalidateTime() throws Exception {
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)this.ignite);
        SessionRegistry registry = agent.sessionRegistry();
        Session ses = Session.random();
        ControlCenterAgentConfiguration testCfg = agent.configuration().setSecuritySessionExpirationTimeout(100L);
        agent.configuration(testCfg);
        ses.credentials(new SecurityCredentials("ignite", "ignite"));
        long oldLastInvalidateTime = ses.lastInvalidateTime();
        registry.saveSession(ses);
        Thread.sleep(110L);
        Assert.assertTrue((oldLastInvalidateTime < registry.getSession(ses.id()).lastInvalidateTime() ? 1 : 0) != 0);
    }

    @Test
    public void shouldRemoveSessionAfterInvalidateSessionWithoutCredentials() throws Exception {
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)this.ignite);
        SessionRegistry registry = agent.sessionRegistry();
        Session ses = Session.random();
        ControlCenterAgentConfiguration testCfg = agent.configuration().setSecuritySessionExpirationTimeout(100L);
        agent.configuration(testCfg);
        registry.saveSession(ses);
        Thread.sleep(110L);
        TestUtils.assertThrows(() -> registry.getSession(ses.id()), IgniteAccessControlException.class, "The user name or password is incorrect [userName=" + ses.credentials().getLogin() + ']');
        TestUtils.assertThrows(() -> registry.getSession(ses.id()), IgniteAuthenticationException.class, "Session not found for ID: " + ses.id());
    }

    @Test
    public void shouldRemoveSessionAfterInvalidateSessionWithIncorrectCredentials() throws Exception {
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)this.ignite);
        SessionRegistry registry = agent.sessionRegistry();
        Session ses = Session.random();
        ControlCenterAgentConfiguration testCfg = agent.configuration().setSecuritySessionExpirationTimeout(100L);
        agent.configuration(testCfg);
        ses.credentials(new SecurityCredentials("ignite", "ignite2"));
        registry.saveSession(ses);
        Thread.sleep(110L);
        TestUtils.assertThrows(() -> registry.getSession(ses.id()), IgniteAccessControlException.class, "The user name or password is incorrect [userName=" + ses.credentials().getLogin() + ']');
        TestUtils.assertThrows(() -> registry.getSession(ses.id()), IgniteAuthenticationException.class, "Session not found for ID: " + ses.id());
    }

    @Test
    public void shouldLoadPersistedSessionProperties() throws Exception {
        long TEST_SES_TTL = 99L;
        long TEST_SES_EXP_TTL = 101L;
        this.changeAgentConfiguration(this.ignite);
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)this.ignite);
        ControlCenterAgentConfiguration testCfg = agent.configuration().setSecuritySessionTimeout(99L).setSecuritySessionExpirationTimeout(101L);
        agent.configuration(testCfg);
        this.stopAllGrids();
        TestLogger log = new TestLogger();
        this.ignite = this.startNodeWithTestLogger(log, "node-1");
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
        agent = AgentUtils.ggccAgent((IgniteEx)this.ignite);
        SessionRegistry registry = agent.sessionRegistry();
        Assert.assertEquals((long)agent.configuration().getSecuritySessionTimeout(), (long)99L);
        Assert.assertEquals((long)agent.configuration().getSecuritySessionExpirationTimeout(), (long)101L);
        Assert.assertEquals((long)registry.getSessionTTL(), (long)99L);
        Assert.assertEquals((long)registry.getSessionExpirationTTL(), (long)101L);
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        IgniteConfiguration configuration = super.getConfiguration(instanceName);
        configuration.setAuthenticationEnabled(true);
        return configuration;
    }
}

