/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent;

import java.io.Serializable;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.resource.GridResourceProcessor;
import org.apache.ignite.internal.processors.ru.IgniteRollingUpgradeStatus;
import org.apache.ignite.internal.processors.ru.RollingUpgrade;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.CachePluginContext;
import org.apache.ignite.plugin.CachePluginProvider;
import org.apache.ignite.plugin.ExtensionRegistry;
import org.apache.ignite.plugin.IgnitePlugin;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.PluginValidationException;
import org.assertj.core.api.Assertions;
import org.awaitility.core.ConditionTimeoutException;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.ControlCenterAgentProvider;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.config.TestHandshakeInterceptor;
import org.gridgain.control.agent.configuration.ControlCenterAgentConfiguration;
import org.gridgain.control.agent.configuration.DistributedMetricExporterConfiguration;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.query.QueryArgument;
import org.gridgain.control.agent.dto.cluster.ClusterInfo;
import org.gridgain.control.agent.processor.AbstractServiceTest;
import org.gridgain.control.agent.processor.AgentConfigurationProcessor;
import org.gridgain.control.agent.processor.export.metric.MetricsSenderProcessor;
import org.gridgain.control.agent.processor.feature.AgentDynamicFeatureProcessor;
import org.gridgain.control.agent.test.InvalidUsagesLogger;
import org.gridgain.control.agent.test.TestLogger;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentUtils;
import org.gridgain.grid.internal.GridPluginProvider;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;

public class ControlCenterAgentTest
extends AgentCommonAbstractTest {
    private static final String AGENT_BANNER = "Open the link in a browser to monitor your cluster:";
    private static final String UNSUPPORTED_AGENT_PROTOCOL_MSG = "Unsupported version of Control Center agent protocol";
    @Autowired
    private TestHandshakeInterceptor handshakeInterceptor;

    @Override
    @After
    public void teardown() {
        super.teardown();
        this.checkThreads(true);
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        return super.getConfiguration("src/test/resources/ignite-cfg-without-agent.xml", instanceName);
    }

    @Test
    public void shouldStopTheAgentCorrectly() {
        IgniteEx first = this.startGrid(0);
        IgniteEx second = this.startGrid(1);
        IgniteEx third = this.startGrid(2);
        this.changeAgentConfiguration(first);
        this.checkThreads(false);
        this.stopGrid(first.name());
        this.changeAgentConfiguration(second, false);
        this.checkThreads(false);
        this.stopGrid(third.name());
        this.checkThreads(false);
        this.stopGrid(second.name());
        this.checkThreads(true);
    }

    @Test
    public void shouldNotLostConnectionOnIdleTimeout() {
        TestLogger log1 = new TestLogger();
        IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
        this.changeAgentConfiguration(crd, false);
        TestUtils.assertWithPoll(() -> log1.contains(AGENT_BANNER));
        TestUtils.assertThrows(() -> TestUtils.assertWithPoll(10000L, 1000L, 25000L, () -> log1.contains("Lost websocket connection with server")), ConditionTimeoutException.class);
    }

    @Test
    public void shouldLoadConfigurationProperly() {
        try (IgniteEx ignite = this.startGrid();){
            ControlCenterAgentConfiguration cfg = AgentUtils.ggccAgent((IgniteEx)ignite).configuration();
            Assert.assertEquals((Object)"http://localhost:3000", (Object)F.first((List)cfg.getUris()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReadOverridePropertyFormEnv() {
        String overrideProp = "http://test";
        System.setProperty("control.center.agent.uris", overrideProp);
        try (IgniteEx ignite = this.startGrid();){
            ControlCenterAgentConfiguration cfg = AgentUtils.ggccAgent((IgniteEx)ignite).configuration();
            Assert.assertEquals((Object)overrideProp, (Object)F.first((List)cfg.getUris()));
        }
        finally {
            System.clearProperty("control.center.agent.uris");
        }
    }

    @Test
    public void shouldPrintAgentBannerOnAllNodes() {
        TestLogger log1 = new TestLogger();
        IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
        this.changeAgentConfiguration(crd, true);
        TestUtils.assertWithPoll(() -> log1.contains(AGENT_BANNER));
        TestLogger log2 = new TestLogger();
        IgniteConfiguration cfg = this.getConfiguration("node-2");
        this.startGrid(cfg.setGridLogger(log2.wrap(cfg.getGridLogger())).setPluginProviders(new PluginProvider[]{new DelayedStartPluginProvider(), new ControlCenterAgentProvider(), new GridPluginProvider()}));
        TestUtils.assertWithPoll(() -> log2.contains(AGENT_BANNER));
        log2.clear();
        this.stopGrid("node-1");
        TestLogger log3 = new TestLogger();
        this.startNodeWithTestLogger(log3, "node-3");
        TestUtils.assertWithPoll(() -> log3.contains(AGENT_BANNER));
        Assert.assertFalse((boolean)log2.contains(AGENT_BANNER));
    }

    @Test
    public void shouldLaunchExportersOnAllNodes() {
        IgniteEx crd = this.startGrid(0);
        this.changeAgentConfiguration(crd, true);
        this.attachCluster(crd.cluster());
        IgniteConfiguration cfg = this.getConfiguration("node-1");
        TestLogger log1 = new TestLogger();
        IgniteEx ignite = this.startGrid(cfg.setGridLogger(log1.wrap(cfg.getGridLogger())).setPluginProviders(new PluginProvider[]{new DelayedStartPluginProvider(), new ControlCenterAgentProvider(), new GridPluginProvider()}));
        TestUtils.assertWithPoll(() -> log1.contains(AGENT_BANNER));
        TestUtils.assertWithPoll(() -> this.inInterceptor.getListPayload(StompDestinationsUtils.buildMetricsDest(), byte[].class).isEmpty());
        ControlCenterAgent agent = AgentUtils.ggccAgent((GridKernalContext)crd.context());
        AgentDynamicFeatureProcessor agentDynamicFeatureProcessor = (AgentDynamicFeatureProcessor)ignite.context().resource().resolve((Object)new AgentDynamicFeatureProcessor(Clock.systemDefaultZone()));
        MetricsSenderProcessor p = new MetricsSenderProcessor(crd.context(), agent, new DistributedMetricExporterConfiguration(crd.context()), agentDynamicFeatureProcessor);
        p.broadcastPullMetrics(crd.cluster().forRemotes(), "pull");
        TestUtils.assertWithPoll(() -> !this.inInterceptor.getListPayload(StompDestinationsUtils.buildMetricsDest(), byte[].class).isEmpty());
    }

    @Test
    public void shouldPrintAgentVersionOnStart() {
        TestLogger log1 = new TestLogger();
        IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
        crd.cluster().state(ClusterState.ACTIVE);
        PluginProvider plugin = crd.context().pluginProvider("ControlCenterAgent");
        TestUtils.assertWithPoll(() -> log1.contains("Control Center Agent " + plugin.version()));
    }

    @Test
    public void shouldCorrectlyHandleWrongServerUri() {
        TestLogger log = new TestLogger();
        IgniteEx ignite = this.startNodeWithTestLogger(log, "node-1");
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)ignite);
        String uri = "invalid-uri";
        ControlCenterAgentConfiguration cfg = agent.configuration().setUris(Collections.singletonList(uri));
        agent.configuration(cfg);
        String msg = "Failed to establish websocket connection with Control Center [uri=" + uri + ", cause=\"Expected http(s) scheme\"]";
        TestUtils.assertWithPoll(() -> log.contains(msg));
    }

    @Test
    public void shouldReportUnsupportedVersion() {
        try {
            this.handshakeInterceptor.statusCodes = Collections.singletonList(HttpStatus.BAD_REQUEST);
            this.handshakeInterceptor.attemptCntr.set(0);
            TestLogger log = new TestLogger();
            IgniteEx ignite = this.startNodeWithTestLogger(log, "node");
            this.changeAgentConfiguration(ignite, false);
            TestUtils.assertWithPoll(() -> log.contains(UNSUPPORTED_AGENT_PROTOCOL_MSG));
        }
        finally {
            this.handshakeInterceptor.statusCodes = null;
        }
    }

    @Test
    public void shouldSkipInvalidVersion() {
        try {
            this.handshakeInterceptor.statusCodes = Arrays.asList(HttpStatus.BAD_REQUEST, null);
            this.handshakeInterceptor.attemptCntr.set(0);
            TestLogger log = new TestLogger();
            IgniteEx ignite = this.startNodeWithTestLogger(log, "node");
            this.changeAgentConfiguration(ignite, false);
            TestUtils.assertWithPoll(() -> log.contains(UNSUPPORTED_AGENT_PROTOCOL_MSG));
            TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
        }
        finally {
            this.handshakeInterceptor.statusCodes = null;
        }
    }

    @Test
    public void shouldNotUseLoggerWithoutGuard() {
        InvalidUsagesLogger log = new InvalidUsagesLogger(false, false);
        IgniteEx ignite = this.startNodeWithTestLogger(log, "node-1");
        this.changeAgentConfiguration(ignite, false);
        Request req = new Request().setAction("QueryActions.executeSqlQuery").setNodeIds(Collections.singleton(ignite.localNode().id())).setId(UUID.randomUUID()).setArgument((Object)new QueryArgument().setQueryId("qry").setQueryText("SELECT * FROM NOT_EXISTING_TABLE ORDER BY ID").setPageSize(10));
        AgentUtils.ggccAgent((IgniteEx)ignite).distributedActionProcessor().onActionRequest((AbstractRequest)req);
        TestUtils.assertWithPoll(() -> log.contains("Failed to execute query."));
        Assertions.assertThat(log.invalidUsages()).isEmpty();
    }

    @Test
    public void shouldReconnectOnOldestNodeWithAgent() throws Exception {
        TestLogger log1 = new TestLogger();
        IgniteEx node1 = this.startNodeWithTestLogger(log1, "node-1");
        this.changeAgentConfiguration(node1, true);
        TestUtils.assertWithPoll(() -> log1.contains(AGENT_BANNER));
        this.startNodeWithTestLoggerAndNoAgent(log2 -> {
            Assert.assertFalse((boolean)log2.contains(AGENT_BANNER));
            TestLogger log3 = new TestLogger();
            this.startNodeWithTestLogger(log3, "node-3");
            TestUtils.assertWithPoll(() -> log3.contains(AGENT_BANNER));
            node1.close();
            TestUtils.assertWithPoll(() -> log3.contains("Established websocket connection with Control Center"));
        });
    }

    @Test
    public void shouldEstablishConnectionFromOldestNodeWithAgent() throws Exception {
        this.startNodeWithTestLoggerAndNoAgent(log -> {
            Assert.assertFalse((boolean)log.contains(AGENT_BANNER));
            TestLogger log2 = new TestLogger();
            IgniteEx node2 = this.startNodeWithTestLogger(log2, "node-2");
            this.changeAgentConfiguration(node2, false);
            TestUtils.assertWithPoll(() -> log2.contains(AGENT_BANNER));
            TestUtils.assertWithPoll(() -> log2.contains("Established websocket connection with Control Center"));
            TestLogger log3 = new TestLogger();
            this.startNodeWithTestLogger(log3, "node-3");
            TestUtils.assertWithPoll(() -> log3.contains(AGENT_BANNER));
        });
    }

    @Test
    public void shouldReconnectOnInboundHeartbeatStopped() {
        TestLogger log = new TestLogger();
        IgniteEx ignite = this.startNodeWithTestLogger(log, "ignite-1");
        this.changeAgentConfiguration(ignite);
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
        log.clear();
        this.inInterceptor.toggleFrozenStatus(true);
        TestUtils.assertWithPoll(500L, 10000L, 60000L, () -> log.contains("Lost websocket connection with Control Center"));
        this.inInterceptor.toggleFrozenStatus(false);
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
    }

    @Test
    public void shouldReconnectOnOutboundHeartbeatStopped() {
        TestLogger log = new TestLogger();
        IgniteEx ignite = this.startNodeWithTestLogger(log, "ignite-1");
        this.changeAgentConfiguration(ignite);
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
        log.clear();
        this.outInterceptor.toggleFrozenStatus(true);
        TestUtils.assertWithPoll(500L, 10000L, 60000L, () -> log.contains("Lost websocket connection with Control Center"));
        this.outInterceptor.toggleFrozenStatus(false);
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
    }

    @Test
    public void shouldReconnectOnIdChanged() {
        TestLogger log = new TestLogger();
        IgniteEx ignite = this.startNodeWithTestLogger(log, "ignite-1");
        this.changeAgentConfiguration(ignite);
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
        log.clear();
        UUID clusterId = UUID.fromString("11111111-1111-1111-1111-111111111111");
        this.changeClusterId(ignite, clusterId);
        TestUtils.assertWithPoll(() -> log.contains("Cluster ID has been changed, will reconnect to Control Center"));
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
    }

    @Test
    public void shouldReconnectOnSecretChanged() {
        TestLogger log = new TestLogger();
        IgniteEx ignite = this.startNodeWithTestLogger(log, "ignite-1");
        this.changeAgentConfiguration(ignite);
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
        log.clear();
        UUID clusterSecret = UUID.fromString("11111111-1111-1111-1111-111111111111");
        this.changeClusterSecret(ignite, clusterSecret);
        TestUtils.assertWithPoll(() -> log.contains("Cluster secret has been changed, will reconnect to Control Center."));
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
    }

    @Test
    public void shouldReadOldConfigurationAsObject() throws Exception {
        IgniteEx node2;
        TestLogger log = new TestLogger();
        try (IgniteEx ignite = this.startGrid(1);){
            ignite.context().distributedMetastorage().write("control-center-agent-cfg", (Serializable)new ControlCenterAgentConfiguration().setUris(Collections.singletonList("http://localhost:" + this.port)));
            node2 = this.startNodeWithTestLogger(log, "node-2");
        }
        Assert.assertNotNull((Object)node2);
        TestUtils.assertWithPoll(() -> log.contains(AGENT_BANNER));
        TestUtils.assertWithPoll(() -> log.contains("Established websocket connection with Control Center"));
        Assert.assertTrue((boolean)(node2.context().distributedMetastorage().read("control-center-agent-cfg") instanceof Map));
    }

    @Test
    public void shouldLaunchProcessorsOnCoordinatorWithoutErrors() throws Exception {
        TestLogger log2 = new TestLogger();
        AtomicReference crdRef = new AtomicReference();
        this.startNodeAsSeparatedProcess(ControlCenterAgentTest.withoutInClassPath(Collections.emptySet()), log1 -> {
            IgniteEx crd = this.startNodeWithTestLogger(log2, "node-2");
            crd.cluster().state(ClusterState.ACTIVE);
            this.changeAgentConfiguration(crd, true);
            TestUtils.assertWithPoll(() -> log1.contains(AGENT_BANNER));
            crdRef.set(crd);
        });
        TestUtils.assertWithPoll(() -> log2.contains(AGENT_BANNER));
        Assert.assertFalse((boolean)log2.contains("Failed to start GridGain Control Center agent processor"));
        Assert.assertFalse((boolean)log2.contains("Failed to notify distributed metastorage update listener"));
    }

    @Test
    public void shouldStopProcessorsCorrectly() {
        IgniteEx crd = this.startGrid(0);
        this.changeAgentConfiguration(crd);
        this.checkThreads(false);
        TestUtils.assertWithPoll(() -> this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)crd.cluster().id()), ClusterInfo.class) != null);
        this.management(crd, Collections.singletonList("--off"));
        this.inInterceptor.clearMessages();
        this.management(crd, Collections.singletonList("--on"));
        TestUtils.assertWithPoll(() -> this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)crd.cluster().id()), ClusterInfo.class) != null);
    }

    public static class DelayedStartPluginProvider
    implements PluginProvider<PluginConfiguration> {
        public String name() {
            return "DelatedStartPlugin";
        }

        public String version() {
            return "1.0";
        }

        public <T extends IgnitePlugin> T plugin() {
            return (T)new IgnitePlugin(){};
        }

        public String copyright() {
            return null;
        }

        public void initExtensions(PluginContext ctx, ExtensionRegistry registry) {
        }

        @Nullable
        public <T> T createComponent(PluginContext ctx, Class<T> cls) {
            return null;
        }

        public CachePluginProvider createCacheProvider(CachePluginContext ctx) {
            return null;
        }

        public void start(PluginContext ctx) throws IgniteCheckedException {
        }

        public void stop(boolean cancel) throws IgniteCheckedException {
        }

        public void onIgniteStart() throws IgniteCheckedException {
            U.sleep((long)1000L);
        }

        public void onIgniteStop(boolean cancel) {
        }

        @Nullable
        public Serializable provideDiscoveryData(UUID nodeId) {
            return null;
        }

        public void receiveDiscoveryData(UUID nodeId, Serializable data) {
        }

        public void validateNewNode(ClusterNode node) throws PluginValidationException {
        }
    }

    public static class WithMockContextTest
    extends AbstractServiceTest {
        @Test
        public void shouldNotCreateSpanExporterIfNodeNotSupportTracingFeature() {
            GridKernalContext ctx = this.getMockContext();
            GridEventStorageManager evt = (GridEventStorageManager)Mockito.mock(GridEventStorageManager.class);
            Mockito.when((Object)ctx.event()).thenReturn((Object)evt);
            ClusterNode node = (ClusterNode)Mockito.mock(ClusterNode.class);
            Mockito.when((Object)node.isClient()).thenReturn((Object)true);
            Mockito.when((Object)ctx.discovery().discoCache().localNode()).thenReturn((Object)node);
            GridIoManager ioMgr = (GridIoManager)Mockito.mock(GridIoManager.class);
            Mockito.when((Object)ctx.io()).thenReturn((Object)ioMgr);
            RollingUpgrade rollingUpgradeProc = (RollingUpgrade)Mockito.mock(RollingUpgrade.class);
            Mockito.when((Object)rollingUpgradeProc.getStatus()).thenReturn((Object)new IgniteRollingUpgradeStatus());
            Mockito.when((Object)ctx.rollingUpgrade()).thenReturn((Object)rollingUpgradeProc);
            AgentConfigurationProcessor agentCfg = (AgentConfigurationProcessor)Mockito.mock(AgentConfigurationProcessor.class);
            ((AgentConfigurationProcessor)Mockito.doReturn((Object)true).when((Object)agentCfg)).isGridCompatibleWithAgent();
            GridResourceProcessor spyRsrc = ctx.resource();
            ((GridResourceProcessor)Mockito.doReturn((Object)agentCfg).when((Object)spyRsrc)).resolve(ArgumentMatchers.any(AgentConfigurationProcessor.class));
            ControlCenterAgent agent = (ControlCenterAgent)Mockito.spy((Object)new ControlCenterAgent(ctx, ""));
            ((ControlCenterAgent)Mockito.doReturn((Object)false).when((Object)agent)).isTracingEnabled();
            agent.start();
            agent.onIgniteStart();
            IgniteLogger log = ctx.log(ControlCenterAgent.class);
            ((IgniteLogger)Mockito.verify((Object)log)).warning("Current Ignite configuration does not support tracing functionality and Control Center agent will not collect traces (consider adding ignite-opencensus module to classpath).", null);
        }
    }
}

