/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent;

import java.util.function.Consumer;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.Testcontainers;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public abstract class AgentWithProxyAbstractTest
extends AgentCommonAbstractTest {
    private static final Logger log = LoggerFactory.getLogger(AgentWithProxyAbstractTest.class);
    protected static final int NGINX_DEFAULT_PORT = 80;
    protected static final int PROXY_DEFAULT_PORT = 3128;

    @Override
    public void setup() throws Exception {
        super.setup();
        Testcontainers.exposeHostPorts((int[])new int[]{this.port});
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("http.proxyUsername");
        System.clearProperty("http.proxyPassword");
    }

    public GenericContainer startProxy() {
        GenericContainer proxy = new GenericContainer("salrashid123/squidproxy").withClasspathResourceMapping("proxy/squid.conf", "/apps/squid/etc/squid.conf", BindMode.READ_ONLY).withCommand("/usr/bin/supervisord").withExposedPorts(new Integer[]{3128}).withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withMemory(Long.valueOf(0x10000000L))).withLogConsumer((Consumer)new Slf4jLogConsumer(log));
        proxy.start();
        return proxy;
    }

    public GenericContainer startProxyWithCreds() {
        GenericContainer proxy = new GenericContainer("salrashid123/squidproxy").withClasspathResourceMapping("proxy/squid-auth.conf", "/etc/squid/squid.conf", BindMode.READ_ONLY).withClasspathResourceMapping("proxy/passwords", "/etc/squid3/passwords", BindMode.READ_ONLY).withCommand("/apps/squid/sbin/squid -NsY -f /etc/squid/squid.conf").withExposedPorts(new Integer[]{3128}).withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withMemory(Long.valueOf(0x10000000L))).withLogConsumer((Consumer)new Slf4jLogConsumer(log));
        proxy.start();
        return proxy;
    }

    public GenericContainer startHttpsProxy() {
        GenericContainer proxy = new GenericContainer("salrashid123/squidproxy:1").withClasspathResourceMapping("proxy/squid-https.conf", "/etc/squid/squid.conf", BindMode.READ_ONLY).withClasspathResourceMapping("ssl/ca.crt", "/etc/squid3/ca.crt", BindMode.READ_ONLY).withClasspathResourceMapping("ssl/ca.key", "/etc/squid3/ca.key", BindMode.READ_ONLY).withCommand("/apps/squid/sbin/squid -NsY -f /etc/squid/squid.conf").withExposedPorts(new Integer[]{3128}).withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withMemory(Long.valueOf(0x10000000L))).withLogConsumer((Consumer)new Slf4jLogConsumer(log));
        proxy.start();
        return proxy;
    }

    public GenericContainer startContainerWithRedirect(String baseUri) {
        GenericContainer nginx = new GenericContainer("schmunk42/nginx-redirect").withEnv("SERVER_NAME", "_").withEnv("SERVER_REDIRECT", baseUri).withExposedPorts(new Integer[]{80}).withLogConsumer((Consumer)new Slf4jLogConsumer(log)).withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withMemory(Long.valueOf(0x10000000L))).waitingFor((WaitStrategy)Wait.forHttp((String)"/agents").forStatusCode(400));
        nginx.start();
        return nginx;
    }
}

