/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.aws.encryption.spi;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.gridgain.aws.encryption.spi.AwsKmsEncryptionSpi;
import org.gridgain.aws.encryption.spi.AwsKmsEncryptionSpiMocked;
import org.gridgain.aws.encryption.spi.EncryptionKey;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.DescribeKeyRequest;
import software.amazon.awssdk.services.kms.model.DescribeKeyResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.KeyMetadata;

public class AwsKmsEncryptionSpiSelfTest {
    static final String MASTER_KEY_NAME = "arn:aws:kms:eu-central-1:313272427743:key/1234abcd-12ab-34cd-56ef-1234567890ab";
    static final String MASTER_KEY_NAME_2 = "arn:aws:kms:eu-central-1:313272427743:key/12341234-12ab-34cd-56ef-1234567890ab";
    static final String ROLE_ARN = "arn:aws:iam::313272747743:role/nebula-cmk-access-role";
    static final String EXTERNAL_ID = "766d9557-27d9-473f-a7c6-508b8f5968f3";
    KmsClient kmsClient = (KmsClient)Mockito.mock(KmsClient.class);

    @Test
    public void testCantStartWithEmptyParam() throws Exception {
        AwsKmsEncryptionSpi encSpi = new AwsKmsEncryptionSpi();
        Assert.assertThrows(IgniteException.class, () -> AwsKmsEncryptionSpiSelfTest.lambda$testCantStartWithEmptyParam$0((EncryptionSpi)encSpi));
    }

    @Test
    public void testCantLoadMasterKeyEmpty() {
        EncryptionSpi encSpi = this.prepareSpi();
        Assert.assertThrows(IgniteException.class, () -> encSpi.setMasterKeyName(""));
    }

    @Test
    public void testFailedToChangeMasterKeyDisabled() {
        EncryptionSpi encSpi = this.prepareSpi();
        ((KmsClient)Mockito.doReturn((Object)DescribeKeyResponse.builder().keyMetadata((KeyMetadata)KeyMetadata.builder().enabled(Boolean.valueOf(false)).encryptionAlgorithms(new EncryptionAlgorithmSpec[]{EncryptionAlgorithmSpec.SYMMETRIC_DEFAULT}).build()).build()).when((Object)this.kmsClient)).describeKey((DescribeKeyRequest)ArgumentMatchers.any(DescribeKeyRequest.class));
        Assert.assertThrows(IgniteException.class, () -> encSpi.setMasterKeyName(MASTER_KEY_NAME_2));
    }

    @Test
    public void testFailedToChangeMasterKeyWrongEncryptionAlg() {
        EncryptionSpi encSpi = this.prepareSpi();
        ((KmsClient)Mockito.doReturn((Object)DescribeKeyResponse.builder().keyMetadata((KeyMetadata)KeyMetadata.builder().enabled(Boolean.valueOf(true)).encryptionAlgorithms(new EncryptionAlgorithmSpec[]{EncryptionAlgorithmSpec.SM2_PKE}).build()).build()).when((Object)this.kmsClient)).describeKey((DescribeKeyRequest)ArgumentMatchers.any(DescribeKeyRequest.class));
        Assert.assertThrows(IgniteException.class, () -> encSpi.setMasterKeyName(MASTER_KEY_NAME_2));
    }

    @Test
    public void testFailedToChangeMasterKeyEncryptionNotAllowed() {
        EncryptionSpi encSpi = this.prepareSpi();
        ((KmsClient)Mockito.doThrow(RuntimeException.class).when((Object)this.kmsClient)).encrypt((EncryptRequest)ArgumentMatchers.any(EncryptRequest.class));
        Assert.assertThrows(IgniteException.class, () -> encSpi.setMasterKeyName(MASTER_KEY_NAME_2));
    }

    @Test
    public void testFailedToChangeMasterKeyDecryptionNotAllowed() {
        EncryptionSpi encSpi = this.prepareSpi();
        ((KmsClient)Mockito.doThrow(RuntimeException.class).when((Object)this.kmsClient)).decrypt((DecryptRequest)ArgumentMatchers.any(DecryptRequest.class));
        Assert.assertThrows(IgniteException.class, () -> encSpi.setMasterKeyName(MASTER_KEY_NAME_2));
    }

    @Test
    public void testEncryptDecrypt() throws Exception {
        EncryptionSpi encSpi = this.prepareSpi();
        EncryptionKey k = (EncryptionKey)encSpi.create();
        Assert.assertNotNull((Object)k);
        Assert.assertNotNull((Object)k.key());
        byte[] plainText = "Just a test string to encrypt!".getBytes(StandardCharsets.UTF_8);
        byte[] cipherText = new byte[this.prepareSpi().encryptedSize(plainText.length)];
        encSpi.encrypt(ByteBuffer.wrap(plainText), (Serializable)k, ByteBuffer.wrap(cipherText));
        Assert.assertNotNull((Object)cipherText);
        Assert.assertEquals((long)encSpi.encryptedSize(plainText.length), (long)cipherText.length);
        byte[] decryptedText = encSpi.decrypt(cipherText, (Serializable)k);
        Assert.assertNotNull((Object)decryptedText);
        Assert.assertEquals((long)plainText.length, (long)decryptedText.length);
        Assert.assertEquals((Object)new String(plainText, StandardCharsets.UTF_8), (Object)new String(decryptedText, StandardCharsets.UTF_8));
    }

    @Test
    public void testMasterKeysDigest() throws Exception {
        EncryptionSpi encSpi = this.prepareSpi();
        byte[] digest = encSpi.masterKeyDigest();
        encSpi.setMasterKeyName(MASTER_KEY_NAME_2);
        byte[] digest2 = encSpi.masterKeyDigest();
        Assert.assertNotNull((Object)digest);
        Assert.assertFalse((boolean)Arrays.equals(digest, digest2));
    }

    @Test
    public void testKeyEncryptDecrypt() throws Exception {
        EncryptionSpi encSpi = this.prepareSpi();
        EncryptionKey k = (EncryptionKey)encSpi.create();
        Assert.assertNotNull((Object)k);
        Assert.assertNotNull((Object)k.key());
        byte[] encrypted = new byte[]{0, 1, 2, 3};
        ((KmsClient)Mockito.doReturn((Object)EncryptResponse.builder().ciphertextBlob(SdkBytes.fromByteArray((byte[])encrypted)).build()).when((Object)this.kmsClient)).encrypt((EncryptRequest)ArgumentMatchers.any(EncryptRequest.class));
        ((KmsClient)Mockito.doReturn((Object)DecryptResponse.builder().plaintext(SdkBytes.fromByteArray((byte[])IgniteUtils.toBytes((Serializable)k))).build()).when((Object)this.kmsClient)).decrypt((DecryptRequest)ArgumentMatchers.any(DecryptRequest.class));
        this.checkKeyEncryptDecrypt(encSpi, k);
    }

    private void checkKeyEncryptDecrypt(EncryptionSpi encSpi, EncryptionKey k) {
        byte[] encGrpKey = encSpi.encryptKey((Serializable)k);
        Assert.assertNotNull((Object)encGrpKey);
        Assert.assertTrue((encGrpKey.length > 0 ? 1 : 0) != 0);
        EncryptionKey k2 = (EncryptionKey)encSpi.decryptKey(encGrpKey);
        Assert.assertEquals((Object)k.key(), (Object)k2.key());
    }

    @NotNull
    private EncryptionSpi prepareSpi() {
        AwsKmsEncryptionSpi encSpi = AwsKmsEncryptionSpiSelfTest.spi(this.kmsClient);
        encSpi.onBeforeStart();
        encSpi.spiStart("default");
        return encSpi;
    }

    @NotNull
    public static AwsKmsEncryptionSpi spi(KmsClient kmsClient) {
        AwsKmsEncryptionSpiMocked encSpi = new AwsKmsEncryptionSpiMocked(kmsClient);
        encSpi.setMasterKeyName(MASTER_KEY_NAME);
        encSpi.setRoleArn(ROLE_ARN);
        encSpi.setExternalId(EXTERNAL_ID);
        ((KmsClient)Mockito.doReturn((Object)DescribeKeyResponse.builder().keyMetadata((KeyMetadata)KeyMetadata.builder().enabled(Boolean.valueOf(true)).encryptionAlgorithms(new EncryptionAlgorithmSpec[]{EncryptionAlgorithmSpec.SYMMETRIC_DEFAULT}).build()).build()).when((Object)kmsClient)).describeKey((DescribeKeyRequest)ArgumentMatchers.any(DescribeKeyRequest.class));
        ((KmsClient)Mockito.doReturn((Object)EncryptResponse.builder().ciphertextBlob(SdkBytes.fromByteArray((byte[])new byte[]{1, 2, 0, -1})).build()).when((Object)kmsClient)).encrypt((EncryptRequest)ArgumentMatchers.any(EncryptRequest.class));
        ((KmsClient)Mockito.doReturn((Object)DecryptResponse.builder().build()).when((Object)kmsClient)).decrypt((DecryptRequest)ArgumentMatchers.any(DecryptRequest.class));
        return encSpi;
    }

    private static /* synthetic */ void lambda$testCantStartWithEmptyParam$0(EncryptionSpi encSpi) throws Throwable {
        encSpi.spiStart("default");
    }
}

