/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.transport.ws;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.internal.GridKernalContext;
import org.awaitility.Awaitility;
import org.gridgain.control.agent.test.TestGridKernalContext;
import org.gridgain.control.agent.transport.ws.RetryableSender;
import org.junit.Test;

public class RetryableSenderTest {
    @Test
    public void shouldSendSingleElement() throws Exception {
        final ArrayList results = new ArrayList();
        RetryableSender snd = new RetryableSender((GridKernalContext)new TestGridKernalContext()){

            boolean sendInternal(String dest, List<Object> elements) {
                results.add(elements);
                return true;
            }
        };
        snd.send("dest", (Object)1);
        Awaitility.with().pollInterval(100L, TimeUnit.MILLISECONDS).await().atMost(1L, TimeUnit.SECONDS).until(() -> !results.isEmpty() && ((List)results.get(0)).size() == 1);
        snd.stop(true);
    }

    @Test
    public void shouldRetrySendSingleElement() throws Exception {
        final ArrayList results = new ArrayList();
        final AtomicBoolean shouldSnd = new AtomicBoolean(false);
        final AtomicInteger retryCnt = new AtomicInteger();
        RetryableSender snd = new RetryableSender((GridKernalContext)new TestGridKernalContext()){

            boolean sendInternal(String dest, List<Object> elements) {
                if (!shouldSnd.get()) {
                    retryCnt.incrementAndGet();
                    return false;
                }
                results.add(elements);
                return true;
            }
        };
        snd.send("dest", (Object)1);
        snd.send("dest", (Object)2);
        Awaitility.with().pollInterval(500L, TimeUnit.MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS).until(() -> retryCnt.get() >= 2);
        shouldSnd.set(true);
        Awaitility.with().pollInterval(100L, TimeUnit.MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS).until(() -> results.size() == 2);
        snd.stop(true);
    }

    @Test
    public void shouldSendInBatches() throws Exception {
        final ArrayList results = new ArrayList();
        RetryableSender snd = new RetryableSender((GridKernalContext)new TestGridKernalContext()){

            boolean sendInternal(String dest, List<Object> elements) {
                results.add(elements);
                return true;
            }
        };
        snd.sendList("dest", IntStream.range(0, 17).boxed().collect(Collectors.toList()));
        Awaitility.with().pollInterval(100L, TimeUnit.MILLISECONDS).await().atMost(1L, TimeUnit.SECONDS).until(() -> !results.isEmpty() && ((List)results.get(0)).size() == 10);
        Awaitility.with().pollInterval(100L, TimeUnit.MILLISECONDS).await().atMost(1L, TimeUnit.SECONDS).until(() -> !results.isEmpty() && ((List)results.get(1)).size() == 7);
        snd.stop(true);
    }

    @Test
    public void shouldRetrySend() throws Exception {
        final ArrayList results = new ArrayList();
        final AtomicBoolean shouldSnd = new AtomicBoolean(false);
        final AtomicInteger retryCnt = new AtomicInteger();
        RetryableSender snd = new RetryableSender((GridKernalContext)new TestGridKernalContext()){

            boolean sendInternal(String dest, List<Object> elements) {
                if (!shouldSnd.get()) {
                    retryCnt.incrementAndGet();
                    return false;
                }
                results.add(elements);
                return true;
            }
        };
        snd.sendList("dest", IntStream.range(0, 17).boxed().collect(Collectors.toList()));
        Awaitility.with().pollInterval(500L, TimeUnit.MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS).until(() -> retryCnt.get() >= 2);
        shouldSnd.set(true);
        Awaitility.with().pollInterval(100L, TimeUnit.MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS).until(() -> results.size() == 2);
        snd.stop(true);
    }
}

