/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.lifecycle;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.GridProcessor;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.processor.lifecycle.ClusterLifecycleProcessor;
import org.gridgain.control.agent.processor.lifecycle.LifecycleState;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentUtils;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

public class ClusterLifecycleProcessorIntegrationTest
extends AgentCommonAbstractTest {
    @Test
    public void shouldStartProcessorsOnAccountsAttached() {
        IgniteEx ignite_1 = this.startGrid(1);
        this.changeAgentConfiguration(ignite_1);
        IgniteEx ignite_2 = this.startGrid(2);
        IgniteClusterEx cluster = ignite_1.cluster();
        cluster.state(ClusterState.ACTIVE);
        String dest = StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id());
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(dest));
        ControlCenterAgent agent_1 = AgentUtils.ggccAgent((IgniteEx)ignite_1);
        ControlCenterAgent agent_2 = AgentUtils.ggccAgent((IgniteEx)ignite_2);
        List<GridProcessor> mockProcessors_1 = this.addMockedProcessors(agent_1, false, LifecycleState.ATTACHED);
        List<GridProcessor> mockProcessors_2 = this.addMockedProcessors(agent_2, false, LifecycleState.ATTACHED);
        this.attachCluster(cluster);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : TestUtils.union(mockProcessors_1, mockProcessors_2)) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).start();
            }
        });
    }

    @Test
    public void shouldStopProcessorsOnAccountsDetached() {
        IgniteEx ignite_1 = this.startGrid(1);
        this.changeAgentConfiguration(ignite_1);
        IgniteEx ignite_2 = this.startGrid(2);
        IgniteClusterEx cluster = ignite_1.cluster();
        cluster.state(ClusterState.ACTIVE);
        String dest = StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id());
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(dest));
        ControlCenterAgent agent_1 = AgentUtils.ggccAgent((IgniteEx)ignite_1);
        ControlCenterAgent agent_2 = AgentUtils.ggccAgent((IgniteEx)ignite_2);
        List<GridProcessor> mockProcessors_1 = this.addMockedProcessors(agent_1, false, LifecycleState.ATTACHED);
        List<GridProcessor> mockProcessors_2 = this.addMockedProcessors(agent_2, false, LifecycleState.ATTACHED);
        this.template.convertAndSend((Object)dest, (Object)true);
        this.template.convertAndSend((Object)dest, (Object)false);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : TestUtils.union(mockProcessors_1, mockProcessors_2)) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).stop(true);
            }
        });
    }

    @Test
    public void shouldStartAndStopOnAttachmentInRightOrder() {
        IgniteEx ignite_1 = this.startGrid(1);
        this.changeAgentConfiguration(ignite_1);
        IgniteEx ignite_2 = this.startGrid(2);
        IgniteClusterEx cluster = ignite_1.cluster();
        cluster.state(ClusterState.ACTIVE);
        String dest = StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id());
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(dest));
        ControlCenterAgent agent_1 = AgentUtils.ggccAgent((IgniteEx)ignite_1);
        ControlCenterAgent agent_2 = AgentUtils.ggccAgent((IgniteEx)ignite_2);
        List<GridProcessor> mockProcessors_1 = this.addMockedProcessors(agent_1, false, LifecycleState.ATTACHED);
        List<GridProcessor> mockProcessors_2 = this.addMockedProcessors(agent_2, false, LifecycleState.ATTACHED);
        List<GridProcessor> processors = TestUtils.union(mockProcessors_1, mockProcessors_2);
        for (int i = 0; i < 10; ++i) {
            this.template.convertAndSend((Object)dest, (Object)true);
            this.template.convertAndSend((Object)dest, (Object)false);
            TestUtils.assertWithPoll(() -> {
                for (GridProcessor proc : processors) {
                    ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).stop(true);
                }
            });
            for (GridProcessor proc : processors) {
                Mockito.reset((Object[])new GridProcessor[]{proc});
            }
        }
    }

    @Test
    public void shouldStartAndStopProcessorsOnCoordinatorOnClusterActivation() {
        IgniteEx ignite_1 = this.startGrid(1);
        this.changeAgentConfiguration(ignite_1);
        IgniteEx ignite_2 = this.startGrid(2);
        IgniteClusterEx cluster = ignite_1.cluster();
        cluster.state(ClusterState.INACTIVE);
        ControlCenterAgent agent_1 = AgentUtils.ggccAgent((IgniteEx)ignite_1);
        ControlCenterAgent agent_2 = AgentUtils.ggccAgent((IgniteEx)ignite_2);
        List<GridProcessor> mockProcessors_1 = this.addMockedProcessors(agent_1, true, LifecycleState.ACTIVATED);
        List<GridProcessor> mockProcessors_2 = this.addMockedProcessors(agent_2, true, LifecycleState.ACTIVATED);
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : mockProcessors_1) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).start();
            }
            for (GridProcessor proc : mockProcessors_2) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.never())).start();
            }
        });
        cluster.state(ClusterState.INACTIVE);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : mockProcessors_1) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).stop(true);
            }
            for (GridProcessor proc : mockProcessors_2) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.never())).start();
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.never())).stop(true);
            }
        });
    }

    @Test
    public void shouldStartProcessorsOnAttachedWhen2ndNodeAddedLater() throws Exception {
        IgniteEx ignite_1 = this.startGrid(1);
        this.changeAgentConfiguration(ignite_1);
        IgniteClusterEx cluster = ignite_1.cluster();
        ControlCenterAgent agent_1 = AgentUtils.ggccAgent((IgniteEx)ignite_1);
        List<GridProcessor> mockProcessors_1 = this.addMockedProcessors(agent_1, false, LifecycleState.ATTACHED);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)true);
        TimeUnit.SECONDS.sleep(2L);
        IgniteEx ignite_2 = this.startGrid(2);
        ControlCenterAgent agent_2 = AgentUtils.ggccAgent((IgniteEx)ignite_2);
        List<GridProcessor> mockProcessors_2 = this.addMockedProcessors(agent_2, false, LifecycleState.ATTACHED);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : TestUtils.union(mockProcessors_1, mockProcessors_2)) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).start();
            }
        });
    }

    @Test
    public void shouldStartProcessorsOnActivatedWhen2ndNodeAddedLater() {
        IgniteEx ignite_1 = this.startGrid(1);
        this.changeAgentConfiguration(ignite_1);
        IgniteClusterEx cluster = ignite_1.cluster();
        cluster.state(ClusterState.ACTIVE);
        ControlCenterAgent agent_1 = AgentUtils.ggccAgent((IgniteEx)ignite_1);
        List<GridProcessor> mockProcessors_1 = this.addMockedProcessors(agent_1, false, LifecycleState.ACTIVATED);
        IgniteEx ignite_2 = this.startGrid(2);
        ControlCenterAgent agent_2 = AgentUtils.ggccAgent((IgniteEx)ignite_2);
        List<GridProcessor> mockProcessors_2 = this.addMockedProcessors(agent_2, false, LifecycleState.ACTIVATED);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : TestUtils.union(mockProcessors_1, mockProcessors_2)) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).start();
            }
        });
    }

    @Test
    public void shouldStartAndStopProcessorsOnCoordinatorOnAfterCoordinatorChanged() {
        IgniteEx ignite_1 = this.startGrid(1);
        this.changeAgentConfiguration(ignite_1);
        IgniteEx ignite_2 = this.startGrid(2);
        IgniteClusterEx cluster = ignite_1.cluster();
        cluster.state(ClusterState.INACTIVE);
        ControlCenterAgent agent_1 = AgentUtils.ggccAgent((IgniteEx)ignite_1);
        ControlCenterAgent agent_2 = AgentUtils.ggccAgent((IgniteEx)ignite_2);
        List<GridProcessor> mockProcessors_1 = this.addMockedProcessors(agent_1, true, LifecycleState.ACTIVATED);
        List<GridProcessor> mockProcessors_2 = this.addMockedProcessors(agent_2, true, LifecycleState.ACTIVATED);
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : mockProcessors_1) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).start();
            }
            for (GridProcessor proc : mockProcessors_2) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.never())).start();
            }
        });
        this.stopGrid(1);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : mockProcessors_1) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).stop(true);
            }
            for (GridProcessor proc : mockProcessors_2) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).start();
            }
        });
    }

    @Test
    public void shouldStartWith2ConditionsAndStopWhen1ConditionWrong() {
        IgniteEx ignite = this.startGrid(1);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.INACTIVE);
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)ignite);
        List<GridProcessor> mockProcessors = this.addMockedProcessors(agent, false, LifecycleState.ATTACHED, LifecycleState.ACTIVATED);
        cluster.state(ClusterState.ACTIVE);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)true);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : mockProcessors) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).start();
            }
        });
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)false);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : mockProcessors) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).stop(true);
            }
        });
    }

    @Test
    public void shouldStopOnDisconnectedAndStartOnReconnected() {
        IgniteEx ignite_1 = this.startGrid(1);
        this.changeAgentConfiguration(ignite_1);
        IgniteEx ignite_2 = this.startGrid(2);
        ControlCenterAgent agent_1 = AgentUtils.ggccAgent((IgniteEx)ignite_1);
        ControlCenterAgent agent_2 = AgentUtils.ggccAgent((IgniteEx)ignite_2);
        List<GridProcessor> mockProcessors_1 = this.addMockedProcessors(agent_1, false, LifecycleState.CONNECTED);
        List<GridProcessor> mockProcessors_2 = this.addMockedProcessors(agent_2, false, LifecycleState.CONNECTED);
        List<GridProcessor> mockProcessors = TestUtils.union(mockProcessors_1, mockProcessors_2);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : mockProcessors) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).start();
            }
        });
        for (GridProcessor processor : mockProcessors) {
            Mockito.reset((Object[])new GridProcessor[]{processor});
        }
        this.websocketDecoratedFactory.disconnectAllClients();
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : mockProcessors) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).stop(true);
            }
            for (GridProcessor proc : mockProcessors) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).start();
            }
        });
    }

    @Test
    public void shouldNotStopCoordinatorProcessorsIfNonCoordinatorStops() {
        IgniteEx ignite_1 = this.startGrid(1);
        this.changeAgentConfiguration(ignite_1);
        IgniteEx ignite_2 = this.startGrid(2);
        ControlCenterAgent agent_1 = AgentUtils.ggccAgent((IgniteEx)ignite_1);
        ControlCenterAgent agent_2 = AgentUtils.ggccAgent((IgniteEx)ignite_2);
        List<GridProcessor> mockProcessors_1 = this.addMockedProcessors(agent_1, false, LifecycleState.CONNECTED);
        List<GridProcessor> mockProcessors_2 = this.addMockedProcessors(agent_2, false, LifecycleState.CONNECTED);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : mockProcessors_1) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).start();
            }
            for (GridProcessor proc : mockProcessors_2) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).start();
            }
        });
        this.stopGrid(2);
        TestUtils.assertWithPoll(() -> {
            for (GridProcessor proc : mockProcessors_1) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.never())).stop(true);
            }
            for (GridProcessor proc : mockProcessors_2) {
                ((GridProcessor)Mockito.verify((Object)proc, (VerificationMode)Mockito.times((int)1))).stop(true);
            }
        });
    }

    private List<GridProcessor> addMockedProcessors(ControlCenterAgent agent, boolean onlyOnOldestAgent, LifecycleState ... states) {
        GridProcessor mockProc_1 = (GridProcessor)Mockito.mock(GridProcessor.class);
        GridProcessor mockProc_2 = (GridProcessor)Mockito.mock(GridProcessor.class);
        ClusterLifecycleProcessor clusterAttachProc = (ClusterLifecycleProcessor)ReflectionTestUtils.getField((Object)agent, (String)"clusterLifecycleProc");
        if (onlyOnOldestAgent) {
            clusterAttachProc.registerProcessor(mockProc_1, states);
            clusterAttachProc.registerProcessor(mockProc_2, states);
        } else {
            clusterAttachProc.registerExporter(mockProc_1, states);
            clusterAttachProc.registerExporter(mockProc_2, states);
        }
        return Arrays.asList(mockProc_1, mockProc_2);
    }
}

