/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.export;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.gridgain.control.agent.structures.TiersMetricTree;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.testcontainers.utility.Base58;

public class MetricsExporterBenchmarkTest {
    private static final int TEST_TEMPLATE_NUMBERS = 1000;
    private static final int TEST_ITERATION_NUMBERS = 1000;
    private static final int TEST_METRIC_REGESTRY_COUNT = 600;
    private static final int TEST_METRIC_COUNT_PER_REGISTRY = 20;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();

    @Test
    public void filterMetrics() {
        List<String> templates = this.generateTemplates(1000);
        Map<String, ReadOnlyMetricRegistry> registries = this.generateMetricRegistries(templates, 600, 20);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            new TiersMetricTree(registries).findAllBy(templates);
        }
        long endTime = System.currentTimeMillis();
        MatcherAssert.assertThat((String)"benchmarkExecutionTime", (Object)TimeUnit.SECONDS.toMillis(25L), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(endTime - start)));
    }

    private List<String> generateTemplates(int num) {
        ArrayList<String> objects = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            int tairs = i % 5 + 2;
            objects.add(this.metricName(tairs, true));
        }
        return objects;
    }

    private Map<String, ReadOnlyMetricRegistry> generateMetricRegistries(List<String> templates, int cntOfRegestries, int metricsPerRegistry) {
        HashMap<String, ReadOnlyMetricRegistry> res = new HashMap<String, ReadOnlyMetricRegistry>();
        for (int i = 0; i < cntOfRegestries; ++i) {
            HashMap<String, AtomicLongMetric> metrics = new HashMap<String, AtomicLongMetric>();
            for (int j = 0; j < metricsPerRegistry; ++j) {
                if (this.random.nextBoolean()) {
                    String name = this.metricName(8, false);
                    metrics.put(name, new AtomicLongMetric(name, null));
                    continue;
                }
                String s = templates.get(this.random.nextInt(templates.size()));
                String s2 = s.replaceAll("\\*", Base58.randomString((int)6));
                metrics.put(s2, new AtomicLongMetric(s2, null));
            }
            MetricRegistry metricRegistry = new MetricRegistry("test", "regestry-" + i, null, null, (IgniteLogger)new NullLogger(), metrics);
            res.put(metricRegistry.name(), (ReadOnlyMetricRegistry)metricRegistry);
        }
        return res;
    }

    private String metricName(int tairs, boolean withStar) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(Base58.randomString((int)6));
        for (int j = 1; j < tairs; ++j) {
            if (withStar && this.random.nextInt(10) == 3) {
                strBuilder.append(".*");
                continue;
            }
            strBuilder.append(".").append(Base58.randomString((int)6));
        }
        return strBuilder.toString();
    }
}

