/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.plugin.PluginConfiguration;
import org.assertj.core.util.Sets;
import org.awaitility.core.ConditionTimeoutException;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.snapshot.GridGainSnapshotInfo;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.SnapshotsUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotInfoProcessorTest
extends AgentCommonAbstractTest {
    private boolean snapshotsEnabled;

    @Override
    public void cleanup() {
        super.cleanup();
        this.deleteDirectory("snapshot");
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        IgniteConfiguration cfg = super.getConfiguration(instanceName);
        if (this.snapshotsEnabled) {
            cfg.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())});
        }
        return cfg;
    }

    @Test
    public void shouldNotSendSnapshotInfoOnConnect() {
        IgniteEx ignite = this.startGrid();
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)true);
        TestUtils.assertThrows(() -> TestUtils.assertWithPoll(() -> !F.isEmpty(this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotDest((UUID)cluster.id()), GridGainSnapshotInfo.class))), ConditionTimeoutException.class);
    }

    @Test
    public void shouldNotSendSnapshotInfoForNotAttachedCluster() {
        this.snapshotsEnabled = true;
        IgniteEx ignite = this.startGrid();
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache = this.createCache((Ignite)ignite, "test-cache");
        cache.put((Object)1, (Object)2);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().createFullSnapshot(null, null).get();
        this.changeAgentConfiguration(ignite);
        String dest = SnapshotsUtils.buildSnapshotDest((UUID)cluster.id());
        TestUtils.assertThrows(() -> TestUtils.assertWithPoll(500L, 1000L, 10000L, () -> !F.isEmpty(this.inInterceptor.getListPayload(dest, GridGainSnapshotInfo.class))), ConditionTimeoutException.class);
    }

    @Test
    public void shouldSendSnapshotInfoOnActivation() {
        this.snapshotsEnabled = true;
        IgniteEx ignite = this.startGrid();
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache = this.createCache((Ignite)ignite, "test-cache");
        cache.put((Object)1, (Object)2);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().createFullSnapshot(null, null).get();
        cluster.state(ClusterState.INACTIVE);
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)true);
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotInfo> snapshots = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotDest((UUID)cluster.id()), GridGainSnapshotInfo.class);
            if (snapshots.size() != 1) {
                return false;
            }
            GridGainSnapshotInfo snapshot = (GridGainSnapshotInfo)F.first(snapshots);
            Assert.assertTrue((boolean)snapshot.isFull());
            Assert.assertNull((Object)snapshot.getMessage());
            Assert.assertNull((Object)snapshot.getScheduleName());
            Assert.assertEquals(Collections.singleton("test-cache"), (Object)snapshot.getCacheNames());
            Assert.assertTrue((boolean)snapshot.getParentSnapshotIds().isEmpty());
            Assert.assertTrue((snapshot.getSnapshotId() > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)snapshot.getSnapshotId(), (long)snapshot.getCreationTime());
            return true;
        });
    }

    @Test
    public void shouldSendSnapshotInfoOnConnect() {
        this.snapshotsEnabled = true;
        IgniteEx ignite = this.startGrid();
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache = this.createCache((Ignite)ignite, "test-cache");
        cache.put((Object)1, (Object)2);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().createFullSnapshot(null, null).get();
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)true);
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotInfo> snapshots = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotDest((UUID)cluster.id()), GridGainSnapshotInfo.class);
            if (snapshots.size() != 1) {
                return false;
            }
            GridGainSnapshotInfo snapshot = (GridGainSnapshotInfo)F.first(snapshots);
            Assert.assertTrue((boolean)snapshot.isFull());
            Assert.assertNull((Object)snapshot.getMessage());
            Assert.assertNull((Object)snapshot.getScheduleName());
            Assert.assertEquals(Collections.singleton("test-cache"), (Object)snapshot.getCacheNames());
            Assert.assertTrue((boolean)snapshot.getParentSnapshotIds().isEmpty());
            return true;
        });
    }

    @Test
    public void shouldSendSnapshotListOnConnect() {
        this.snapshotsEnabled = true;
        IgniteEx ignite = this.startGrid();
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache1 = this.createCache((Ignite)ignite, "cache1");
        cache1.put((Object)1, (Object)2);
        IgniteCache cache2 = this.createCache((Ignite)ignite, "cache2");
        cache2.put((Object)1, (Object)2);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        GridSnapshot snap = gg.snapshot();
        snap.createFullSnapshot(Collections.singleton("cache1"), "snapshot 1").get();
        snap.createSnapshot(Collections.singleton("cache1"), "snapshot 2").get();
        snap.createFullSnapshot(Collections.singleton("cache2"), "snapshot 3").get();
        snap.createSnapshot(Sets.set((Object[])new String[]{"cache1", "cache2"}), "snapshot 4").get();
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)true);
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotInfo> snapshots = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotDest((UUID)cluster.id()), GridGainSnapshotInfo.class);
            if (snapshots.size() != 4) {
                return false;
            }
            GridGainSnapshotInfo snap1 = snapshots.get(0);
            Assert.assertTrue((boolean)snap1.isFull());
            Assert.assertEquals((Object)"snapshot 1", (Object)snap1.getMessage());
            Assert.assertNull((Object)snap1.getScheduleName());
            Assert.assertEquals(Collections.singleton("cache1"), (Object)snap1.getCacheNames());
            Assert.assertTrue((boolean)snap1.getParentSnapshotIds().isEmpty());
            GridGainSnapshotInfo snap2 = snapshots.get(1);
            Assert.assertFalse((boolean)snap2.isFull());
            Assert.assertEquals((Object)"snapshot 2", (Object)snap2.getMessage());
            Assert.assertNull((Object)snap2.getScheduleName());
            Assert.assertEquals(Collections.singleton("cache1"), (Object)snap2.getCacheNames());
            Assert.assertEquals(Collections.singleton(snap1.getSnapshotId()), (Object)snap2.getParentSnapshotIds());
            GridGainSnapshotInfo snap3 = snapshots.get(2);
            Assert.assertTrue((boolean)snap3.isFull());
            Assert.assertEquals((Object)"snapshot 3", (Object)snap3.getMessage());
            Assert.assertNull((Object)snap3.getScheduleName());
            Assert.assertEquals(Collections.singleton("cache2"), (Object)snap3.getCacheNames());
            Assert.assertTrue((boolean)snap3.getParentSnapshotIds().isEmpty());
            GridGainSnapshotInfo snap4 = snapshots.get(3);
            Assert.assertFalse((boolean)snap4.isFull());
            Assert.assertEquals((Object)"snapshot 4", (Object)snap4.getMessage());
            Assert.assertNull((Object)snap4.getScheduleName());
            Assert.assertEquals((Object)Sets.set((Object[])new String[]{"cache1", "cache2"}), (Object)snap4.getCacheNames());
            Assert.assertEquals((Object)Sets.set((Object[])new Long[]{snap2.getSnapshotId(), snap3.getSnapshotId()}), (Object)snap4.getParentSnapshotIds());
            return true;
        });
    }

    @Test
    public void shouldParseScheduleName() {
        this.snapshotsEnabled = true;
        IgniteEx ignite = this.startGrid();
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        IgniteCache cache = this.createCache((Ignite)ignite, "test-cache");
        cache.put((Object)1, (Object)2);
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        SnapshotScheduleProcessor scheduler = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        SnapshotScheduleV2 schedule = new SnapshotScheduleV2("1", "test-schedule", SnapshotOperationType.CREATE, "* * * * *", null, null, 1L, null, true, null, null, null, -1, -1, null, 0);
        scheduler.start(schedule);
        TestUtils.assertWithPoll(100L, 0L, 120000L, () -> {
            IgniteFuture fut = gg.snapshot().ongoingSnapshotOperationFuture();
            if (fut == null) {
                return false;
            }
            fut.get();
            return true;
        });
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)cluster.id()), (Object)true);
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotInfo> snapshots = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotDest((UUID)cluster.id()), GridGainSnapshotInfo.class);
            if (snapshots.size() != 1) {
                return false;
            }
            GridGainSnapshotInfo snapshot = (GridGainSnapshotInfo)F.first(snapshots);
            Assert.assertTrue((boolean)snapshot.isFull());
            Assert.assertNotNull((Object)snapshot.getMessage());
            Assert.assertEquals(Collections.singleton("test-cache"), (Object)snapshot.getCacheNames());
            Assert.assertEquals((Object)"test-schedule", (Object)snapshot.getScheduleName());
            return true;
        });
    }
}

