/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.dto.metric;

import java.nio.charset.StandardCharsets;
import org.gridgain.control.agent.dto.metric.MetricRegistrySchema;
import org.gridgain.control.agent.dto.metric.MetricRegistrySchemaItem;
import org.gridgain.control.agent.dto.metric.MetricType;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MetricRegistrySchemaTest {
    private static final String ITEM_NAME_PREF = "item.name.";
    private static final int CNT = 4;
    private static final String DISALLOWED = "disallowed";
    private static final int ARR_EXPANDED_DELTA = 128;
    private static final int SCHEMA_OFF = 64;

    @Test
    public void testBuild() {
        MetricRegistrySchema.Builder bldr = MetricRegistrySchema.Builder.newInstance();
        int namesSize = 0;
        for (byte i = 0; i < 4; i = (byte)(i + 1)) {
            String name = ITEM_NAME_PREF + i;
            bldr.add(name, MetricType.findByType((byte)i));
            namesSize += name.getBytes(StandardCharsets.UTF_8).length;
        }
        MetricRegistrySchema schema = bldr.build();
        int exp = 24 + namesSize;
        Assert.assertEquals((long)exp, (long)schema.length());
        Assert.assertEquals((long)4L, (long)schema.items().size());
    }

    @Test
    public void testAddAfterBuild() {
        MetricRegistrySchema.Builder bldr = MetricRegistrySchema.Builder.newInstance();
        for (byte i = 0; i < 4; i = (byte)(i + 1)) {
            bldr.add(ITEM_NAME_PREF + i, MetricType.findByType((byte)i));
        }
        bldr.build();
        TestUtils.assertThrows(() -> bldr.add(DISALLOWED, MetricType.findByType((byte)0)), IllegalStateException.class);
    }

    @Test
    public void testBuildAfterBuild() {
        MetricRegistrySchema.Builder bldr = MetricRegistrySchema.Builder.newInstance();
        for (byte i = 0; i < 4; i = (byte)(i + 1)) {
            bldr.add(ITEM_NAME_PREF + i, MetricType.findByType((byte)i));
        }
        bldr.build();
        TestUtils.assertThrows(() -> ((MetricRegistrySchema.Builder)bldr).build(), IllegalStateException.class);
    }

    @Test
    public void testSchemaItemsImmutable() {
        MetricRegistrySchema.Builder bldr = MetricRegistrySchema.Builder.newInstance();
        for (byte i = 0; i < 4; i = (byte)(i + 1)) {
            bldr.add(ITEM_NAME_PREF + i, MetricType.findByType((byte)i));
        }
        MetricRegistrySchema schema = bldr.build();
        TestUtils.assertThrows(() -> schema.items().add(new MetricRegistrySchemaItem(DISALLOWED, MetricType.findByType((byte)0))), UnsupportedOperationException.class);
    }

    @Test
    public void testSchemaToBytesFromBytes() {
        MetricRegistrySchema.Builder bldr = MetricRegistrySchema.Builder.newInstance();
        for (byte i = 0; i < 4; i = (byte)(i + 1)) {
            bldr.add(ITEM_NAME_PREF + i, MetricType.findByType((byte)i));
        }
        MetricRegistrySchema schema = bldr.build();
        byte[] arr = schema.toBytes();
        Assert.assertEquals((long)schema.length(), (long)arr.length);
        MetricRegistrySchema schema1 = MetricRegistrySchema.fromBytes((byte[])arr);
        Assert.assertEquals((long)schema.length(), (long)schema1.length());
        Assert.assertEquals((Object)schema.items(), (Object)schema1.items());
    }

    @Test
    public void testSchemaToBytesFromBytesInPlace() {
        MetricRegistrySchema.Builder bldr = MetricRegistrySchema.Builder.newInstance();
        for (byte i = 0; i < 4; i = (byte)(i + 1)) {
            bldr.add(ITEM_NAME_PREF + i, MetricType.findByType((byte)i));
        }
        MetricRegistrySchema schema = bldr.build();
        byte[] arr = new byte[schema.length() + 128];
        schema.toBytes(arr, 64);
        MetricRegistrySchema schema1 = MetricRegistrySchema.fromBytes((byte[])arr, (int)64, (int)schema.length());
        Assert.assertEquals((long)schema.length(), (long)schema1.length());
        Assert.assertEquals((Object)schema.items(), (Object)schema1.items());
    }

    @Test
    public void testSchemaToBytesInPlaceBoundsViolated() {
        MetricRegistrySchema.Builder bldr = MetricRegistrySchema.Builder.newInstance();
        for (byte i = 0; i < 4; i = (byte)(i + 1)) {
            bldr.add(ITEM_NAME_PREF + i, MetricType.findByType((byte)i));
        }
        MetricRegistrySchema schema = bldr.build();
        byte[] arr = new byte[schema.length() + 128];
        TestUtils.assertThrows(() -> schema.toBytes(arr, 160), IllegalArgumentException.class);
    }

    @Test
    public void testSchemaFromBytesInPlaceBoundsViolated() {
        MetricRegistrySchema.Builder bldr = MetricRegistrySchema.Builder.newInstance();
        for (byte i = 0; i < 4; i = (byte)(i + 1)) {
            bldr.add(ITEM_NAME_PREF + i, MetricType.findByType((byte)i));
        }
        MetricRegistrySchema schema = bldr.build();
        byte[] arr = new byte[schema.length() + 128];
        schema.toBytes(arr, 64);
        TestUtils.assertThrows(() -> MetricRegistrySchema.fromBytes((byte[])arr, (int)192, (int)schema.length()), IllegalArgumentException.class);
    }
}

