/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithAuthenticationTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.rolebased.RoleBasedAuthenticator;
import org.gridgain.grid.security.rolebased.UserCredential;
import org.junit.Assert;
import org.junit.Test;

public class UserActionControllerTest
extends AbstractActionControllerWithAuthenticationTest {
    private static final String STATIC_USER = "default";
    private static final String STATIC_ROLE = "default";
    private static final String USERNAME = "user";
    private static final String OTHER_USERNAME = "other_user";
    private static final String PASSWORD = "password";

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        return super.getConfiguration(instanceName).setCacheConfiguration(new CacheConfiguration[]{TestUtils.nebulaUserCacheConfiguration(), TestUtils.nebulaRoleCacheConfiguration()}).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setAuthenticator((Authenticator)new RoleBasedAuthenticator().setStaticRoles(F.asMap((Object)"default", (Object)"{defaultAllow:true}")).setStaticUsers(F.asMap((Object)"default", (Object)new UserCredential(PASSWORD, "default")))).setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("default", PASSWORD)))});
    }

    @Override
    protected void bootstrapCluster() {
        TestUtils.createRole((IgniteEx)this.cluster.ignite(), USERNAME, "{defaultAllow:false}");
        TestUtils.createUser((IgniteEx)this.cluster.ignite(), USERNAME, PASSWORD, USERNAME);
    }

    @Test
    public void shouldReturnUsers() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(USERNAME, PASSWORD)));
        Request req = new Request().setId(UUID.randomUUID()).setSessionId(sesId).setAction("NebulaUserActions.list").setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            Assert.assertEquals(Collections.singletonList(USERNAME), this.result(r, new TypeReference<List<String>>(){}));
            return true;
        });
    }

    @Test
    public void shouldAddUser() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(USERNAME, PASSWORD)));
        Request req = new Request().setId(UUID.randomUUID()).setSessionId(sesId).setAction("NebulaUserActions.add").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new SecurityCredentials(OTHER_USERNAME, PASSWORD));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            return true;
        });
        Request listReq = new Request().setId(UUID.randomUUID()).setSessionId(sesId).setAction("NebulaUserActions.list").setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)listReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            Assert.assertEquals(Arrays.asList(USERNAME, OTHER_USERNAME), this.result(r, new TypeReference<List<String>>(){}));
            return true;
        });
    }

    @Test
    public void shouldFailWithoutRoleOnAddingUser() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(USERNAME, PASSWORD)));
        this.cluster.ignite().cache("ignite-roles-cache").remove((Object)USERNAME);
        Request req = new Request().setId(UUID.randomUUID()).setSessionId(sesId).setAction("NebulaUserActions.add").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new SecurityCredentials(OTHER_USERNAME, PASSWORD));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assert.assertEquals((Object)"Invalid user role", (Object)r.getError().getMessage());
            return true;
        });
    }

    @Test
    public void shouldFailWithoutRolesCacheOnAddingUser() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(USERNAME, PASSWORD)));
        this.cluster.ignite().destroyCache("ignite-roles-cache");
        Request req = new Request().setId(UUID.randomUUID()).setSessionId(sesId).setAction("NebulaUserActions.add").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new SecurityCredentials(OTHER_USERNAME, PASSWORD));
        this.executeAction((AbstractRequest)req.setId(UUID.randomUUID()), res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assert.assertEquals((Object)"ignite-roles-cache cache does not exist", (Object)r.getError().getMessage());
            return true;
        });
    }

    @Test
    public void shouldRemoveUser() {
        TestUtils.createUser((IgniteEx)this.cluster.ignite(), OTHER_USERNAME, PASSWORD, USERNAME);
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(USERNAME, PASSWORD)));
        Request req = new Request().setId(UUID.randomUUID()).setSessionId(sesId).setAction("NebulaUserActions.remove").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)OTHER_USERNAME);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            return true;
        });
        Request listReq = new Request().setId(UUID.randomUUID()).setSessionId(sesId).setAction("NebulaUserActions.list").setNodeIds(Collections.singleton(this.cluster.localNode().id()));
        this.executeAction((AbstractRequest)listReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            Assert.assertEquals(Collections.singletonList(USERNAME), this.result(r, new TypeReference<List<String>>(){}));
            return true;
        });
    }
}

