/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.PluginConfiguration;
import org.assertj.core.util.Lists;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.SnapshotArgument;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotActionsControllerWithPitrTest
extends AbstractActionControllerTest {
    @Override
    protected void cleanup() {
        super.cleanup();
        this.deleteDirectory("custom-snapshot-dir");
        this.deleteDirectory("snapshot");
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) {
        return super.getConfiguration(igniteInstanceName).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setPointInTimeRecoveryEnabled(true))});
    }

    @Test
    public void shouldRecoveryTo() throws InterruptedException {
        SnapshotFuture<Void> fut = TestUtils.createFullSnapshot(this.cluster.ignite(), null, null);
        fut.get(20L, TimeUnit.SECONDS);
        long time = System.currentTimeMillis();
        Thread.sleep(50L);
        IgniteCache cache = this.cluster.ignite().cache("test-cache");
        cache.put((Object)1, (Object)3);
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.recoveryTo").setArgument((Object)new SnapshotArgument().setTime(time).setPaths((List)Lists.newArrayList((Object[])new File[]{TestUtils.resolveSnapshotDirectory()})).setMessage("Test recovery snapshot"));
        this.executeAction(req, Duration.ofMinutes(2L), res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null || r.getStatus() != Status.COMPLETED) {
                return false;
            }
            Assert.assertNull((Object)r.getResult());
            Assert.assertEquals((Object)2, (Object)cache.get((Object)1));
            return true;
        });
    }
}

