/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithGridGainSecurityTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.CacheArgument;
import org.gridgain.control.agent.dto.action.CacheLostPartitionsArgument;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.junit.Assert;
import org.junit.Test;

public class CacheActionsControllerWithGridGainSecurityTest
extends AbstractActionControllerWithGridGainSecurityTest {
    private static final int PARTS_CNT = 32;
    private static final int KEY_COUNT = 10000;
    private static final String ADMIN_OPS_ACCOUNT = "adminOps";
    private static final String ADMIN_CACHE_ACCOUNT = "adminCache";
    private static final String CACHE_REMOVE_ACCOUNT = "cacheRemove";
    private static final String TASK_EXECUTE_ACCOUNT = "taskExecute";

    @Override
    protected Map<SecurityCredentials, String> prepareCustomCredentials() {
        HashMap<SecurityCredentials, String> creds = new HashMap<SecurityCredentials, String>(5);
        creds.put(new SecurityCredentials(ADMIN_OPS_ACCOUNT, "123456"), "{     defaultAllow: false,    {        system:[ADMIN_OPS]    },    {        task:'*',        permissions:[TASK_EXECUTE]    }}");
        creds.put(new SecurityCredentials(ADMIN_CACHE_ACCOUNT, "123456"), "{     defaultAllow: false,    {        system:[ADMIN_CACHE]    }}");
        creds.put(new SecurityCredentials(CACHE_REMOVE_ACCOUNT, "123456"), "{     defaultAllow: false,    {        cache: '*',        permissions: [CACHE_REMOVE]    },    {        task:'*',        permissions:[TASK_EXECUTE]    }}");
        creds.put(new SecurityCredentials(TASK_EXECUTE_ACCOUNT, "123456"), "{     defaultAllow: false,    {        task:'*',        permissions:[TASK_EXECUTE]    }}");
        return creds;
    }

    @Override
    protected int clusterSize() {
        return 2;
    }

    @Test
    public void shouldPerformResetLostPartitionsWithAdminOpsAccount() {
        this.checkSecureResetLostPartitions(ADMIN_OPS_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailResetLostPartitionsWithNoAccessAccount() {
        this.checkSecureResetLostPartitions("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformClearWithCacheRemoveAccount() {
        this.checkSecureClear(CACHE_REMOVE_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailClearWithTaskExecuteAccount() {
        this.checkSecureClear(TASK_EXECUTE_ACCOUNT, "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformRebalanceWithAdminCacheAccount() {
        this.checkSecureRebalance(ADMIN_CACHE_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailRebalanceWithNoAccessAccount() {
        this.checkSecureRebalance("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformLoadCacheWithAdminOpsAccount() {
        this.checkSecureLoadCache(ADMIN_OPS_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailLoadCacheWithTaskExecuteAccount() {
        this.checkSecureLoadCache(TASK_EXECUTE_ACCOUNT, "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    private void checkSecureResetLostPartitions(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        CacheConfiguration cfg = new CacheConfiguration("DEFAULT_CACHE_NAME").setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(32));
        IgniteCache cache = this.cluster.ignite().getOrCreateCache(cfg);
        for (int i = 0; i < 10000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.stopGrid(this.instanceName(1));
        this.cluster.ignite().cluster().setBaselineTopology(Collections.singleton(this.cluster.ignite().cluster().node()));
        Assert.assertEquals((long)1L, (long)this.cluster.currentBaselineTopology().size());
        Assert.assertFalse((boolean)cache.lostPartitions().isEmpty());
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.resetLostPartitions").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setSessionId(sesId).setArgument((Object)new CacheLostPartitionsArgument().setCacheNames(Collections.singleton("DEFAULT_CACHE_NAME")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureClear(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        IgniteCache cache = this.cluster.ignite().getOrCreateCache("DEFAULT_CACHE_NAME");
        for (int i = 0; i < 10000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        Assert.assertEquals((long)10000L, (long)cache.size(new CachePeekMode[]{CachePeekMode.PRIMARY}));
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.clear").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setSessionId(sesId).setArgument((Object)new CacheArgument().setCacheName("DEFAULT_CACHE_NAME"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureRebalance(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.rebalance").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setSessionId(sesId).setArgument((Object)new CacheArgument().setCacheName("DEFAULT_CACHE_NAME"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureLoadCache(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        this.cluster.ignite().getOrCreateCache("DEFAULT_CACHE_NAME");
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.loadCache").setSessionId(sesId).setArgument((Object)new CacheArgument().setCacheName("DEFAULT_CACHE_NAME"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }
}

