/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent;

import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterImpl;
import org.apache.ignite.internal.processors.authentication.IgniteAuthenticationProcessor;
import org.apache.ignite.internal.processors.cluster.ClusterProcessor;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.action.SessionRegistry;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public abstract class AbstractOidcMockTest {
    public static final String TOKEN_TYPE = "Bearer";
    public static final String TOKEN_VALUE = "correct_token";
    public static final UUID CLUSTER_ID = UUID.fromString("a-a-a-a-a");
    @Mock
    protected GridKernalContext ctx;
    @Mock
    protected SecurityContext authenticatedCtx;
    @Mock
    protected SessionRegistry sesRegistry;
    @Mock
    protected IgniteSecurity security;
    @Mock
    protected IgniteAuthenticationProcessor authentication;
    @Mock
    protected PluginProvider<?> pluginProvider;
    @Mock
    protected ControlCenterAgent agent;
    @Mock
    protected IgniteEx grid;
    @Mock
    protected IgniteClusterImpl cluster;
    @Mock
    protected ClusterProcessor clusterProc;
    @Mock
    protected ClusterNode node;
    @Mock
    protected IgniteCompute compute;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.ctx.security()).thenReturn((Object)this.security);
        Mockito.when((Object)this.ctx.authentication()).thenReturn((Object)this.authentication);
        Mockito.when((Object)this.ctx.pluginProvider((String)ArgumentMatchers.eq((Object)"ControlCenterAgent"))).thenReturn(this.pluginProvider);
        Mockito.when((Object)this.ctx.log((Class)ArgumentMatchers.any(Class.class))).thenReturn(Mockito.mock(IgniteLogger.class));
        Mockito.when((Object)this.ctx.grid()).thenReturn((Object)this.grid);
        Mockito.when((Object)this.ctx.cluster()).thenReturn((Object)this.clusterProc);
        Mockito.when((Object)this.security.enabled()).thenReturn((Object)true);
        Mockito.when((Object)this.security.authenticate((AuthenticationContext)ArgumentMatchers.any())).thenAnswer(mock -> {
            Map userObj;
            AuthenticationContext authCtx = (AuthenticationContext)mock.getArgument(0);
            if (authCtx.credentials() != null && authCtx.credentials().getUserObject() instanceof Map && TOKEN_TYPE.equals((userObj = (Map)authCtx.credentials().getUserObject()).get("tokenType")) && TOKEN_VALUE.equals(userObj.get("accessToken"))) {
                return this.authenticatedCtx;
            }
            return null;
        });
        Mockito.when((Object)this.authentication.enabled()).thenReturn((Object)false);
        Mockito.when((Object)this.pluginProvider.plugin()).thenReturn((Object)this.agent);
        Mockito.when((Object)this.agent.sessionRegistry()).thenReturn((Object)this.sesRegistry);
        Mockito.when((Object)this.grid.cluster()).thenReturn((Object)this.cluster);
        Mockito.when((Object)this.grid.compute()).thenReturn((Object)this.compute);
        Mockito.when((Object)this.grid.compute((ClusterGroup)ArgumentMatchers.any())).thenReturn((Object)this.compute);
        Mockito.when((Object)this.grid.localNode()).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.consistentId()).thenReturn((Object)"nodeId");
        Mockito.when((Object)this.clusterProc.get()).thenReturn((Object)this.cluster);
        Mockito.when((Object)this.clusterProc.getId()).thenReturn((Object)CLUSTER_ID);
        Mockito.when((Object)this.cluster.id()).thenReturn((Object)CLUSTER_ID);
        Mockito.when((Object)this.cluster.forPredicate((IgnitePredicate)ArgumentMatchers.any())).thenReturn(Mockito.mock(ClusterGroup.class));
    }
}

