/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.transport.ws;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.config.WebSocketConfig;
import org.gridgain.control.agent.configuration.ControlCenterAgentConfiguration;
import org.gridgain.control.agent.dto.compute.ComputeTaskPullRequest;
import org.gridgain.control.agent.test.TestLogger;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentUtils;
import org.junit.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.web.socket.CloseStatus;

public class WebSocketManagerTest
extends AgentCommonAbstractTest {
    @Test
    public void shouldSendParallelMessages() throws Exception {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)ignite);
        ExecutorService srv = Executors.newFixedThreadPool(2);
        ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>();
        for (int i = 0; i < 500; ++i) {
            list.add(CompletableFuture.runAsync(() -> agent.sendToControlCenter("/topic/first", (Object)1), srv));
            list.add(CompletableFuture.runAsync(() -> agent.sendToControlCenter("/topic/second", (Object)2), srv));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
        TestUtils.assertWithPoll(() -> this.inInterceptor.getAllPayloads("/topic/first", String.class).size() == 500);
        TestUtils.assertWithPoll(() -> this.inInterceptor.getAllPayloads("/topic/second", String.class).size() == 500);
    }

    @Test
    public void shouldReconnect() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        this.websocketDecoratedFactory.disconnectAllClients();
        TestUtils.assertWithPoll(() -> this.websocketDecoratedFactory.getConnectedSessionsCount() == 1);
    }

    @Test
    public void shouldNotReconnectOnLargeRequest() throws Exception {
        TestLogger log = new TestLogger();
        IgniteEx ignite = this.startNodeWithTestLogger(log, "node-1");
        this.changeAgentConfiguration(ignite);
        log.clear();
        ArrayList<ComputeTaskPullRequest> req = new ArrayList<ComputeTaskPullRequest>(1000);
        for (int i = 0; i < 1000; ++i) {
            req.add(new ComputeTaskPullRequest(IgniteUuid.randomUuid(), UUID.randomUUID()));
        }
        this.template.convertAndSend((Object)StompDestinationsUtils.buildComputeTaskPullTopic((UUID)ignite.cluster().id()), req);
        U.sleep((long)1000L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)log.contains("Lost websocket connection with Control Center"));
    }

    @Test
    public void shouldReconnectOnOverflow() throws Exception {
        TestLogger log = new TestLogger();
        IgniteEx ignite = this.startNodeWithTestLogger(log, "node-1");
        this.changeAgentConfiguration(ignite);
        Assertions.assertThat(this.websocketDecoratedFactory.closeStatuses()).isEmpty();
        log.clear();
        byte[] req = new byte[10485860];
        this.template.convertAndSend((Object)StompDestinationsUtils.buildComputeTaskPullTopic((UUID)ignite.cluster().id()), (Object)req);
        U.sleep((long)1000L);
        Assertions.assertThat(this.websocketDecoratedFactory.closeStatuses()).contains((Object[])new CloseStatus[]{CloseStatus.SERVER_ERROR.withReason("Buffer overflow.")});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)log.contains("The websocket connection was unexpectedly closed"));
    }

    @Test
    public void shouldConnectToThirdUrlFromList() {
        IgniteEx ignite = this.startGrid();
        ControlCenterAgent agent = AgentUtils.ggccAgent((IgniteEx)ignite);
        ControlCenterAgentConfiguration cfg = agent.configuration().setUris(Arrays.asList("http://localhost:3000", "http://localhost:3010", "http://localhost:" + this.port));
        agent.configuration(cfg);
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildActionRequestTopic((UUID)ignite.context().cluster().get().id())));
    }

    @ActiveProfiles(value={"two-way-ssl"})
    @SpringBootTest(classes={WebSocketConfig.class}, properties={"server.ssl.keyStore=classpath:ssl/control.p12"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    public static class TwoWaySSLWithInvalidKeyStoreTest
    extends AgentCommonAbstractTest {
        @Test
        public void shouldPrintCorrectError() {
            TestLogger log1 = new TestLogger();
            IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
            this.changeAgentConfiguration(crd, false, true, true, false);
            TestUtils.assertWithPoll(() -> log1.contains("cause=\"No name matching localhost found\", suggestion=\"Check SSL connection properties - make sure that the 'commonName' in the Control Center's certificate matches the hostname in the Agent's connection URI\""));
        }
    }

    @ActiveProfiles(value={"two-way-ssl"})
    @SpringBootTest(classes={WebSocketConfig.class}, properties={"server.ssl.keyStore=classpath:ssl/server-outdated.p12"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    public static class TwoWaySSLWithExpiredKeyStoreTest
    extends AgentCommonAbstractTest {
        @Test
        public void shouldPrintExpiredError() {
            TestLogger log1 = new TestLogger();
            IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
            this.changeAgentConfiguration(crd, false, true, true, false);
            TestUtils.assertWithPoll(() -> log1.contains("cause=\"NotAfter:"));
        }
    }

    @ActiveProfiles(value={"two-way-ssl"})
    @SpringBootTest(classes={WebSocketConfig.class}, properties={"server.ssl.trustStore=classpath:ssl/ca-other.p12"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    public static class TwoWaySSLWithInvalidTrustStoreTest
    extends AgentCommonAbstractTest {
        @Test
        public void shouldPrintMissingCAInTrustStore() throws IgniteCheckedException {
            TestLogger log1 = new TestLogger();
            IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
            this.setDistributedProperty(crd, "wsHandshakeTimeout", "5");
            this.changeAgentConfiguration(crd, false, true, true, false);
            TestUtils.assertWithPoll(() -> log1.contains("suggestion=\"Check SSL connection properties"));
        }
    }

    @ActiveProfiles(value={"one-way-ssl"})
    @SpringBootTest(classes={WebSocketConfig.class}, properties={"server.ssl.client-auth=need"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    public static class TwoWaySSLWithMissingTrustStoreTest
    extends AgentCommonAbstractTest {
        @Test
        public void shouldPrintMissingTrustStore() throws IgniteCheckedException {
            TestLogger log1 = new TestLogger();
            IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
            this.setDistributedProperty(crd, "wsHandshakeTimeout", "5");
            this.changeAgentConfiguration(crd, false, true, true, false);
            TestUtils.assertWithPoll(() -> log1.contains("suggestion=\"Check SSL connection properties"));
        }
    }

    @ActiveProfiles(value={"two-way-ssl"})
    public static class TwoWaySSLTest
    extends AgentCommonAbstractTest {
        @Test
        public void shouldConnectToSecuredBackendWithClientCertificate() {
            IgniteEx ignite = this.startGrid();
            this.changeAgentConfiguration(ignite, true, true, true, false);
        }

        @Test
        public void shouldNotConnectWithKeyStoreInProperties() {
            IgniteEx ignite = this.startGrid();
            try {
                System.setProperty("javax.net.ssl.keyStoreType", "PKCS12");
                System.setProperty("javax.net.ssl.keyStore", this.getClass().getClassLoader().getResource("ssl/client.p12").getPath());
                System.setProperty("javax.net.ssl.keyStorePassword", "123456");
                this.changeAgentConfiguration(ignite, false, true, false, false);
                Awaitility.with().await().pollInterval(2L, TimeUnit.SECONDS).atMost(4L, TimeUnit.SECONDS).until(() -> !this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildActionRequestTopic((UUID)ignite.context().cluster().get().id())));
            }
            finally {
                System.clearProperty("javax.net.ssl.keyStoreType");
                System.clearProperty("javax.net.ssl.keyStore");
                System.clearProperty("javax.net.ssl.keyStorePassword");
            }
        }

        @Test
        public void shouldConnectWithKeyStoreInProperties() {
            IgniteEx ignite = this.startGrid();
            try {
                System.setProperty("javax.net.ssl.keyStoreType", "PKCS12");
                System.setProperty("javax.net.ssl.keyStore", this.getClass().getClassLoader().getResource("ssl/ca-other.p12").getPath());
                System.setProperty("javax.net.ssl.keyStorePassword", "123456");
                this.changeAgentConfiguration(ignite, true, true, true, false);
            }
            finally {
                System.clearProperty("javax.net.ssl.keyStoreType");
                System.clearProperty("javax.net.ssl.keyStore");
                System.clearProperty("javax.net.ssl.keyStorePassword");
            }
        }

        @Test
        public void shouldPrintMissingKeyStore() throws IgniteCheckedException {
            TestLogger log1 = new TestLogger();
            IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
            this.setDistributedProperty(crd, "wsHandshakeTimeout", "5");
            this.changeAgentConfiguration(crd, false, true, false, false);
            TestUtils.assertWithPoll(() -> log1.contains("suggestion=\"Check SSL connection properties"));
        }

        @Test
        public void shouldPrintCorrectErrorWithInvalidCA() {
            TestLogger log1 = new TestLogger();
            IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
            this.changeAgentConfiguration(crd, false, this.buildControlCenterUri(true, false), this.resourcePath("ssl/ca-other.p12"), "123456", this.resourcePath("ssl/client.p12"), "123456");
            TestUtils.assertWithPoll(() -> log1.contains("cause=\"PKIX path validation failed: java.security.cert.CertPathValidatorException: signature check failed\", suggestion=\"Check SSL connection properties - make sure the certificate authority in Control Center Agent's trust store is correct\""));
        }

        @Test
        public void shouldPrintFailedToLoadTrustStore() {
            TestLogger log1 = new TestLogger();
            IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
            this.changeAgentConfiguration(crd, false, this.buildControlCenterUri(true, false), this.resourcePath("ssl/ca.p12"), "wrong-password", this.resourcePath("ssl/client.p12"), "123456");
            TestUtils.assertWithPoll(() -> log1.contains("Failed to establish websocket connection with Control Center"));
        }

        @Test
        public void shouldPrintFailedToLoadKeyStore() {
            TestLogger log1 = new TestLogger();
            IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
            this.changeAgentConfiguration(crd, false, this.buildControlCenterUri(true, false), this.resourcePath("ssl/ca.p12"), "123456", this.resourcePath("ssl/client.p12"), "wrong-password");
            TestUtils.assertWithPoll(() -> log1.contains("Failed to establish websocket connection with Control Center"));
        }

        @Test
        public void shouldPrintWrongPathToTrustStore() {
            TestLogger log1 = new TestLogger();
            IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
            this.changeAgentConfiguration(crd, false, this.buildControlCenterUri(true, false), this.resourcePath("ssl/ca.p12"), "123456", "ssl/client-wrong.p12", "123456");
            TestUtils.assertWithPoll(() -> log1.contains("Failed to establish websocket connection with Control Center"));
        }

        @Test
        public void shouldPrintWrongPathToKeyStore() {
            TestLogger log1 = new TestLogger();
            IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
            this.changeAgentConfiguration(crd, false, this.buildControlCenterUri(true, false), "ssl/ca-wrong.p12", "123456", this.resourcePath("ssl/client.p12"), "123456");
            TestUtils.assertWithPoll(() -> log1.contains("Failed to establish websocket connection with Control Center"));
        }
    }

    @ActiveProfiles(value={"one-way-ssl"})
    public static class SSLTest
    extends AgentCommonAbstractTest {
        @Test
        public void shouldConnectToSecuredBackend() {
            IgniteEx ignite = this.startGrid();
            this.changeAgentConfiguration(ignite, true, true, false, false);
        }

        @Test
        public void shouldNotConnectToSecuredBackendWithoutTrustStore() {
            IgniteEx ignite = this.startGrid();
            this.changeAgentConfiguration(ignite, false);
            Awaitility.with().await().pollInterval(2L, TimeUnit.SECONDS).atMost(4L, TimeUnit.SECONDS).until(() -> !this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildActionRequestTopic((UUID)ignite.context().cluster().get().id())));
        }

        @Test
        public void shouldConnectToSecuredBackendWithTrustAll() {
            System.setProperty("trust.all", "true");
            try {
                IgniteEx ignite = this.startGrid();
                this.changeAgentConfiguration(ignite);
            }
            finally {
                System.clearProperty("trust.all");
            }
        }

        @Test
        public void shouldPrintCorrectErrorOnInvalidSchema() {
            TestLogger log1 = new TestLogger();
            IgniteEx crd = this.startNodeWithTestLogger(log1, "node-1");
            this.changeAgentConfiguration(crd, false);
            TestUtils.assertWithPoll(() -> log1.contains("Failed to establish websocket connection with Control Center"));
        }
    }
}

