/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.control.agent.test.TestLogger;

public class InvalidUsagesLogger
extends TestLogger {
    private static final String CONTROL_AGENT_ROOT_PACKAGE = "org.gridgain.control.agent";
    private final List<String> invalidUsages = Collections.synchronizedList(new ArrayList());

    public InvalidUsagesLogger(boolean infoEnabled, boolean debugEnabled) {
        super(Collections.synchronizedList(new ArrayList(512)), infoEnabled, debugEnabled);
    }

    @Override
    public void info(String msg) {
        super.info(msg);
        if (!this.isInfoEnabled()) {
            this.invalidUsages.add(msg);
        }
    }

    @Override
    public void debug(String msg) {
        super.debug(msg);
        if (!this.isDebugEnabled()) {
            this.invalidUsages.add(msg);
        }
    }

    public IgniteLogger getLogger(Object ctgr) {
        String logName = String.valueOf(ctgr);
        if (InvalidUsagesLogger.isControlAgentPackage(logName)) {
            return this;
        }
        return new TestLogger(this.buf, this.isInfoEnabled(), this.isDebugEnabled()).wrap(this.log);
    }

    public Collection<String> invalidUsages() {
        return new ArrayList<String>(this.invalidUsages);
    }

    @Override
    public void clear() {
        super.clear();
        this.invalidUsages.clear();
    }

    private static boolean isControlAgentPackage(String logName) {
        return F.isEmpty((String)logName) || CONTROL_AGENT_ROOT_PACKAGE.startsWith(logName);
    }
}

