/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.feature;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.resource.DependencyResolver;
import org.awaitility.Awaitility;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.feature.AgentDynamicFeatures;
import org.gridgain.control.agent.dto.feature.BatchBoundedAgentFeatureRequest;
import org.gridgain.control.agent.dto.feature.DisablingAgentFeatureRequest;
import org.gridgain.control.agent.dto.feature.TemporarilyDisablingAgentFeatureRequest;
import org.gridgain.control.agent.dto.feature.ThrottlingAgentFeatureRequest;
import org.gridgain.control.agent.processor.feature.AgentDynamicFeatureProcessor;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.RegistryNoopDependencyResolver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AgentDynamicFeatureIntegrationTest
extends AgentCommonAbstractTest {
    protected IgniteClusterEx cluster;
    private RegistryNoopDependencyResolver di;

    @Before
    public void setUp() throws Exception {
        this.di = new RegistryNoopDependencyResolver();
        IgnitionEx.dependencyResolver((DependencyResolver)this.di);
        IgniteEx ignite = this.startGrid(1);
        this.changeAgentConfiguration(ignite);
        this.cluster = ignite.cluster();
        this.cluster.state(ClusterState.ACTIVE);
    }

    @After
    public void tearDown() throws Exception {
        IgnitionEx.dependencyResolver(null);
    }

    @Test
    public void shouldDisableFeatureWithExpiration() {
        AgentDynamicFeatureProcessor proc = this.di.getDependency(AgentDynamicFeatureProcessor.class);
        Assert.assertTrue((boolean)proc.isAvailable(AgentDynamicFeatures.TRACING));
        Assert.assertFalse((boolean)proc.isThrottled(AgentDynamicFeatures.TRACING));
        TemporarilyDisablingAgentFeatureRequest req = new TemporarilyDisablingAgentFeatureRequest(AgentDynamicFeatures.TRACING.getValue(), 2000L);
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildAgentFeatureTopic((UUID)this.cluster.id())));
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAgentFeatureTopic((UUID)this.cluster.id()), (Object)req);
        Awaitility.with().pollInterval(500L, TimeUnit.MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS).until(() -> !proc.isAvailable(AgentDynamicFeatures.TRACING));
        Assert.assertFalse((boolean)proc.isThrottled(AgentDynamicFeatures.TRACING));
    }

    @Test
    public void shouldDisableFeature() {
        AgentDynamicFeatureProcessor proc = this.di.getDependency(AgentDynamicFeatureProcessor.class);
        Assert.assertTrue((boolean)proc.isAvailable(AgentDynamicFeatures.TRACING));
        Assert.assertFalse((boolean)proc.isThrottled(AgentDynamicFeatures.TRACING));
        DisablingAgentFeatureRequest req = new DisablingAgentFeatureRequest(AgentDynamicFeatures.TRACING.getValue(), false);
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildAgentFeatureTopic((UUID)this.cluster.id())));
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAgentFeatureTopic((UUID)this.cluster.id()), (Object)req);
        Awaitility.with().pollInterval(500L, TimeUnit.MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS).until(() -> !proc.isAvailable(AgentDynamicFeatures.TRACING));
        Assert.assertFalse((boolean)proc.isThrottled(AgentDynamicFeatures.TRACING));
    }

    @Test
    public void shouldThrottleFeatureByRequest() {
        AgentDynamicFeatureProcessor proc = this.di.getDependency(AgentDynamicFeatureProcessor.class);
        Assert.assertTrue((boolean)proc.isAvailable(AgentDynamicFeatures.TRACING));
        Assert.assertFalse((boolean)proc.isThrottled(AgentDynamicFeatures.TRACING));
        ThrottlingAgentFeatureRequest req = new ThrottlingAgentFeatureRequest(AgentDynamicFeatures.TRACING.getValue(), 2000L, 10);
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildAgentFeatureTopic((UUID)this.cluster.id())));
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAgentFeatureTopic((UUID)this.cluster.id()), (Object)req);
        Assert.assertTrue((boolean)proc.isAvailable(AgentDynamicFeatures.TRACING));
        Awaitility.with().pollInterval(500L, TimeUnit.MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS).until(() -> proc.isThrottled(AgentDynamicFeatures.TRACING));
    }

    @Test
    public void shouldReturnBatchSizeWhenRequestActivateThisFeature() {
        AgentDynamicFeatureProcessor proc = this.di.getDependency(AgentDynamicFeatureProcessor.class);
        Assert.assertTrue((boolean)proc.isAvailable(AgentDynamicFeatures.TRACING));
        Assert.assertFalse((boolean)proc.isThrottled(AgentDynamicFeatures.TRACING));
        Assert.assertEquals((long)proc.getBatchSize(AgentDynamicFeatures.TRACING), (long)Integer.MAX_VALUE);
        BatchBoundedAgentFeatureRequest req = new BatchBoundedAgentFeatureRequest(AgentDynamicFeatures.TRACING.getValue(), 2000L, 10);
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildAgentFeatureTopic((UUID)this.cluster.id())));
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAgentFeatureTopic((UUID)this.cluster.id()), (Object)req);
        Awaitility.with().pollInterval(500L, TimeUnit.MILLISECONDS).await().atMost(10L, TimeUnit.SECONDS).until(() -> proc.getBatchSize(AgentDynamicFeatures.TRACING) == 10);
        Assert.assertFalse((boolean)proc.isThrottled(AgentDynamicFeatures.TRACING));
        Assert.assertTrue((boolean)proc.isAvailable(AgentDynamicFeatures.TRACING));
    }
}

