/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.export.metric;

import java.time.Clock;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.control.agent.ControlCenterAgent;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.configuration.DistributedMetricExporterConfiguration;
import org.gridgain.control.agent.dto.feature.AgentDynamicFeatures;
import org.gridgain.control.agent.dto.metric.MetricRegistrySchema;
import org.gridgain.control.agent.dto.metric.MetricRegistrySchemaItem;
import org.gridgain.control.agent.dto.metric.MetricResponse;
import org.gridgain.control.agent.dto.metric.MetricSchema;
import org.gridgain.control.agent.dto.metric.MetricSchemaItem;
import org.gridgain.control.agent.dto.metric.MetricType;
import org.gridgain.control.agent.processor.MetricRegistryProcessor;
import org.gridgain.control.agent.processor.export.metric.LocalNodeMetricsExporterProcessor;
import org.gridgain.control.agent.processor.export.metric.MetricMapper;
import org.gridgain.control.agent.processor.export.metric.MetricsSenderProcessor;
import org.gridgain.control.agent.processor.feature.AgentDynamicFeatureProcessor;
import org.gridgain.control.agent.test.MetricTreeFixture;
import org.gridgain.control.agent.test.TestGridKernalContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MetricProcessorTest {
    private static final int TEST_BATCH_BUFFER_SIZE = 10;
    private static final int TEST_BATCH_SIZE = 5;
    private final MetricMapper metricMapper = new MetricMapper();
    private MetricsSenderProcessor proc;
    private ControlCenterAgent agent;
    private LocalNodeMetricsExporterProcessor exporter;
    private AgentDynamicFeatureProcessor agentDynamicFeatureProcessor;

    @Before
    public void setup() throws Exception {
        System.setProperty("METRIC_MAX_BATCH_BUFFER_SIZE", String.valueOf(10));
        System.setProperty("METRIC_MAX_BUFFER_SIZE", String.valueOf(5));
        this.agent = (ControlCenterAgent)Mockito.mock(ControlCenterAgent.class);
        this.agentDynamicFeatureProcessor = (AgentDynamicFeatureProcessor)Mockito.mock(AgentDynamicFeatureProcessor.class);
        Mockito.when((Object)this.agentDynamicFeatureProcessor.isAvailable((AgentDynamicFeatures)ArgumentMatchers.any(AgentDynamicFeatures.class))).thenReturn((Object)true);
        DistributedMetricExporterConfiguration cfg = new DistributedMetricExporterConfiguration((GridKernalContext)new TestGridKernalContext());
        this.proc = (MetricsSenderProcessor)Mockito.spy((Object)new MetricsSenderProcessor((GridKernalContext)new TestGridKernalContext(), this.agent, cfg, this.agentDynamicFeatureProcessor));
        Clock clock = Clock.systemDefaultZone();
        this.exporter = new LocalNodeMetricsExporterProcessor((GridKernalContext)new TestGridKernalContext(), this.agentDynamicFeatureProcessor, this.metricMapper, new MetricRegistryProcessor((GridKernalContext)new TestGridKernalContext(), new TestGridKernalContext().metric(), clock, cfg), clock);
    }

    @After
    public void tearDown() {
        System.clearProperty("METRIC_MAX_BATCH_BUFFER_SIZE");
        System.clearProperty("METRIC_MAX_BUFFER_SIZE");
    }

    @Test
    public void shouldMergeCompletelyDifferentSchemas() {
        MetricSchema schema1 = this.createSchema("cache.Person1", "CachePuts");
        MetricSchema schema2 = this.createSchema("cache.Person2", "CacheGets");
        MetricSchema actual = this.proc.mergeSchemas(Arrays.asList(schema1, schema2));
        this.assertContainsExactlyRegistries(actual, "cache.Person1", "cache.Person2");
        MetricRegistrySchema registry1 = this.getMetricRegistrySchema(actual, "cache.Person1");
        MetricRegistrySchema registry2 = this.getMetricRegistrySchema(actual, "cache.Person2");
        this.assertContainsExactlyRegistryItems(registry1, new MetricRegistrySchemaItem("CachePuts", MetricType.LONG));
        this.assertContainsExactlyRegistryItems(registry2, new MetricRegistrySchemaItem("CacheGets", MetricType.LONG));
    }

    @Test
    public void shouldMergeSchemasWithSameRegistry() {
        MetricSchema schema1 = this.createSchema("cache.Person", "CachePuts");
        MetricSchema schema2 = this.createSchema("cache.Person", "CacheGets");
        MetricSchema actual = this.proc.mergeSchemas(Arrays.asList(schema1, schema2));
        this.assertContainsExactlyRegistries(actual, "cache.Person");
        MetricRegistrySchema registry = this.getMetricRegistrySchema(actual, "cache.Person");
        this.assertContainsExactlyRegistryItems(registry, new MetricRegistrySchemaItem("CachePuts", MetricType.LONG), new MetricRegistrySchemaItem("CacheGets", MetricType.LONG));
    }

    @Test
    public void shouldMergeSchemasWithSameItems() {
        MetricSchema schema1 = this.createSchema("cache.Person1", "CachePuts");
        MetricSchema schema2 = this.createSchema("cache.Person2", "CachePuts");
        MetricSchema actual = this.proc.mergeSchemas(Arrays.asList(schema1, schema2));
        this.assertContainsExactlyRegistries(actual, "cache.Person1", "cache.Person2");
        Assert.assertEquals((Object)"cache.Person1", (Object)((MetricSchemaItem)actual.items().get(0)).prefix());
        Assert.assertEquals((Object)"cache.Person2", (Object)((MetricSchemaItem)actual.items().get(1)).prefix());
        MetricRegistrySchema registry1 = this.getMetricRegistrySchema(actual, "cache.Person1");
        MetricRegistrySchema registry2 = this.getMetricRegistrySchema(actual, "cache.Person2");
        this.assertContainsExactlyRegistryItems(registry1, new MetricRegistrySchemaItem("CachePuts", MetricType.LONG));
        this.assertContainsExactlyRegistryItems(registry2, new MetricRegistrySchemaItem("CachePuts", MetricType.LONG));
    }

    @Test
    public void shouldMergeIdenticalSchemas() {
        MetricSchema schema1 = this.createSchema("cache.Person", "CachePuts");
        MetricSchema schema2 = this.createSchema("cache.Person", "CachePuts");
        MetricSchema actual = this.proc.mergeSchemas(Arrays.asList(schema1, schema2));
        this.assertContainsExactlyRegistries(actual, "cache.Person");
        MetricRegistrySchema registry = this.getMetricRegistrySchema(actual, "cache.Person");
        this.assertContainsExactlyRegistryItems(registry, new MetricRegistrySchemaItem("CachePuts", MetricType.LONG));
    }

    @Test
    public void shouldRejectMetricSendingWhenBuffIsFull() {
        UUID nodeId = UUID.randomUUID();
        MetricResponse metric = this.metricMapper.metricMessage(nodeId, "tag", System.currentTimeMillis(), nodeId.toString(), MetricTreeFixture.generateMetrics(), false);
        for (int i = 0; i < 20; ++i) {
            this.proc.processMetricResponse(nodeId, (Object)metric, (byte)0);
        }
        Assert.assertEquals((long)10L, (long)((Collection)U.field((Object)this.proc, (String)"buf")).size());
    }

    @Test
    public void shouldSendMetricLessThanBatchSize() {
        UUID nodeId = UUID.randomUUID();
        MetricResponse metric = this.metricMapper.metricMessage(nodeId, "tag", System.currentTimeMillis(), nodeId.toString(), MetricTreeFixture.generateMetrics(), false);
        for (int i = 0; i < 10; ++i) {
            this.proc.processMetricResponse(nodeId, (Object)metric, (byte)0);
        }
        this.proc.sendMetrics();
        this.proc.sendMetrics();
        ((ControlCenterAgent)Mockito.verify((Object)this.agent, (VerificationMode)Mockito.times((int)2))).sendToControlCenter((String)ArgumentMatchers.eq((Object)StompDestinationsUtils.buildMetricsDest()), ArgumentMatchers.any());
    }

    @Test
    public void shouldNotSendMetricsWhenIsNotAvailable() {
        MetricResponse msg = new MetricResponse(new byte[0]);
        this.proc.processMetricResponse(UUID.randomUUID(), (Object)msg, (byte)0);
        Mockito.when((Object)this.agentDynamicFeatureProcessor.isAvailable((AgentDynamicFeatures)ArgumentMatchers.eq((Object)AgentDynamicFeatures.METRICS))).thenReturn((Object)false);
        this.proc.sendMetrics();
        ((ControlCenterAgent)Mockito.verify((Object)this.agent, (VerificationMode)Mockito.never())).sendToControlCenter(ArgumentMatchers.anyString(), ArgumentMatchers.any());
    }

    private MetricSchema createSchema(String regName, String itemName) {
        MetricSchema.Builder schemaBldr = MetricSchema.Builder.newInstance();
        MetricRegistrySchema.Builder regBldr = MetricRegistrySchema.Builder.newInstance();
        regBldr.add(itemName, MetricType.LONG);
        schemaBldr.add(regName, regName, regBldr.build());
        return schemaBldr.build();
    }

    private MetricRegistrySchema getMetricRegistrySchema(MetricSchema schema, String registryName) {
        for (int i = 0; i < schema.items().size(); ++i) {
            if (!((MetricSchemaItem)schema.items().get(i)).prefix().equals(registryName)) continue;
            return schema.registrySchema((short)i);
        }
        throw new IllegalStateException("Failed to find registry schema [registryName=" + registryName + "]");
    }

    private void assertContainsExactlyRegistries(MetricSchema schema, String ... registryNames) {
        HashSet<String> names = new HashSet<String>(Arrays.asList(registryNames));
        for (MetricSchemaItem item : schema.items()) {
            names.remove(item.prefix());
        }
        Assert.assertTrue((boolean)names.isEmpty());
    }

    private void assertContainsExactlyRegistryItems(MetricRegistrySchema registrySchema, MetricRegistrySchemaItem ... schemaItems) {
        HashSet<MetricRegistrySchemaItem> items = new HashSet<MetricRegistrySchemaItem>(Arrays.asList(schemaItems));
        for (MetricRegistrySchemaItem item : registrySchema.items()) {
            items.remove(item);
        }
        Assert.assertTrue((boolean)items.isEmpty());
    }
}

