/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.action;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithGridGainSecurityTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.TaskResponse;
import org.junit.Assert;
import org.junit.Test;

public class DistributedActionServiceWithGridGainSecurityTest
extends AbstractActionControllerWithGridGainSecurityTest {
    @Override
    protected int clusterSize() {
        return 3;
    }

    @Test
    public void shouldExecuteActionOnCoordinatorNode() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("admin", "123456")).setAddress(InetSocketAddress.createUnresolved("localhost", 8090)));
        UUID crdId = this.cluster.localNode().id();
        String consistentId = String.valueOf(this.cluster.localNode().consistentId());
        Request req = new Request().setId(UUID.randomUUID()).setAction("TestActionControllerWithSecurity.nodeIdAction").setNodeIds(Collections.singleton(crdId)).setSessionId(sesId);
        this.executeAction((AbstractRequest)req, res -> {
            List<TaskResponse> taskResults = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskResults.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> completedTask = taskResults.stream().filter(r -> r.getStatus() == Status.COMPLETED).findFirst();
            if (runningTask.isPresent() && completedTask.isPresent()) {
                return res.size() == completedTask.get().getJobCount();
            }
            return false;
        });
        JobResponse res2 = this.jobResult(req.getId());
        Assert.assertEquals((Object)consistentId, (Object)res2.getNodeConsistentId());
        Assert.assertEquals((Object)crdId, (Object)UUID.fromString((String)res2.getResult()));
    }

    @Test
    public void shouldExecuteActionOnNonCoordinatorNodes() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("admin", "123456")).setAddress(InetSocketAddress.createUnresolved("localhost", 8090)));
        Request req = new Request().setId(UUID.randomUUID()).setAction("TestActionControllerWithSecurity.nodeIdAction").setNodeIds(this.nonCrdNodeIds).setSessionId(sesId);
        this.executeAction((AbstractRequest)req, res -> {
            List<TaskResponse> taskResults = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskResults.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> completedTask = taskResults.stream().filter(r -> r.getStatus() == Status.COMPLETED).findFirst();
            if (runningTask.isPresent() && completedTask.isPresent()) {
                Set results = res.stream().map(r -> UUID.fromString(r.getResult().toString())).collect(Collectors.toSet());
                return res.size() == completedTask.get().getJobCount() && results.equals(this.nonCrdNodeIds);
            }
            return false;
        });
        List<JobResponse> responses = this.jobResults(req.getId());
        boolean responsesHasCorrectConsistentIds = this.nonCrdNodeConsistentIds.containsAll(responses.stream().map(JobResponse::getNodeConsistentId).collect(Collectors.toSet()));
        Assert.assertTrue((boolean)responsesHasCorrectConsistentIds);
    }

    @Test
    public void shouldExecuteActionOnAllNodes() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("admin", "123456")).setAddress(InetSocketAddress.createUnresolved("localhost", 8090)));
        Request req = new Request().setId(UUID.randomUUID()).setAction("TestActionControllerWithSecurity.nodeIdAction").setSessionId(sesId);
        this.executeAction((AbstractRequest)req, res -> {
            List<TaskResponse> taskResults = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskResults.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> completedTask = taskResults.stream().filter(r -> r.getStatus() == Status.COMPLETED).findFirst();
            if (runningTask.isPresent() && completedTask.isPresent()) {
                Set results = res.stream().map(r -> UUID.fromString(r.getResult().toString())).collect(Collectors.toSet());
                return res.size() == completedTask.get().getJobCount() && results.equals(this.allNodeIds);
            }
            return false;
        });
        List<JobResponse> responses = this.jobResults(req.getId());
        boolean responsesHasCorrectConsistentIds = this.allNodeConsistentIds.containsAll(responses.stream().map(JobResponse::getNodeConsistentId).collect(Collectors.toSet()));
        Assert.assertTrue((boolean)responsesHasCorrectConsistentIds);
    }

    @Test
    public void shouldExecuteActionOnAllNodesWithNodeStop() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("admin", "123456")).setAddress(InetSocketAddress.createUnresolved("localhost", 8090)));
        Request req = new Request().setId(UUID.randomUUID()).setAction("TestActionControllerWithSecurity.nodeIdActionWithSleep").setArgument((Object)5000).setSessionId(sesId);
        this.executeActionAndStopNode((AbstractRequest)req, 1000L, 1, res -> {
            List<TaskResponse> taskResults = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskResults.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> failedTask = taskResults.stream().filter(r -> r.getStatus() == Status.FAILED).findFirst();
            if (runningTask.isPresent() && failedTask.isPresent()) {
                long failedJobCnt = res.stream().filter(r -> r.getStatus() == Status.FAILED).count();
                return res.size() == failedTask.get().getJobCount() && failedJobCnt == 1L;
            }
            return false;
        });
    }

    @Test
    public void shouldSendErrorResponseOnExecutingSecuredActionWithoutAuthentication() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.numberAction").setArgument((Object)10);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(req.getId());
            return taskRes.getStatus() == Status.FAILED && r.getError().getCode() == -32001;
        });
    }

    @Test
    public void shouldSendErrorResponseOnExecutingSecuredActionWithInvalidSessionId() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.numberAction").setArgument((Object)10).setSessionId(UUID.randomUUID());
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(req.getId());
            return taskRes.getStatus() == Status.FAILED && r.getError().getCode() == -32001;
        });
    }

    @Test
    public void shouldSendErrorResponseWhenUserHaveNotPermissions() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("no_access", "123456")).setAddress(InetSocketAddress.createUnresolved("localhost", 8090)));
        Request req = new Request().setId(UUID.randomUUID()).setAction("TestActionControllerWithSecurity.adminAction").setArgument((Object)10).setSessionId(sesId);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            TaskResponse taskRes = this.taskResult(req.getId());
            return taskRes.getStatus() == Status.FAILED && r.getError().getCode() == -32002;
        });
    }

    @Test
    public void shouldRequiredAdminOpsForDistributedAction() {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials("no_access", "123456")).setAddress(InetSocketAddress.createUnresolved("localhost", 8090)));
        Request req = new Request().setId(UUID.randomUUID()).setAction("TestActionControllerWithSecurity.noopAction").setArgument((Object)10).setSessionId(sesId);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            Status status = this.taskResult(req.getId()).getStatus();
            return status == Status.RUNNING || status == Status.COMPLETED;
        });
    }
}

