/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.collision.CollisionSpi;
import org.apache.ignite.spi.collision.priorityqueue.PriorityQueueCollisionSpi;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.gridgain.aws.encryption.spi.AwsKmsEncryptionSpi;
import org.gridgain.aws.encryption.spi.AwsKmsEncryptionSpiSelfTest;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.configuration.AgentFeatures;
import org.gridgain.control.agent.dto.cluster.ClusterEdition;
import org.gridgain.control.agent.dto.cluster.ClusterInfo;
import org.gridgain.control.agent.dto.cluster.RollingUpgradeInfo;
import org.gridgain.control.agent.dto.cluster.RollingUpgradeState;
import org.gridgain.control.agent.dto.cluster.TdeType;
import org.gridgain.control.agent.processor.ClusterInfoProcessor;
import org.gridgain.control.agent.processor.deployment.ManagedDeploymentSpi;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.DrReceiverConfiguration;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.memory.DrSenderInMemoryStore;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import software.amazon.awssdk.services.kms.KmsClient;

public class ClusterInfoProcessorTest
extends AgentCommonAbstractTest {
    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        return super.getConfiguration(instanceName).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration()});
    }

    @Test
    public void shouldSendChangedActiveState() {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> {
            ClusterInfo info = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)cluster.id()), ClusterInfo.class);
            Assert.assertTrue((boolean)info.isActive());
            Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)info.getState());
        });
        cluster.state(ClusterState.INACTIVE);
        TestUtils.assertWithPoll(() -> {
            ClusterInfo info = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)cluster.id()), ClusterInfo.class);
            Assert.assertFalse((boolean)info.isActive());
            Assert.assertEquals((Object)ClusterState.INACTIVE, (Object)info.getState());
        });
        cluster.state(ClusterState.ACTIVE_READ_ONLY);
        TestUtils.assertWithPoll(() -> {
            ClusterInfo info = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)cluster.id()), ClusterInfo.class);
            Assert.assertTrue((boolean)info.isActive());
            Assert.assertEquals((Object)ClusterState.ACTIVE_READ_ONLY, (Object)info.getState());
        });
    }

    @Test
    public void shouldSendChangedTag() {
        IgniteEx ignite_1 = this.startGrid(0);
        this.changeAgentConfiguration(ignite_1);
        IgniteClusterEx cluster = ignite_1.cluster();
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> {
            ClusterInfo info = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)cluster.id()), ClusterInfo.class);
            Assert.assertEquals((Object)cluster.tag(), (Object)info.getTag());
        });
        String newTag = UUID.randomUUID().toString();
        cluster.tag(newTag);
        TestUtils.assertWithPoll(() -> {
            ClusterInfo info = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)cluster.id()), ClusterInfo.class);
            Assert.assertEquals((Object)newTag, (Object)info.getTag());
        });
    }

    private void shouldSendGridGainClusterInfo(boolean persistenceEnabled, boolean snapshotsEnabled, boolean pntInTimeRecoveryEnabled, boolean managedDeploymentSpiEnabled, boolean priQueueSpiEnabled, boolean drSenderHubEnabled, boolean drReceiverHubEnabled) {
        this.startGrid(this.createConfiguration("node-1", persistenceEnabled, snapshotsEnabled, pntInTimeRecoveryEnabled, managedDeploymentSpiEnabled, priQueueSpiEnabled, drSenderHubEnabled, drReceiverHubEnabled));
        this.startGrid(this.createConfiguration("client-node-1", persistenceEnabled, snapshotsEnabled, pntInTimeRecoveryEnabled, managedDeploymentSpiEnabled, priQueueSpiEnabled, drSenderHubEnabled, drReceiverHubEnabled).setClientMode(true));
        IgniteEx ignite = this.startGrid(this.createConfiguration("node-2", persistenceEnabled, snapshotsEnabled, pntInTimeRecoveryEnabled, managedDeploymentSpiEnabled, priQueueSpiEnabled, drSenderHubEnabled, drReceiverHubEnabled));
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        int expSrvNodesCnt = (int)cluster.nodes().stream().filter(AgentUtils.not(ClusterNode::isClient)).count();
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> {
            ClusterInfo info = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)cluster.id()), ClusterInfo.class);
            if (info == null) {
                return false;
            }
            Set features = AgentUtils.getClusterFeatures((GridKernalContext)ignite.context(), (Collection)cluster.nodes());
            features.addAll(AgentFeatures.getAgentFeatures((Collection)cluster.nodes()));
            features.addAll(ClusterInfoProcessor.ULTIMATE_FEATURES);
            features.addAll(ClusterInfoProcessor.ENTERPRISE_FEATURES);
            features.add("TRACING_SUPPORTED");
            features.add("TRACING_DYNAMIC_CONFIGURATION");
            features.add("CACHE_ENDPOINT_AVAILABLE_FEATURE");
            features.add("CACHE_STATISTICS_FEATURE");
            features.add("CLUSTER_CHANGE_TAG_FEATURE");
            features.add("CACHE_LOAD");
            features.add("SCHEDULE_SNAPSHOT");
            Assert.assertEquals((Object)cluster.id(), (Object)info.getId());
            Assert.assertEquals((Object)cluster.tag(), (Object)info.getTag());
            Assert.assertEquals((long)cluster.baselineAutoAdjustTimeout(), (long)info.getBaselineParameters().getAutoAdjustAwaitingTime());
            Assert.assertEquals((Object)cluster.isBaselineAutoAdjustEnabled(), (Object)info.getBaselineParameters().isAutoAdjustEnabled());
            Assert.assertEquals((Object)persistenceEnabled, (Object)info.isPersistenceEnabled());
            Assert.assertEquals((Object)snapshotsEnabled, (Object)info.getSnapshotsEnabled());
            Assert.assertEquals((Object)pntInTimeRecoveryEnabled, (Object)info.isPointInTimeRecoveryEnabled());
            Assert.assertEquals((Object)snapshotsEnabled, (Object)info.getSnapshotsEnabled());
            Assert.assertTrue((boolean)info.isTracingEnabled());
            Assert.assertEquals((Object)managedDeploymentSpiEnabled, (Object)info.isManagedDeploymentSpiEnabled());
            Assert.assertTrue((boolean)info.isEventDrivenServiceProcessorEnabled());
            Assert.assertEquals((Object)priQueueSpiEnabled, (Object)info.isPriorityQueueSpiEnabled());
            Assert.assertEquals((Object)features, (Object)info.getFeatures());
            Assert.assertEquals((Object)ClusterEdition.GRIDGAIN_ULTIMATE, (Object)info.getEdition());
            Assert.assertEquals((long)1L, (long)info.getVersions().size());
            Assert.assertEquals((long)expSrvNodesCnt, (long)info.getServerNodesCount());
            Assert.assertNull((Object)info.getTde());
            Assert.assertFalse((boolean)info.getRollingUpgrade().isConfigured());
            Assert.assertEquals((Object)RollingUpgradeState.INACTIVE, (Object)info.getRollingUpgrade().getState());
            Assert.assertEquals((long)15L, (long)info.getDcId().byteValue());
            Assert.assertEquals((Object)drSenderHubEnabled, (Object)info.isDrSender());
            Assert.assertEquals((Object)drReceiverHubEnabled, (Object)info.isDrReceiver());
            return true;
        });
    }

    private IgniteConfiguration createConfiguration(String igniteInstanceName, boolean persistenceEnabled, boolean snapshotsEnabled, boolean pntInTimeRecoveryEnabled, boolean managedDeploymentSpiEnabled, boolean priQueueSpiEnabled, boolean drSenderHubEnabled, boolean drReceiverHubEnabled) {
        IgniteConfiguration cfg = this.getConfiguration(igniteInstanceName);
        if (!persistenceEnabled) {
            cfg.setDataStorageConfiguration(null);
        }
        SnapshotConfiguration snapshotCfg = snapshotsEnabled ? new SnapshotConfiguration().setPointInTimeRecoveryEnabled(pntInTimeRecoveryEnabled) : null;
        DrSenderConfiguration sndConfiguration = drSenderHubEnabled ? new DrSenderConfiguration().setConnectionConfiguration(new DrSenderConnectionConfiguration[]{new DrSenderConnectionConfiguration().setDataCenterId((byte)5).setReceiverAddresses(new String[]{"127.0.0.1"}).setStore((DrSenderStore)new DrSenderInMemoryStore())}) : null;
        DrReceiverConfiguration rcvConfiguration = drReceiverHubEnabled ? new DrReceiverConfiguration().setLocalInboundPort(1221) : null;
        cfg.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setDataCenterId((byte)15).setSnapshotConfiguration(snapshotCfg).setDrReceiverConfiguration(rcvConfiguration).setDrSenderConfiguration(sndConfiguration)});
        cfg.setDeploymentSpi((DeploymentSpi)(managedDeploymentSpiEnabled ? new ManagedDeploymentSpi() : null));
        cfg.setCollisionSpi((CollisionSpi)(priQueueSpiEnabled ? new PriorityQueueCollisionSpi() : null));
        return cfg;
    }

    @Test
    public void shouldSendGridGainClusterInfoWithSnapshots() {
        this.shouldSendGridGainClusterInfo(true, true, false, false, false, false, false);
    }

    @Test
    public void shouldSendGridGainClusterInfoWithoutSnapshots() {
        this.shouldSendGridGainClusterInfo(false, false, false, false, false, false, false);
    }

    @Test
    public void shouldSendGridGainClusterInfoWithPersistenceAndWithoutSnapshots() {
        this.shouldSendGridGainClusterInfo(true, false, false, false, false, false, false);
    }

    @Test
    public void shouldSendGridGainClusterInfoWithPitr() {
        this.shouldSendGridGainClusterInfo(true, true, true, false, false, false, false);
    }

    @Test
    public void shouldSendGridGainClusterInfoWithCodeDeployment() {
        this.shouldSendGridGainClusterInfo(true, false, false, true, false, false, false);
    }

    @Test
    public void shouldSendGridGainClusterInfoWithPriorityQueueCollisionSpi() {
        this.shouldSendGridGainClusterInfo(true, false, false, false, true, false, false);
    }

    @Test
    public void shouldSendGridGainClusterInfoWithDrConfiguration() {
        this.shouldSendGridGainClusterInfo(true, false, false, false, true, true, true);
    }

    @Test
    public void shouldSendGridGainClusterInfoWithAwsKmsEncryptionSpi() {
        AwsKmsEncryptionSpi encryptionSpi = AwsKmsEncryptionSpiSelfTest.spi((KmsClient)Mockito.mock(KmsClient.class));
        IgniteEx ignite = this.startGrid(this.getConfiguration("node-1").setEncryptionSpi((EncryptionSpi)encryptionSpi));
        this.changeAgentConfiguration(ignite);
        TestUtils.assertWithPoll(() -> {
            ClusterInfo info = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)ignite.cluster().id()), ClusterInfo.class);
            Assert.assertEquals((Object)TdeType.AWS_KMS, (Object)info.getTde().getType());
        });
    }

    @Test
    public void shouldSendGridGainClusterInfoWithRollingUpgrade() {
        IgniteEx ignite = this.startGrid(this.getConfiguration("node-1").setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setRollingUpdatesEnabled(true)}));
        this.changeAgentConfiguration(ignite);
        TestUtils.assertWithPoll(() -> {
            RollingUpgradeInfo rollingUpgrade = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)ignite.cluster().id()), ClusterInfo.class).getRollingUpgrade();
            Assert.assertTrue((boolean)rollingUpgrade.isConfigured());
            Assert.assertEquals((Object)RollingUpgradeState.INACTIVE, (Object)rollingUpgrade.getState());
        });
        ignite.cluster().state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> {
            RollingUpgradeInfo rollingUpgrade = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)ignite.cluster().id()), ClusterInfo.class).getRollingUpgrade();
            Assert.assertTrue((boolean)rollingUpgrade.isConfigured());
            Assert.assertEquals((Object)RollingUpgradeState.INACTIVE, (Object)rollingUpgrade.getState());
        });
        GridGain gg = (GridGain)ignite.context().grid().plugin("GridGain");
        gg.rollingUpgrade().start();
        TestUtils.assertWithPoll(() -> {
            RollingUpgradeInfo rollingUpgrade = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)ignite.cluster().id()), ClusterInfo.class).getRollingUpgrade();
            Assert.assertTrue((boolean)rollingUpgrade.isConfigured());
            Assert.assertEquals((Object)RollingUpgradeState.ACTIVE, (Object)rollingUpgrade.getState());
        });
        gg.rollingUpgrade().force();
        TestUtils.assertWithPoll(() -> {
            RollingUpgradeInfo rollingUpgrade = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)ignite.cluster().id()), ClusterInfo.class).getRollingUpgrade();
            Assert.assertTrue((boolean)rollingUpgrade.isConfigured());
            Assert.assertEquals((Object)RollingUpgradeState.ACTIVE_FORCE, (Object)rollingUpgrade.getState());
        });
        gg.rollingUpgrade().finish();
        TestUtils.assertWithPoll(() -> {
            RollingUpgradeInfo rollingUpgrade = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterDest((UUID)ignite.cluster().id()), ClusterInfo.class).getRollingUpgrade();
            Assert.assertTrue((boolean)rollingUpgrade.isConfigured());
            Assert.assertEquals((Object)RollingUpgradeState.INACTIVE, (Object)rollingUpgrade.getState());
        });
    }
}

