/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.configuration;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.impl.GridClientNodeImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.assertj.core.api.Assertions;
import org.gridgain.control.agent.configuration.AgentFeatures;
import org.gridgain.control.agent.test.TestClusterNode;
import org.gridgain.control.agent.test.TestGridKernalContext;
import org.junit.Assert;
import org.junit.Test;

public class AgentFeaturesTest {
    @Test
    public void shouldReturnFeatures() throws Exception {
        TestGridKernalContext ctx = new TestGridKernalContext();
        List<ClusterNode> nodes = Arrays.asList(new TestClusterNode(U.map((Object)"plugins.gridgain.control.center.agent.present", (Object)true, (Object)"plugins.gridgain.control.center.agent.features", (Object)AgentFeatures.featuresAsByteArray((GridKernalContext)ctx))), new TestClusterNode(U.map((Object)"plugins.gridgain.control.center.agent.present", (Object)true, (Object)"plugins.gridgain.control.center.agent.features", (Object)AgentFeatures.featuresAsByteArray((GridKernalContext)ctx))));
        Assertions.assertThat((Iterable)AgentFeatures.getAgentFeatures(nodes)).containsExactlyInAnyOrderElementsOf((Iterable)AgentFeatures.allFeatures((GridKernalContext)ctx).stream().map(Enum::name).collect(Collectors.toList()));
    }

    @Test
    public void shouldReturnFeaturesSupportedByAllNodes() throws Exception {
        TestGridKernalContext ctx = new TestGridKernalContext();
        BitSet limitedSet = new BitSet(2);
        limitedSet.set(AgentFeatures.METRICS_COLLECTION_LIMIT.getFeatureId());
        limitedSet.set(AgentFeatures.TRIGGER_GC_SUPPORTED.getFeatureId());
        List<ClusterNode> nodes = Arrays.asList(new TestClusterNode(U.map((Object)"plugins.gridgain.control.center.agent.present", (Object)true, (Object)"plugins.gridgain.control.center.agent.features", (Object)AgentFeatures.featuresAsByteArray((GridKernalContext)ctx))), new TestClusterNode(U.map((Object)"plugins.gridgain.control.center.agent.present", (Object)true, (Object)"plugins.gridgain.control.center.agent.features", (Object)limitedSet.toByteArray())));
        Assert.assertEquals((Object)F.asSet((Object[])new String[]{AgentFeatures.METRICS_COLLECTION_LIMIT.name(), AgentFeatures.TRIGGER_GC_SUPPORTED.name()}), (Object)AgentFeatures.getAgentFeatures(nodes));
    }

    @Test
    public void shouldReturnFeaturesThatAreNotSupported() throws Exception {
        TestGridKernalContext ctx = new TestGridKernalContext();
        List<ClusterNode> nodes = Arrays.asList(new TestClusterNode(U.map((Object)"plugins.gridgain.control.center.agent.present", (Object)true)), new TestClusterNode(U.map((Object)"plugins.gridgain.control.center.agent.present", (Object)true, (Object)"plugins.gridgain.control.center.agent.features", (Object)AgentFeatures.featuresAsByteArray((GridKernalContext)ctx))));
        Assert.assertTrue((boolean)AgentFeatures.getAgentFeatures(nodes).isEmpty());
    }

    @Test
    public void supportsFeature() {
        String features = AgentFeatures.METRICS_COLLECTION_LIMIT + "," + AgentFeatures.EXTENDED_CONNECTION_STATUS;
        GridClientNodeImpl node = GridClientNodeImpl.builder().attributes(U.map((Object)"plugins.gridgain.control.center.agent.present", (Object)true, (Object)"plugins.gridgain.control.center.agent.features.list", (Object)features)).build();
        Assert.assertTrue((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.METRICS_COLLECTION_LIMIT, (GridClientNode)node));
        Assert.assertTrue((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.EXTENDED_CONNECTION_STATUS, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.NODE_CONFIGURATION_FEATURE, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.CODE_DEPLOYMENT, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.COMPUTE_GRID_MONITORING, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.RUNNING_QUERIES_MONITORING, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.COLLECT_SNAPSHOT_LIST, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.AWS_KMS_TDE_SUPPORTED, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.TRIGGER_GC_SUPPORTED, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.THREAD_DUMP_SUPPORTED, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.LOGS_COLLECTION_SUPPORTED, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.BINARY_TYPE_MANAGEMENT, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.DATA_REPLICATION_MONITORING, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.GRIDGAIN_SNAPSHOT_OPERATIONS, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.RUNNING_QUERY_CONFIGURATION, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.BINARY_TYPE_WITH_AFFINITY_KEY, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.DATA_REPLICATION_START_FULL_STATE_TRANSFER_WITH_DCID, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.SERVICES_STOP, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.DOWNLOAD_ALL_DEBUG_INFO, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.DEBUG_INFO_JVM_INFO, (GridClientNode)node));
        Assert.assertFalse((boolean)AgentFeatures.supportsFeature((AgentFeatures)AgentFeatures.DOWNLOAD_ALL_DEBUG_INFO_V2, (GridClientNode)node));
    }

    @Test
    public void supportsDisabledByDefaultFeatures() throws Exception {
        for (AgentFeatures feature : AgentFeatures.DISABLED_BY_DEFAULT) {
            this.checkDisabledByDefaultFeature(feature);
        }
    }

    private void checkDisabledByDefaultFeature(AgentFeatures feature) throws IgniteCheckedException {
        TestGridKernalContext ctx = new TestGridKernalContext();
        Assert.assertFalse((boolean)AgentFeatures.featuresAsString((GridKernalContext)ctx).contains(feature.name()));
        try {
            System.setProperty(feature.name(), "true");
            Assert.assertTrue((boolean)AgentFeatures.featuresAsString((GridKernalContext)ctx).contains(feature.name()));
        }
        finally {
            System.clearProperty(feature.name());
        }
    }
}

