/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.sasl.AuthenticationException;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/api/v1/internal/binary-meta/resources"})
@Controller
public class UploadedBinaryMetaController {
    public static final UUID SUFFICIENT_REQUEST_ID = UUID.fromString("0702f8ec-2c66-4f2b-9fa5-cde473db379e");
    private final Map<UUID, MultipartFile> multipartFileMap = new ConcurrentHashMap<UUID, MultipartFile>();

    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(consumes={"multipart/form-data"})
    public void upload(@RequestHeader(value="X-ACTION-REQUEST-ID") UUID reqId, @RequestPart BinaryMetaUploadRequest req, @RequestPart MultipartFile file) throws IOException {
        if (!SUFFICIENT_REQUEST_ID.equals(reqId)) {
            throw new AuthenticationException("Authentication error: bad X-ACTION-REQUEST-ID");
        }
        MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getOriginalFilename(), file.getContentType(), file.getBytes());
        this.multipartFileMap.put(req.getResourceId(), (MultipartFile)mockMultipartFile);
    }

    public Map<UUID, MultipartFile> getMultipartFileMap() {
        return this.multipartFileMap;
    }

    public void clear() {
        this.multipartFileMap.clear();
    }

    public static class BinaryMetaUploadRequest {
        private UUID resourceId;

        public UUID getResourceId() {
            return this.resourceId;
        }

        public BinaryMetaUploadRequest setResourceId(UUID resourceId) {
            this.resourceId = resourceId;
            return this;
        }
    }
}

