/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.assertj.core.util.Sets;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithGridGainSecurityTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.SnapshotArgument;
import org.gridgain.control.agent.dto.action.SnapshotOperationArgument;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.SnapshotsUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.junit.Test;

public class SnapshotActionsControllerWithGridGainSecurityTest
extends AbstractActionControllerWithGridGainSecurityTest {
    private static final String ADMIN_OPS_ACCOUNT = "adminOps";
    private static final String ADMIN_CACHE_ACCOUNT = "adminCache";
    private static final String ADMIN_VIEW_ACCOUNT = "adminView";

    @Override
    protected Map<SecurityCredentials, String> prepareCustomCredentials() {
        HashMap<SecurityCredentials, String> creds = new HashMap<SecurityCredentials, String>(1);
        creds.put(new SecurityCredentials(ADMIN_OPS_ACCOUNT, "123456"), "{     defaultAllow: false,    {        system:[ADMIN_OPS]    }}");
        creds.put(new SecurityCredentials(ADMIN_CACHE_ACCOUNT, "123456"), "{     defaultAllow: false,    {        system:[ADMIN_CACHE]    }}");
        creds.put(new SecurityCredentials(ADMIN_VIEW_ACCOUNT, "123456"), "{     defaultAllow: false,    {        system:[ADMIN_VIEW]    }}");
        return creds;
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.deleteDirectory("custom-snapshot-dir");
        this.deleteDirectory("snapshot");
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        GridGainConfiguration ggCfg = (GridGainConfiguration)cfg.getPluginConfigurations()[0];
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration());
        return cfg;
    }

    @Test
    public void shouldPerformCreateFullSnapshotWithAdminOpsAccount() {
        this.checkSecureCreateFullSnapshot(ADMIN_OPS_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailCreateFullSnapshotWithNoAccessAccount() {
        this.checkSecureCreateFullSnapshot("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformCreateIncrementalSnapshotWithAdminOpsAccount() {
        this.checkSecureCreateIncrementalSnapshot(ADMIN_OPS_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailCreateIncrementalSnapshotWithNoAccessAccount() {
        this.checkSecureCreateIncrementalSnapshot("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformDeleteSnapshotWithAdminCacheAccount() {
        this.checkSecureDeleteSnapshot(ADMIN_CACHE_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailDeleteSnapshotWithNoAccessAccount() {
        this.checkSecureDeleteSnapshot("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformCopySnapshotWithAdminCacheAccount() {
        this.checkSecureCopySnapshot(ADMIN_CACHE_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailCopySnapshotWithNoAccessAccount() {
        this.checkSecureCopySnapshot("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformMoveSnapshotWithAdminCacheAccount() {
        this.checkSecureMoveSnapshot(ADMIN_CACHE_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailMoveSnapshotWithNoAccessAccount() {
        this.checkSecureMoveSnapshot("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformCheckSnapshotWithAdminOpsAccount() throws IgniteCheckedException {
        this.checkSecureCheckSnapshot(ADMIN_OPS_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailCheckSnapshotWithNoAccessAccount() throws IgniteCheckedException {
        this.checkSecureCheckSnapshot("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformGetListOfSnapshotsWithAdminViewAccount() {
        this.checkSecureGetListOfSnapshots(ADMIN_VIEW_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailGetListOfSnapshotsWithNoAccessAccount() {
        this.checkSecureGetListOfSnapshots("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformRestoreSnapshotWithAdminCacheAccount() {
        this.checkSecureRestoreSnapshot(ADMIN_CACHE_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailRestoreSnapshotWithNoAccessAccount() {
        this.checkSecureRestoreSnapshot("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformCancelSnapshotWithAdminOpsAccount() {
        this.checkSecureCancelSnapshot(ADMIN_OPS_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailCancelSnapshotWithNoAccessAccount() {
        this.checkSecureCancelSnapshot("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    private void checkSecureCreateFullSnapshot(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        String msg = "Test snapshot";
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.create").setSessionId(sesId).setArgument((Object)new SnapshotArgument().setFullSnapshot(true).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setSnapshotOperationParallelism(1).setCompressionOption(CompressionOption.NONE).setMessage(msg));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureCreateIncrementalSnapshot(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        TestUtils.createFullSnapshot(this.cluster.ignite(), cacheNames, TestUtils.resolveSnapshotDirectory()).get(20L, TimeUnit.SECONDS);
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.create").setSessionId(sesId).setArgument((Object)new SnapshotArgument().setCacheNames(Sets.set((Object[])new String[]{"test-cache"})).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setSnapshotOperationParallelism(1).setCompressionOption(CompressionOption.NONE).setMessage("Test snapshot"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureDeleteSnapshot(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        GridSnapshotEx snapshot = SnapshotsUtils.snapshot((Ignite)this.cluster.ignite());
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        TestUtils.createFullSnapshot(this.cluster.ignite(), cacheNames, null).get(20L, TimeUnit.SECONDS);
        SnapshotInfo info = (SnapshotInfo)F.first((List)snapshot.listSnapshots(Collections.emptyList()));
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.delete").setSessionId(sesId).setArgument((Object)new SnapshotArgument().setSnapshotId(info.snapshotId()).setDeleteSources(true).setMessage("Test delete snapshot"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureCopySnapshot(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        GridSnapshotEx snapshot = SnapshotsUtils.snapshot((Ignite)this.cluster.ignite());
        TestUtils.createFullSnapshot(this.cluster.ignite(), null, null).get(20L, TimeUnit.SECONDS);
        SnapshotInfo info = (SnapshotInfo)F.first((List)snapshot.listSnapshots(Collections.emptyList()));
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.copy").setSessionId(sesId).setArgument((Object)new SnapshotArgument().setSnapshotId(info.snapshotId()).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setMessage("Test copy snapshot"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureMoveSnapshot(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        GridSnapshotEx snapshot = SnapshotsUtils.snapshot((Ignite)this.cluster.ignite());
        TestUtils.createFullSnapshot(this.cluster.ignite(), null, null).get(20L, TimeUnit.SECONDS);
        SnapshotInfo info = (SnapshotInfo)F.first((List)snapshot.listSnapshots(Collections.emptyList()));
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.move").setSessionId(sesId).setArgument((Object)new SnapshotArgument().setSnapshotId(info.snapshotId()).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setMessage("Test move snapshot"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureCheckSnapshot(String acc, String pwd, Predicate<JobResponse> resChecker) throws IgniteCheckedException {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        SnapshotFuture<Void> fut = TestUtils.createFullSnapshot(this.cluster.ignite(), cacheNames, null);
        fut.get(20L, TimeUnit.SECONDS);
        long snapshotId = fut.snapshotOperation().snapshotId();
        TestUtils.corruptSnapshot(snapshotId, Collections.singleton("snapshot"), "test-cache".hashCode());
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.check").setSessionId(sesId).setArgument((Object)new SnapshotArgument().setSnapshotId(snapshotId).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setCacheNames(cacheNames).setMessage("Test check snapshot"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureGetListOfSnapshots(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        this.cluster.ignite().getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        SnapshotFuture<Void> fut = TestUtils.createFullSnapshot(this.cluster.ignite(), cacheNames, null);
        fut.get(20L, TimeUnit.SECONDS);
        this.inInterceptor.clearMessages();
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.reloadList").setSessionId(sesId);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureRestoreSnapshot(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        SnapshotFuture<Void> fut = TestUtils.createFullSnapshot(this.cluster.ignite(), null, null);
        fut.get(20L, TimeUnit.SECONDS);
        long snapshotId = fut.snapshotOperation().snapshotId();
        IgniteCache cache = this.cluster.ignite().cache("test-cache");
        cache.put((Object)1, (Object)3);
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.restore").setSessionId(sesId).setArgument((Object)new SnapshotArgument().setSnapshotId(snapshotId).setPaths(F.asList((Object)TestUtils.resolveSnapshotDirectory())).setCacheNames(cacheNames).setForce(true).setMessage("Test restore snapshot"));
        this.executeAction(req, Duration.ofMinutes(2L), res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureCancelSnapshot(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        SnapshotFuture<Void> fut = TestUtils.createFullSnapshot(this.cluster.ignite(), null, null);
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.cancelSnapshotOperation").setSessionId(sesId).setArgument((Object)new SnapshotOperationArgument().setOperationId(fut.operationId()).setForce(true).setMessage("Test cancel snapshot"));
        this.executeAction(req, Duration.ofMinutes(2L), res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }
}

