/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithAuthenticationTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.junit.Test;

public class SecurityActionsControllerTest
extends AbstractActionControllerWithAuthenticationTest {
    @Test
    public void shouldSuccessfullyAuthenticate() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("SecurityActions.authenticate").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new AuthenticateCredentials().setCredentials(new SecurityCredentials("ignite", "ignite")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED && UUID.fromString((String)r.getResult()) != null;
        });
    }

    @Test
    public void shouldSendErrorResponseWithEmptyCredentials() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("SecurityActions.authenticate").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new AuthenticateCredentials());
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.FAILED && r.getError().getCode() == -32001;
        });
    }

    @Test
    public void shouldSendErrorResponseWithInvalidCredentials() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("SecurityActions.authenticate").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new AuthenticateCredentials().setCredentials(new SecurityCredentials("ignite", "ignite2")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.FAILED && r.getError().getCode() == -32001;
        });
    }
}

