/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.CachePluginConfiguration;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.DrCachesArgument;
import org.gridgain.control.agent.dto.action.DrStartFullStateTransferArgument;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.cache.dr.CacheDrSenderConfiguration;
import org.gridgain.grid.cache.dr.CacheDrStatus;
import org.gridgain.grid.configuration.DrSenderConfiguration;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.dr.DrSenderConnectionConfiguration;
import org.gridgain.grid.dr.store.DrSenderStore;
import org.gridgain.grid.dr.store.memory.DrSenderInMemoryStore;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.GridPluginUtils;
import org.junit.Test;

public class CacheDrActionsControllerTest
extends AbstractActionControllerTest {
    @Test
    public void shouldPerformDrActions() {
        this.stopGrid(0);
        DrSenderConfiguration sndCfg = new DrSenderConfiguration().setConnectionConfiguration(new DrSenderConnectionConfiguration[]{new DrSenderConnectionConfiguration().setDataCenterId((byte)5).setReceiverAddresses(new String[]{"127.0.0.1"}).setStore((DrSenderStore)new DrSenderInMemoryStore())});
        IgniteConfiguration cfg = this.getConfiguration(this.instanceName(0));
        GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)cfg).setDataCenterId((byte)15).setDrSenderConfiguration(sndCfg);
        IgniteEx ignite = this.startGrid(cfg);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.cluster = ignite.cluster();
        GridDr dr = ((GridGainImpl)ignite.context().grid().plugin("GridGain")).dr();
        String cacheName = "cache1";
        CacheConfiguration cacheCfg = new CacheConfiguration(cacheName).setPluginConfigurations(new CachePluginConfiguration[]{new GridGainCacheConfiguration().setDrSenderConfiguration(new CacheDrSenderConfiguration())});
        IgniteCache cache = this.cluster.ignite().getOrCreateCache(cacheCfg);
        cache.put((Object)1, (Object)2);
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.pauseIncrementalDataReplication").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DrCachesArgument().setCacheNames(Collections.singletonList(cacheName)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            CacheDrStatus cacheDrStatus = dr.senderCacheStatus(cacheName);
            return r != null && r.getStatus() == Status.COMPLETED && cacheDrStatus.stopped();
        });
        req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.resumeIncrementalDataReplication").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DrCachesArgument().setCacheNames(Collections.singletonList(cacheName)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            CacheDrStatus cacheDrStatus = dr.senderCacheStatus(cacheName);
            return r != null && r.getStatus() == Status.COMPLETED && !cacheDrStatus.stopped();
        });
        req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.startFullStateTransfer").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DrCachesArgument().setCacheNames(Collections.singletonList(cacheName)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            CacheDrStatus cacheDrStatus = dr.senderCacheStatus(cacheName);
            return r != null && r.getStatus() == Status.COMPLETED && !cacheDrStatus.stopped();
        });
        req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.startFullStateTransfer").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DrStartFullStateTransferArgument().setCacheNames(Collections.singletonList(cacheName)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            CacheDrStatus cacheDrStatus = dr.senderCacheStatus(cacheName);
            return r != null && r.getStatus() == Status.COMPLETED && !cacheDrStatus.stopped();
        });
        req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.startFullStateTransfer").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DrStartFullStateTransferArgument().setDataCenterIds(new byte[]{1, 2, 3}).setCacheNames(Collections.singletonList(cacheName)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            CacheDrStatus cacheDrStatus = dr.senderCacheStatus(cacheName);
            return r != null && r.getStatus() == Status.COMPLETED && !cacheDrStatus.stopped();
        });
        req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.stopFullStateTransfer").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DrCachesArgument().setCacheNames(Collections.singletonList(cacheName)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
    }

    @Test
    public void shouldFailIfDrIsNotConfigured() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.pauseIncrementalDataReplication").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DrCachesArgument().setCacheNames(Collections.singletonList("test-cache")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.FAILED;
        });
    }

    @Test
    public void shouldFailIfCacheDoesNotExist() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.pauseIncrementalDataReplication").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DrCachesArgument().setCacheNames(Collections.singletonList("random-cache")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.FAILED;
        });
    }

    @Test
    public void shouldPassIfNoCacheNameProvided() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheDrActions.pauseIncrementalDataReplication").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new DrCachesArgument().setCacheNames(Collections.emptyList()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
    }
}

