/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.store.CacheStoreAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.CacheDefaultBinaryAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.assertj.core.api.Assertions;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.CacheArgument;
import org.gridgain.control.agent.dto.action.CacheLostPartitionsArgument;
import org.gridgain.control.agent.dto.action.CachePartitionsArgument;
import org.gridgain.control.agent.dto.action.CacheStatisticsArgument;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.baseline.BaselineTopologyArgument;
import org.junit.Assert;
import org.junit.Test;

public class CacheActionsControllerTest
extends AbstractActionControllerTest {
    private static final int PARTS_CNT = 32;
    private static final int KEY_COUNT = 10000;
    private static final String CACHE_NAME = "test-cache";
    private static final String CACHE_DATA_STORE_NAME = "test-cache-datastore";

    @Test
    public void partitions() {
        IgniteCache cache = this.ignite(0).cache(CACHE_NAME);
        for (int i = 0; i < 10000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.partitions").setArgument((Object)new CachePartitionsArgument().setCacheName(CACHE_NAME));
        this.executeAction((AbstractRequest)req, resp -> {
            if (resp.size() != 2) {
                return false;
            }
            int primaryParts = 0;
            int backupParts = 0;
            int primaryKeys = 0;
            int backupKeys = 0;
            for (JobResponse nodeResp : resp) {
                if (nodeResp == null && nodeResp.getStatus() != Status.COMPLETED) {
                    return false;
                }
                Map res = (Map)nodeResp.getResult();
                if (res == null) {
                    return false;
                }
                Map primaryDistr = (Map)res.get("primary");
                primaryParts += primaryDistr.size();
                for (Integer cnt : primaryDistr.values()) {
                    primaryKeys += cnt.intValue();
                }
                Map backupDistr = (Map)res.get("backup");
                backupParts += backupDistr.size();
                for (Integer cnt : backupDistr.values()) {
                    backupKeys += cnt.intValue();
                }
            }
            Assert.assertEquals((long)32L, (long)primaryParts);
            Assert.assertEquals((long)32L, (long)backupParts);
            Assert.assertEquals((long)10000L, (long)primaryKeys);
            Assert.assertEquals((long)10000L, (long)backupKeys);
            return true;
        });
    }

    @Test
    public void lostPartitions() {
        String cacheName = "cacheWithoutBackups";
        CacheConfiguration cfg = new CacheConfiguration(cacheName).setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(32));
        IgniteCache cache = this.cluster.ignite().getOrCreateCache(cfg);
        for (int i = 0; i < 10000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.stopGrid(this.instanceName(1));
        List ids = this.cluster.nodes().stream().map(n -> String.valueOf(n.consistentId())).collect(Collectors.toList());
        Request req = new Request().setId(UUID.randomUUID()).setAction("BaselineActions.setBaselineTopology").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new BaselineTopologyArgument().setConsistentIds(ids));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        Assert.assertEquals((long)1L, (long)this.cluster.currentBaselineTopology().size());
        req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.lostPartitions").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new CacheLostPartitionsArgument().setCacheNames(Collections.singleton(cacheName)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            LinkedHashMap val = (LinkedHashMap)r.getResult();
            LinkedHashMap lostParts = (LinkedHashMap)val.get("lostPartitions");
            List parts = (List)lostParts.get(cacheName);
            return !parts.isEmpty();
        });
        req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.resetLostPartitions").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new CacheLostPartitionsArgument().setCacheNames(Collections.singleton(cacheName)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && Status.COMPLETED == r.getStatus();
        });
        req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.lostPartitions").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new CacheLostPartitionsArgument().setCacheNames(Collections.singleton(cacheName)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            LinkedHashMap val = (LinkedHashMap)r.getResult();
            LinkedHashMap lostParts = (LinkedHashMap)val.get("lostPartitions");
            return lostParts.isEmpty();
        });
    }

    @Test
    public void configuration() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.configuration").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new CacheArgument().setCacheName(CACHE_NAME));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            Map jobRes = (Map)r.getResult();
            Assert.assertTrue((boolean)jobRes.containsKey("cacheName"));
            Assert.assertEquals((Object)CACHE_NAME, jobRes.get("cacheName"));
            Assert.assertTrue((boolean)jobRes.containsKey("json"));
            String cfg = (String)jobRes.get("json");
            Assert.assertTrue((boolean)cfg.contains(String.format("\"name\":\"%s\"", CACHE_NAME)));
            Assert.assertTrue((boolean)cfg.contains(String.format("\"partitions\":%s", 32)));
            Assertions.assertThat((String)cfg).contains(new CharSequence[]{String.format("\"class\":\"%s\"", CacheDefaultBinaryAffinityKeyMapper.class.getName())});
            return true;
        });
    }

    @Test
    public void clear() {
        IgniteCache cache = this.cluster.ignite().getOrCreateCache(CACHE_NAME);
        for (int i = 0; i < 10000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        Assert.assertEquals((long)10000L, (long)cache.size(new CachePeekMode[]{CachePeekMode.PRIMARY}));
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.clear").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new CacheArgument().setCacheName(CACHE_NAME));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        Assert.assertEquals((long)0L, (long)cache.size(new CachePeekMode[]{CachePeekMode.PRIMARY}));
    }

    @Test
    public void destroy() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.destroy").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new CacheArgument().setCacheName(CACHE_NAME));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        Assert.assertFalse((boolean)this.cluster.ignite().cacheNames().contains(CACHE_NAME));
    }

    @Test
    public void rebalance() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.rebalance").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setArgument((Object)new CacheArgument().setCacheName(CACHE_NAME));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
    }

    @Test
    public void enableStatisticsForCache() {
        IgniteInternalCache cache = this.ignite(0).cachex(CACHE_NAME);
        Assert.assertNotNull((Object)cache);
        Assert.assertFalse((boolean)cache.context().statisticsEnabled());
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.enableStatistics").setArgument((Object)new CacheStatisticsArgument().setCacheNames(Collections.singleton(CACHE_NAME)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        Assert.assertTrue((boolean)cache.context().statisticsEnabled());
        req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.enableStatistics").setArgument((Object)new CacheStatisticsArgument().setCacheNames(Collections.singleton(CACHE_NAME)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        Assert.assertTrue((boolean)cache.context().statisticsEnabled());
        req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.disableStatistics").setArgument((Object)new CacheStatisticsArgument().setCacheNames(Collections.singleton(CACHE_NAME)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        Assert.assertFalse((boolean)cache.context().statisticsEnabled());
        req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.disableStatistics").setArgument((Object)new CacheStatisticsArgument().setCacheNames(Collections.singleton(CACHE_NAME)));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && r.getStatus() == Status.COMPLETED;
        });
        Assert.assertFalse((boolean)cache.context().statisticsEnabled());
    }

    @Test
    public void enableStatisticsShouldFailOnInvalidCacheNames() {
        IgniteInternalCache cache = this.ignite(0).cachex(CACHE_NAME);
        Assert.assertNotNull((Object)cache);
        Assert.assertFalse((boolean)cache.context().statisticsEnabled());
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.enableStatistics").setArgument((Object)new CacheStatisticsArgument().setCacheNames(Collections.emptyList()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((long)-32700L, (long)r.getError().getCode());
            Assert.assertEquals((Object)"Ouch! Argument is invalid: Cache names must not be empty.", (Object)r.getError().getMessage());
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            return true;
        });
        req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.enableStatistics").setArgument((Object)new CacheStatisticsArgument().setCacheNames(Arrays.asList(CACHE_NAME, "missing-cache")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((long)-32603L, (long)r.getError().getCode());
            Assert.assertEquals((Object)"One or more cache descriptors not found [caches=[test-cache, missing-cache]]", (Object)r.getError().getMessage());
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            return true;
        });
        Assert.assertFalse((boolean)cache.context().statisticsEnabled());
    }

    @Test
    public void loadDataFromDataStore() {
        TestDataStore.externalDataProvider.clear();
        TestDataStore.postLoadKeys.clear();
        IgniteCache cache = this.ignite(0).createCache(this.getDatastoreCacheConfiguration());
        String loadedKeyFromDatastore = "load-key";
        TestDataStore.externalDataProvider.put(1, loadedKeyFromDatastore);
        Request req = new Request().setId(UUID.randomUUID()).setAction("CacheActions.loadCache").setArgument((Object)new CacheArgument().setCacheName(CACHE_DATA_STORE_NAME));
        this.executeAction((AbstractRequest)req, res -> true);
        Assert.assertEquals((Object)loadedKeyFromDatastore, (Object)cache.get((Object)1));
        String generatedVal = (String)cache.get((Object)2);
        Assert.assertEquals((long)1L, (long)TestDataStore.postLoadKeys.size());
        Assert.assertEquals((Object)TestDataStore.postLoadKeys.get(2), (Object)generatedVal);
    }

    private CacheConfiguration<Integer, String> getDatastoreCacheConfiguration() {
        CacheConfiguration cacheCfg = new CacheConfiguration(CACHE_DATA_STORE_NAME);
        cacheCfg.setCacheStoreFactory(FactoryBuilder.factoryOf(TestDataStore.class));
        cacheCfg.setReadThrough(true);
        cacheCfg.setWriteThrough(true);
        return cacheCfg;
    }

    @Override
    protected int clusterSize() {
        return 2;
    }

    @Override
    protected <K, V> CacheConfiguration<K, V> cacheConfiguration(String cacheName) {
        CacheConfiguration cfg = super.cacheConfiguration(cacheName);
        cfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(32)).setBackups(1);
        return cfg;
    }

    public static class TestDataStore
    extends CacheStoreAdapter<Integer, String> {
        public static final Map<Integer, String> externalDataProvider = new HashMap<Integer, String>();
        public static final Map<Integer, String> postLoadKeys = new HashMap<Integer, String>();

        public String load(Integer key) throws CacheLoaderException {
            String val = "generated-load-" + ThreadLocalRandom.current().nextInt();
            postLoadKeys.put(key, val);
            return val;
        }

        public void write(Cache.Entry<? extends Integer, ? extends String> entry) throws CacheWriterException {
            throw new UnsupportedOperationException();
        }

        public void delete(Object key) throws CacheWriterException {
            throw new UnsupportedOperationException();
        }

        public void loadCache(IgniteBiInClosure<Integer, String> clo, Object ... args) {
            for (Map.Entry<Integer, String> entry : externalDataProvider.entrySet()) {
                clo.apply((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

