/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.action.controller.TestActionController;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.junit.Assert;
import org.junit.Test;

public class ActionControllerBaseTest
extends AbstractActionControllerTest {
    @Test
    public void shouldSendErrorResponseWithInvalidArgument() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("BaselineActions.updateAutoAdjustAwaitingTime").setArgument((Object)"value");
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assert.assertEquals((long)-32700L, (long)r.getError().getCode());
            return true;
        });
    }

    @Test
    public void shouldSendErrorResponseWithIncorrectAction() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("InvalidAction.updateAutoAdjustEnabled").setArgument((Object)true);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assert.assertEquals((long)-32700L, (long)r.getError().getCode());
            return true;
        });
    }

    @Test
    public void shouldPassActionRequestId() {
        UUID id0 = UUID.randomUUID();
        Request req = new Request().setId(id0).setAction("IgniteTestActionController.actionWithRequestId0");
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            TestActionController.Response actRes = this.result(r, new TypeReference<TestActionController.Response>(){});
            Assert.assertEquals((Object)id0, (Object)actRes.getReqId());
            Assert.assertNull((Object)actRes.getArg());
            return true;
        });
        UUID id1 = UUID.randomUUID();
        req = new Request().setId(id1).setArgument((Object)true).setAction("IgniteTestActionController.actionWithRequestId1");
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            TestActionController.Response actRes = this.result(r, new TypeReference<TestActionController.Response>(){});
            Assert.assertEquals((Object)id1, (Object)actRes.getReqId());
            Assert.assertEquals((Object)true, (Object)actRes.getArg());
            return true;
        });
        UUID id2 = UUID.randomUUID();
        req = new Request().setId(id2).setArgument((Object)false).setAction("IgniteTestActionController.actionWithRequestId2");
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.COMPLETED, (Object)r.getStatus());
            TestActionController.Response actRes = this.result(r, new TypeReference<TestActionController.Response>(){});
            Assert.assertEquals((Object)id2, (Object)actRes.getReqId());
            Assert.assertEquals((Object)false, (Object)actRes.getArg());
            return true;
        });
    }
}

