/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.util.typedef.F;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.TaskResponse;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentObjectMapperFactory;

public abstract class AbstractActionControllerTest
extends AgentCommonAbstractTest {
    protected final ObjectMapper mapper = AgentObjectMapperFactory.jsonMapper();
    protected Set<UUID> allNodeIds = new HashSet<UUID>();
    protected Set<String> allNodeConsistentIds = new HashSet<String>();
    protected Set<UUID> nonCrdNodeIds = new HashSet<UUID>();
    protected Set<String> nonCrdNodeConsistentIds = new HashSet<String>();
    protected IgniteClusterEx cluster;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.startupCluster();
    }

    protected int clusterSize() {
        return 1;
    }

    private void startupCluster() {
        IgniteEx ignite = this.startGrids(this.clusterSize());
        this.changeAgentConfiguration(ignite);
        this.cluster = ignite.cluster();
        this.cluster.state(ClusterState.ACTIVE);
        this.allNodeIds = this.cluster.forServers().nodes().stream().map(ClusterNode::id).collect(Collectors.toSet());
        this.allNodeConsistentIds = this.cluster.forServers().nodes().stream().map(ClusterNode::consistentId).map(String::valueOf).collect(Collectors.toSet());
        this.nonCrdNodeIds = this.cluster.forServers().nodes().stream().map(ClusterNode::id).filter(id -> !id.equals(this.cluster.localNode().id())).collect(Collectors.toSet());
        this.nonCrdNodeConsistentIds = this.cluster.forServers().nodes().stream().map(ClusterNode::consistentId).map(String::valueOf).filter(id -> !id.equals(String.valueOf(this.cluster.localNode().consistentId()))).collect(Collectors.toSet());
        this.bootstrapCluster();
    }

    protected void bootstrapCluster() {
        IgniteCache cache = this.createCache(this.cluster.ignite(), "test-cache");
        cache.put((Object)1, (Object)2);
    }

    protected void executeAction(AbstractRequest req, Function<List<JobResponse>, Boolean> assertFn) {
        this.executeActionAndStopNode(req, 0L, 0, assertFn);
    }

    protected void executeActionAndWaitCompleted(AbstractRequest req) {
        this.executeActionAndStopNode(req, 0L, 0, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return this.isCompleted(r);
        });
    }

    protected void executeAction(Request req, Duration timeout, Function<List<JobResponse>, Boolean> assertFn) {
        this.executeAction(req, null, timeout, assertFn);
    }

    protected void executeAction(Request req, Duration delay, Duration timeout, Function<List<JobResponse>, Boolean> assertFn) {
        this.assertAction(delay, timeout, () -> this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildActionRequestTopic((UUID)this.cluster.id())));
        this.template.convertAndSend((Object)StompDestinationsUtils.buildActionRequestTopic((UUID)this.cluster.id()), (Object)req);
        this.assertAction(delay, timeout, () -> {
            List<JobResponse> res = this.jobResults(req.getId());
            return (Boolean)assertFn.apply(res);
        });
    }

    private void assertAction(Duration delay, Duration timeout, Callable<Boolean> act) {
        ConditionFactory factory = Awaitility.with().pollInterval(500L, TimeUnit.MILLISECONDS);
        if (delay != null) {
            factory = factory.pollDelay(delay);
        }
        factory.await().atMost(timeout).until(act);
    }

    protected List<TaskResponse> taskResults(UUID reqId) {
        return this.inInterceptor.getAllPayloads(StompDestinationsUtils.buildActionTaskResponseDest((UUID)this.cluster.id()), TaskResponse.class).stream().filter(r -> reqId.equals(r.getId())).collect(Collectors.toList());
    }

    protected TaskResponse taskResult(UUID reqId) {
        List<TaskResponse> taskRes = this.taskResults(reqId);
        return (TaskResponse)F.last(taskRes);
    }

    protected List<JobResponse> jobResults(UUID reqId) {
        return this.inInterceptor.getAllPayloads(StompDestinationsUtils.buildActionJobResponseDest((UUID)this.cluster.id()), JobResponse.class).stream().filter(r -> reqId.equals(r.getRequestId())).collect(Collectors.toList());
    }

    protected JobResponse jobResult(UUID reqId) {
        List<JobResponse> jobRes = this.jobResults(reqId);
        if (F.isEmpty(jobRes)) {
            return null;
        }
        return (JobResponse)F.last(jobRes);
    }

    protected void executeActionAndStopNode(AbstractRequest req, long timeout, int gridIdx, Function<List<JobResponse>, Boolean> assertFn) {
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(StompDestinationsUtils.buildActionRequestTopic((UUID)this.cluster.id())));
        this.template.convertAndSend((Object)StompDestinationsUtils.buildActionRequestTopic((UUID)this.cluster.id()), (Object)req);
        if (timeout > 0L) {
            try {
                Thread.sleep(timeout);
                this.stopGrid(gridIdx);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        TestUtils.assertWithPoll(() -> (Boolean)assertFn.apply(this.jobResults(req.getId())));
    }

    protected <T> T result(JobResponse r, TypeReference<T> valTypeRef) {
        try {
            return (T)this.mapper.readValue(this.mapper.writeValueAsString(r.getResult()), valTypeRef);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to deserialize", e);
        }
    }

    protected boolean isCompleted(JobResponse r) {
        return r != null && r.getStatus() == Status.COMPLETED;
    }
}

