/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheInterceptor;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.awaitility.Awaitility;
import org.gridgain.control.agent.utils.SnapshotsUtils;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.persistentstore.SnapshotCommonParams;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.gridgain.grid.security.rolebased.PasswordHashingCacheInterceptor;
import org.gridgain.grid.security.rolebased.UserCredential;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.function.ThrowingRunnable;

public class TestUtils {
    public static void assertWithPoll(long pollInterval, long delay, long timeout, Callable<Boolean> cond) {
        Awaitility.with().pollInterval(pollInterval, TimeUnit.MILLISECONDS).pollDelay(delay, TimeUnit.MILLISECONDS).await().atMost(timeout, TimeUnit.MILLISECONDS).until(cond);
    }

    public static void assertTimesWithPoll(int times, long pollInterval, long delay, Callable<Boolean> cond) {
        AtomicInteger timesCnt = new AtomicInteger();
        Awaitility.with().pollInterval(pollInterval, TimeUnit.MILLISECONDS).pollDelay(delay, TimeUnit.MILLISECONDS).await().until(cond, res -> res != false && timesCnt.getAndIncrement() == times);
    }

    public static void assertWithPoll(Callable<Boolean> cond) {
        TestUtils.assertWithPoll(500L, 1000L, 20000L, cond);
    }

    public static void assertWithPoll(ThrowingRunnable asserts) {
        TestUtils.assertWithPoll(() -> {
            try {
                asserts.run();
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        });
    }

    public static void assertThrows(ThrowingRunnable runnable, Class<? extends Throwable> expErr, String expMsg) {
        Throwable ex = Assert.assertThrows(expErr, (ThrowingRunnable)runnable);
        if (expMsg != null) {
            Assert.assertEquals((Object)expMsg, (Object)ex.getMessage());
        }
    }

    public static void assertThrows(ThrowingRunnable runnable, Class<? extends Throwable> expErr) {
        TestUtils.assertThrows(runnable, expErr, null);
    }

    public static Throwable assertThrowsAnyCause(Callable<?> call, Class<? extends Throwable> cls, @Nullable String msg) {
        assert (call != null);
        assert (cls != null);
        try {
            call.call();
        }
        catch (Throwable e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (cls != t.getClass() || msg != null && (t.getMessage() == null || !t.getMessage().contains(msg))) continue;
                return t;
            }
            throw new AssertionError("Unexpected exception", e);
        }
        throw new AssertionError((Object)"Exception has not been thrown.");
    }

    public static SnapshotFuture<Void> createFullSnapshot(Ignite ignite, Set<String> cacheNames, File path) {
        GridSnapshotEx snapshot = SnapshotsUtils.snapshot((Ignite)ignite);
        return snapshot.createFullSnapshot(cacheNames, path, new SnapshotCommonParams(), new SnapshotCreateParams(), "Test snapshot");
    }

    public static SnapshotFuture<Void> createSnapshot(Ignite ignite, Set<String> cacheNames, File path) {
        GridSnapshotEx snapshot = SnapshotsUtils.snapshot((Ignite)ignite);
        return snapshot.createSnapshot(cacheNames, path, new SnapshotCommonParams(), new SnapshotCreateParams(), "Test snapshot");
    }

    public static File resolveSnapshotDirectory() {
        try {
            return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"custom-snapshot-dir", (boolean)false);
        }
        catch (IgniteCheckedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void corruptSnapshot(long snapshotId, Collection<String> paths, int cacheGrpId) throws IgniteCheckedException {
        for (String snapshotDirectory : paths) {
            File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDirectory, (boolean)false);
            File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, null));
            File[] files = fullSnapDir.listFiles();
            if (files == null) continue;
            Stream.of(files).filter(consistentIdDir -> !consistentIdDir.isFile()).flatMap(consistentIdDir -> Stream.of(consistentIdDir.listFiles())).filter(cacheDir -> !cacheDir.isFile()).filter(cacheDir -> cacheDir.getName().equals(Integer.toString(cacheGrpId))).forEach(cacheDir -> Stream.of(cacheDir.listFiles()).filter(file -> file.isFile() && file.getName().startsWith("part")).filter(TestUtils::corruptSnapshotFile).findFirst());
        }
    }

    public static void runMultipleTimesConcurrently(Runnable job, int parallelism) {
        CountDownLatch latch = new CountDownLatch(1);
        Runnable latchedJob = () -> {
            try {
                latch.await();
                job.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        ForkJoinPool pool = new ForkJoinPool(parallelism);
        List<ForkJoinTask> tasks = IntStream.range(0, parallelism).mapToObj(i -> pool.submit(latchedJob)).collect(Collectors.toList());
        latch.countDown();
        tasks.forEach(ForkJoinTask::join);
        pool.shutdown();
    }

    public static <T> List<T> union(List<T> col1, List<T> col2) {
        ArrayList<T> res = new ArrayList<T>(col1);
        res.addAll(col2);
        return res;
    }

    public static void createRole(IgniteEx ignite, String role, String perm) {
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO SecurityRoles(rolename, permission) VALUES (?, ?)").setArgs(new Object[]{role, perm});
        ignite.context().query().querySqlFields(qry, true);
    }

    public static void createUser(IgniteEx ignite, String login, String pwd, String role) {
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO SecurityUsers (login, password, role) VALUES (?, ?, ?)").setArgs(new Object[]{login, pwd, role});
        ignite.context().query().querySqlFields(qry, true);
    }

    public static <K, V> CacheConfiguration<K, V> nebulaUserCacheConfiguration() {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("login", String.class.getName());
        fields.put("password", String.class.getName());
        fields.put("role", String.class.getName());
        QueryEntity qe = new QueryEntity().setKeyType(String.class.getName()).setValueType(UserCredential.class.getName()).setKeyFieldName("login").setTableName("SecurityUsers").setFields(fields);
        return new CacheConfiguration().setName("ignite-users-cache").setCacheMode(CacheMode.REPLICATED).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 100)).setSqlSchema("PUBLIC").setQueryEntities(Collections.singletonList(qe)).setInterceptor((CacheInterceptor)new PasswordHashingCacheInterceptor());
    }

    public static <K, V> CacheConfiguration<K, V> nebulaRoleCacheConfiguration() {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("roleName", String.class.getName());
        fields.put("permission", String.class.getName());
        QueryEntity qe = new QueryEntity().setKeyType(String.class.getName()).setValueType(String.class.getName()).setKeyFieldName("roleName").setValueFieldName("permission").setTableName("SecurityRoles").setFields(fields);
        return new CacheConfiguration().setName("ignite-roles-cache").setCacheMode(CacheMode.REPLICATED).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 100)).setSqlSchema("PUBLIC").setQueryEntities(Collections.singletonList(qe));
    }

    public static void resetLatch(CountDownLatch latch) {
        while (latch.getCount() > 0L) {
            latch.countDown();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean corruptSnapshotFile(File file) {
        if (file.length() <= 1024L) return false;
        try (FileChannel ch = FileChannel.open(file.toPath(), StandardOpenOption.WRITE, StandardOpenOption.READ);){
            ByteBuffer buf = ByteBuffer.allocate(1024);
            ch.read(buf, 0L);
            buf.putLong(512, buf.getLong(512) ^ 0xFFFFFFFFFFFFFFFFL);
            buf.rewind();
            ch.position(0L);
            ch.write(buf);
            ch.force(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

