/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.metrics;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.util.typedef.F;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.metric.MetricRegistrySchemaItem;
import org.gridgain.control.agent.dto.metric.MetricResponse;
import org.gridgain.control.agent.dto.metric.MetricSchema;
import org.gridgain.control.agent.dto.metric.MetricSchemaItem;
import org.gridgain.control.agent.dto.metric.MetricType;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MetricsProcessorSelfTest
extends AgentCommonAbstractTest {
    @Test
    public void shouldHaveControlCenterAgentAttribute() {
        IgniteEx ignite = this.startGrid();
        Assert.assertTrue((boolean)ignite.context().hasNodeAttribute("gridgain.control.center.agent.present"));
        Assert.assertTrue((boolean)ignite.context().hasNodeAttribute("plugins.gridgain.control.center.agent.present"));
    }

    @Test
    public void shouldSendMetricsOnPull() {
        IgniteEx ignite = this.startGrids(2);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        String dest = StompDestinationsUtils.buildMetricsPullTopic((UUID)cluster.id());
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(dest));
        this.template.convertAndSend((Object)dest, (Object)"pull");
        TestUtils.assertWithPoll(() -> {
            List<List<byte[]>> metrics = this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildMetricsDest(), byte[].class);
            return !F.isEmpty(metrics) && metrics.get(0).size() == 2 && metrics.get(0).stream().allMatch(m -> new String((byte[])m).contains(cluster.tag()));
        });
    }

    @Test
    public void shouldSendMetricsWithDataOnEmptyMetricNamesRequest() {
        IgniteEx ignite = this.startGrids(2);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        String dest = StompDestinationsUtils.buildMetricsPullTopic((UUID)cluster.id());
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(dest));
        this.template.convertAndSend((Object)dest, (Object)"{\"timestamp\": 1, \"templates\": []}");
        TestUtils.assertWithPoll(() -> {
            List<List<byte[]>> metrics = this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildMetricsDest(), byte[].class);
            return !F.isEmpty(metrics) && metrics.get(0).size() == 2 && metrics.get(0).stream().map(MetricResponse::new).allMatch(m -> cluster.tag().equals(m.userTag()) && m.dataSize() != 0 && m.timestamp() == 1L && m.schema().items().size() > 1);
        });
    }

    @Test
    public void shouldSendSchemaAndDataMessagesOnMetricRequestWithMetricNames() {
        IgniteEx ignite = this.startGrids(2);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        String dest = StompDestinationsUtils.buildMetricsPullTopic((UUID)cluster.id());
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(dest));
        this.template.convertAndSend((Object)dest, (Object)"{\"timestamp\": 1, \"templates\": [\"cache.*.CacheEvictions\"]}");
        TestUtils.assertWithPoll(() -> {
            List<List<byte[]>> metrics = this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildMetricsDest(), byte[].class);
            if (F.isEmpty(metrics) || metrics.get(0).size() != 3) {
                return false;
            }
            List responses = metrics.get(0).stream().map(MetricResponse::new).collect(Collectors.toList());
            int schemaMsgCnt = 0;
            int dataMsgCnt = 0;
            for (MetricResponse res : responses) {
                MetricSchema schema = res.schema();
                if (schema == null) {
                    return false;
                }
                if (res.dataSize() == 0 && schema.items().size() > 1) {
                    ++schemaMsgCnt;
                }
                if (res.dataSize() == 0 || schema.items().size() != 1) continue;
                List schemaItems = schema.items();
                List registryItems = schema.registrySchema((short)0).items();
                if (schemaItems.size() != 1 || !((MetricSchemaItem)schemaItems.get(0)).prefix().equals("cache.ignite-sys-cache") || registryItems.size() != 1 || !((MetricRegistrySchemaItem)registryItems.get(0)).name().equals("CacheEvictions") || ((MetricRegistrySchemaItem)registryItems.get(0)).metricType() != MetricType.LONG) continue;
                ++dataMsgCnt;
            }
            return schemaMsgCnt == 1 && dataMsgCnt == 2;
        });
    }

    @Test
    public void shouldNotSendDataResponseIfNoData() {
        IgniteEx ignite = this.startGrids(2);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        String dest = StompDestinationsUtils.buildMetricsPullTopic((UUID)cluster.id());
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(dest));
        this.template.convertAndSend((Object)dest, (Object)"{\"timestamp\": 1, \"templates\": [\"unknown.metrics\"]}");
        TestUtils.assertWithPoll(() -> {
            List<List<byte[]>> metrics = this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildMetricsDest(), byte[].class);
            return !F.isEmpty(metrics) && metrics.get(0).size() == 1 && metrics.get(0).stream().map(MetricResponse::new).allMatch(m -> cluster.tag().equals(m.userTag()) && m.dataSize() == 0 && m.schema().items().size() > 1);
        });
    }

    @Test
    public void shouldRemoveListenerCorrectrly() {
        IgniteEx ignite = this.startGrids(2);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        String dest = StompDestinationsUtils.buildMetricsPullTopic((UUID)cluster.id());
        TestUtils.assertWithPoll(() -> this.inInterceptor.isSubscribedOn(dest));
        this.template.convertAndSend((Object)dest, (Object)"pull");
        TestUtils.assertWithPoll(() -> {
            List<byte[]> metrics = this.inInterceptor.getListPayload(StompDestinationsUtils.buildMetricsDest(), byte[].class);
            if (F.isEmpty(metrics)) {
                return false;
            }
            ((ListAssert)Assertions.assertThat(metrics).hasSize(2)).allMatch(m -> new String((byte[])m).contains(cluster.tag()));
            return true;
        });
        this.attachCluster(cluster, false);
        this.inInterceptor.clearMessages();
        this.attachCluster(cluster);
        this.template.convertAndSend((Object)dest, (Object)"pull");
        TestUtils.assertWithPoll(() -> {
            List<byte[]> metrics = this.inInterceptor.getListPayload(StompDestinationsUtils.buildMetricsDest(), byte[].class);
            if (F.isEmpty(metrics)) {
                return false;
            }
            ((ListAssert)Assertions.assertThat(metrics).hasSize(2)).allMatch(m -> new String((byte[])m).contains(cluster.tag()));
            return true;
        });
    }
}

