/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.action;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.dto.action.TaskResponse;
import org.junit.Assert;
import org.junit.Test;

public class DistributedActionProcessorTest
extends AbstractActionControllerTest {
    @Override
    protected int clusterSize() {
        return 3;
    }

    @Test
    public void shouldExecuteActionOnCoordinatorNode() {
        UUID crdId = this.cluster.localNode().id();
        String consistentId = String.valueOf(this.cluster.localNode().consistentId());
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.nodeIdAction").setNodeIds(Collections.singleton(crdId));
        this.executeAction((AbstractRequest)req, res -> {
            List<TaskResponse> taskResults = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskResults.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> completedTask = taskResults.stream().filter(r -> r.getStatus() == Status.COMPLETED).findFirst();
            if (runningTask.isPresent() && completedTask.isPresent()) {
                return res.size() == completedTask.get().getJobCount();
            }
            return false;
        });
        JobResponse res2 = this.jobResult(req.getId());
        Assert.assertEquals((Object)consistentId, (Object)res2.getNodeConsistentId());
        Assert.assertEquals((Object)crdId, (Object)UUID.fromString((String)res2.getResult()));
    }

    @Test
    public void shouldExecuteActionOnNonCoordinatorNodes() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.nodeIdAction").setNodeIds(this.nonCrdNodeIds);
        this.executeAction((AbstractRequest)req, res -> {
            List<TaskResponse> taskResults = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskResults.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> completedTask = taskResults.stream().filter(r -> r.getStatus() == Status.COMPLETED).findFirst();
            if (runningTask.isPresent() && completedTask.isPresent()) {
                Set results = res.stream().map(r -> UUID.fromString(r.getResult().toString())).collect(Collectors.toSet());
                return res.size() == completedTask.get().getJobCount() && results.equals(this.nonCrdNodeIds);
            }
            return false;
        });
        List<JobResponse> responses = this.jobResults(req.getId());
        boolean responsesHasCorrectConsistentIds = this.nonCrdNodeConsistentIds.containsAll(responses.stream().map(JobResponse::getNodeConsistentId).collect(Collectors.toSet()));
        Assert.assertTrue((boolean)responsesHasCorrectConsistentIds);
    }

    @Test
    public void shouldExecuteActionOnAllNodes() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.nodeIdAction");
        this.executeAction((AbstractRequest)req, res -> {
            List<TaskResponse> taskResults = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskResults.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> completedTask = taskResults.stream().filter(r -> r.getStatus() == Status.COMPLETED).findFirst();
            if (runningTask.isPresent() && completedTask.isPresent()) {
                Set results = res.stream().map(r -> UUID.fromString(r.getResult().toString())).collect(Collectors.toSet());
                return res.size() == completedTask.get().getJobCount() && results.equals(this.allNodeIds);
            }
            return false;
        });
        List<JobResponse> responses = this.jobResults(req.getId());
        boolean responsesHasCorrectConsistentIds = this.allNodeConsistentIds.containsAll(responses.stream().map(JobResponse::getNodeConsistentId).collect(Collectors.toSet()));
        Assert.assertTrue((boolean)responsesHasCorrectConsistentIds);
    }

    @Test
    public void shouldExecuteActionOnAllNodesWithNodeStop() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.nodeIdActionWithSleep").setArgument((Object)5000);
        this.executeActionAndStopNode((AbstractRequest)req, 1000L, 1, res -> {
            List<TaskResponse> taskResults = this.taskResults(req.getId());
            Optional<TaskResponse> runningTask = taskResults.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> failedTask = taskResults.stream().filter(r -> r.getStatus() == Status.FAILED).findFirst();
            if (runningTask.isPresent() && failedTask.isPresent()) {
                long failedJobCnt = res.stream().filter(r -> r.getStatus() == Status.FAILED).count();
                return res.size() == failedTask.get().getJobCount() && failedJobCnt == 1L;
            }
            return false;
        });
    }

    @Test
    public void shouldSendErrorResponseWithInvalidNodeId() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.nodeIdAction").setNodeIds(Collections.singleton(UUID.randomUUID()));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assert.assertEquals((long)-32603L, (long)r.getError().getCode());
            Assert.assertEquals((Object)"The executing node has dropped out from the cluster", (Object)r.getError().getMessage());
            TaskResponse taskRes = this.taskResult(req.getId());
            Assert.assertEquals((Object)Status.FAILED, (Object)taskRes.getStatus());
            return true;
        });
    }

    @Test
    public void shouldSendErrorResponseWithInvalidArgument() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("BaselineActions.updateAutoAdjustAwaitingTime").setArgument((Object)"value");
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assert.assertEquals((long)-32700L, (long)r.getError().getCode());
            TaskResponse taskRes = this.taskResult(req.getId());
            Assert.assertEquals((Object)Status.FAILED, (Object)taskRes.getStatus());
            return true;
        });
    }

    @Test
    public void shouldSendErrorResponseWithIncorrectAction() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("InvalidAction.updateAutoAdjustEnabled").setArgument((Object)true);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assert.assertEquals((long)-32700L, (long)r.getError().getCode());
            TaskResponse taskRes = this.taskResult(req.getId());
            Assert.assertEquals((Object)Status.FAILED, (Object)taskRes.getStatus());
            return true;
        });
        RequestWithoutAction reqWithoutAct = new RequestWithoutAction(UUID.randomUUID());
        this.executeAction(reqWithoutAct, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            if (r == null) {
                return false;
            }
            Assert.assertEquals((Object)Status.FAILED, (Object)r.getStatus());
            Assert.assertEquals((Object)"Missing required parameter: action", (Object)r.getError().getMessage());
            Assert.assertEquals((long)-32700L, (long)r.getError().getCode());
            TaskResponse taskRes = this.taskResult(req.getId());
            Assert.assertEquals((Object)Status.FAILED, (Object)taskRes.getStatus());
            return true;
        });
        RequestWithoutCredentials reqWithoutCreds = new RequestWithoutCredentials().setId(UUID.randomUUID()).setAction("IgniteTestActionController.nodeIdAction").setNodeIds(this.nonCrdNodeIds);
        this.executeAction(reqWithoutCreds, res -> {
            List<TaskResponse> taskResults = this.taskResults(reqWithoutCreds.getId());
            Optional<TaskResponse> runningTask = taskResults.stream().filter(r -> r.getStatus() == Status.RUNNING).findFirst();
            Optional<TaskResponse> completedTask = taskResults.stream().filter(r -> r.getStatus() == Status.COMPLETED).findFirst();
            if (runningTask.isPresent() && completedTask.isPresent()) {
                return res.size() == completedTask.get().getJobCount();
            }
            return false;
        });
    }

    private static class RequestWithoutCredentials
    extends AbstractRequest {
        private Object arg;
        private String act;
        private UUID sesId;
        private Set<UUID> nids;

        private RequestWithoutCredentials() {
        }

        public RequestWithoutCredentials setId(UUID id) {
            this.id = id;
            return this;
        }

        public String getAction() {
            return this.act;
        }

        public RequestWithoutCredentials setAction(String act) {
            this.act = act;
            return this;
        }

        public Object getArgument() {
            return this.arg;
        }

        public RequestWithoutCredentials setArgument(Object arg) {
            this.arg = arg;
            return this;
        }

        public UUID getSessionId() {
            return this.sesId;
        }

        public RequestWithoutCredentials setSessionId(UUID sesId) {
            this.sesId = sesId;
            return this;
        }

        public Set<UUID> getNodeIds() {
            return this.nids;
        }

        public RequestWithoutCredentials setNodeIds(Set<UUID> nids) {
            this.nids = nids;
            return this;
        }
    }

    private static class RequestWithoutAction
    extends AbstractRequest {
        public RequestWithoutAction(UUID id) {
            this.id = id;
        }
    }
}

