/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.ClusterMetricsSnapshot;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.DetachedClusterNode;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.spi.discovery.DiscoveryMetricsProvider;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.topology.Node;
import org.gridgain.control.agent.dto.topology.TopologySnapshot;
import org.gridgain.control.agent.processor.TopologyProcessor;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.grid.internal.processors.dr.DrSenderAttributes;
import org.junit.Assert;
import org.junit.Test;

public class TopologyProcessorTest
extends AgentCommonAbstractTest {
    @Test
    public void shouldSendChangedClusterTopology() {
        IgniteEx ignite = this.startGrid(0);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        this.startGrid(1);
        TestUtils.assertWithPoll(() -> {
            TopologySnapshot top = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterTopologyDest((UUID)cluster.id()), TopologySnapshot.class);
            Assert.assertEquals((long)2L, (long)top.getNodes().size());
        });
    }

    @Test
    public void shouldSendChangedTopologyWhenBaselineWasChanged() {
        IgniteEx ignite_1 = this.startGrid(0);
        this.changeAgentConfiguration(ignite_1);
        ignite_1.cluster().baselineAutoAdjustEnabled(false);
        IgniteClusterEx cluster = ignite_1.cluster();
        this.attachCluster(cluster);
        cluster.state(ClusterState.ACTIVE);
        TestUtils.assertWithPoll(() -> {
            TopologySnapshot top = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterTopologyDest((UUID)cluster.id()), TopologySnapshot.class);
            Assert.assertEquals((long)1L, (long)top.getNodes().stream().filter(Node::isBaselineNode).count());
        });
        this.startGrid(1);
        Collection nodes = ignite_1.cluster().forServers().nodes();
        ignite_1.cluster().setBaselineTopology(nodes);
        TestUtils.assertWithPoll(() -> {
            TopologySnapshot top = this.inInterceptor.getPayload(StompDestinationsUtils.buildClusterTopologyDest((UUID)cluster.id()), TopologySnapshot.class);
            Assert.assertEquals((long)2L, (long)top.getNodes().stream().filter(Node::isBaselineNode).count());
        });
    }

    @Test
    public void topology() {
        UUID clusterNodeId_1 = UUID.fromString("b-b-b-b-b");
        String consistentNodeId_1 = UUID.fromString("c-c-c-c-c").toString();
        TcpDiscoveryNode clusterNode_1 = new TcpDiscoveryNode(clusterNodeId_1, Collections.singletonList("127.0.0.1"), Collections.singletonList("Host1"), 8080, (DiscoveryMetricsProvider)new TestDiscoveryMetricsProvider(), IgniteProductVersion.fromString((String)"1.2.3-0-DEV"), (Serializable)((Object)consistentNodeId_1));
        clusterNode_1.order(1L);
        clusterNode_1.setAttributes(Collections.emptyMap());
        UUID clusterNodeId_2 = UUID.fromString("e-e-e-e-e");
        String consistentNodeId_2 = UUID.fromString("d-d-d-d-d").toString();
        TcpDiscoveryNode clusterNode_2 = new TcpDiscoveryNode(clusterNodeId_2, Collections.singletonList("127.0.0.1"), Collections.singletonList("Host2"), 8080, (DiscoveryMetricsProvider)new TestDiscoveryMetricsProvider(), IgniteProductVersion.fromString((String)"1.2.3-0-DEV"), (Serializable)((Object)consistentNodeId_2));
        clusterNode_2.order(2L);
        clusterNode_2.setAttributes(Collections.emptyMap());
        DetachedClusterNode onlineBaselineNode = new DetachedClusterNode((Object)consistentNodeId_1, Collections.emptyMap());
        String consistentNodeIdOffline = UUID.fromString("a-a-a-a-a").toString();
        DetachedClusterNode offlineBaselineNode = new DetachedClusterNode((Object)consistentNodeIdOffline, Collections.emptyMap());
        UUID crdId = UUID.fromString("c-c-c-c-c");
        TopologySnapshot top = TopologyProcessor.buildClusterTopology((long)1L, (Object)crdId, Arrays.asList(clusterNode_1, clusterNode_2), Arrays.asList(onlineBaselineNode, offlineBaselineNode), (boolean)false);
        Assert.assertEquals((long)1L, (long)top.getTopologyVersion());
        Assert.assertEquals((Object)crdId.toString(), (Object)top.getCoordinatorConsistentId());
        Assert.assertEquals((long)3L, (long)top.getNodes().size());
        for (Node node : top.getNodes()) {
            if (consistentNodeId_1.equals(node.getConsistentId())) {
                Assert.assertTrue((boolean)node.isOnline());
                Assert.assertTrue((boolean)node.isBaselineNode());
                Assert.assertEquals((long)1L, (long)node.getOrder());
                Assert.assertFalse((boolean)node.isClient());
                Assert.assertEquals((Object)clusterNodeId_1, (Object)node.getNodeId());
                Assert.assertEquals((Object)"Host1", node.getHostNames().iterator().next());
                Assert.assertFalse((boolean)node.isDrReceiverHubNode());
                Assert.assertFalse((boolean)node.isDrSenderHubNode());
                Assert.assertTrue((boolean)node.getDrSenderGroups().isEmpty());
                Assert.assertNull((Object)node.getDrReceiverInboundPort());
            }
            if (consistentNodeIdOffline.equals(node.getConsistentId())) {
                Assert.assertFalse((boolean)node.isOnline());
                Assert.assertEquals((long)-1L, (long)node.getOrder());
                Assert.assertTrue((boolean)node.isBaselineNode());
            }
            if (!consistentNodeId_2.equals(node.getConsistentId())) continue;
            Assert.assertTrue((boolean)node.isOnline());
            Assert.assertFalse((boolean)node.isBaselineNode());
            Assert.assertEquals((long)2L, (long)node.getOrder());
            Assert.assertFalse((boolean)node.isClient());
            Assert.assertEquals((Object)clusterNodeId_2, (Object)node.getNodeId());
            Assert.assertEquals((Object)"Host2", node.getHostNames().iterator().next());
            Assert.assertFalse((boolean)node.isDrReceiverHubNode());
            Assert.assertFalse((boolean)node.isDrSenderHubNode());
            Assert.assertTrue((boolean)node.getDrSenderGroups().isEmpty());
            Assert.assertNull((Object)node.getDrReceiverInboundPort());
        }
    }

    @Test
    public void topologyWithEmptyBaseline() {
        UUID clusterNodeId_1 = UUID.fromString("b-b-b-b-b");
        String consistentNodeId_1 = UUID.fromString("c-c-c-c-c").toString();
        TcpDiscoveryNode clusterNode_1 = new TcpDiscoveryNode(clusterNodeId_1, Collections.singletonList("127.0.0.1"), Collections.emptyList(), 8080, (DiscoveryMetricsProvider)new TestDiscoveryMetricsProvider(), IgniteProductVersion.fromString((String)"1.2.3-0-DEV"), (Serializable)((Object)consistentNodeId_1));
        clusterNode_1.setAttributes(Collections.emptyMap());
        clusterNode_1.order(1L);
        UUID crdId = UUID.fromString("c-c-c-c-c");
        TopologySnapshot top = TopologyProcessor.buildClusterTopology((long)1L, (Object)crdId, Collections.singletonList(clusterNode_1), null, (boolean)false);
        Assert.assertEquals((long)1L, (long)top.getTopologyVersion());
        Assert.assertEquals((Object)crdId.toString(), (Object)top.getCoordinatorConsistentId());
        Assert.assertEquals((long)1L, (long)top.getNodes().size());
        for (Node node : top.getNodes()) {
            if (!consistentNodeId_1.equals(node.getConsistentId())) continue;
            Assert.assertTrue((boolean)node.isOnline());
            Assert.assertFalse((boolean)node.isBaselineNode());
            Assert.assertEquals((long)1L, (long)node.getOrder());
            Assert.assertFalse((boolean)node.isClient());
            Assert.assertEquals((Object)clusterNodeId_1, (Object)node.getNodeId());
        }
    }

    @Test
    public void shouldExportAgentAttributes() {
        TcpDiscoveryNode clusterNode_1 = new TcpDiscoveryNode(UUID.randomUUID(), Collections.singletonList("127.0.0.1"), Collections.emptyList(), 8080, (DiscoveryMetricsProvider)new TestDiscoveryMetricsProvider(), IgniteProductVersion.fromString((String)"1.2.3-0-DEV"), (Serializable)((Object)UUID.randomUUID().toString()));
        byte[] igniteFeatures = new byte[]{1, 2, 3};
        byte[] agentFeatures = new byte[]{1, 2};
        clusterNode_1.setAttributes(U.map((Object)"plugins.gridgain.control.center.agent.present", (Object)true, (Object)"plugins.gridgain.control.center.agent.features", (Object)agentFeatures, (Object)"org.apache.ignite.features", (Object)igniteFeatures));
        TopologySnapshot top = TopologyProcessor.buildClusterTopology((long)1L, (Object)UUID.randomUUID(), Collections.singletonList(clusterNode_1), null, (boolean)false);
        Node node = (Node)F.first((Iterable)top.getNodes());
        Assert.assertEquals((Object)true, node.getAttributes().get("plugins.gridgain.control.center.agent.present"));
        Assert.assertArrayEquals((byte[])agentFeatures, (byte[])((byte[])node.getAttributes().get("plugins.gridgain.control.center.agent.features")));
        Assert.assertArrayEquals((byte[])igniteFeatures, (byte[])((byte[])node.getAttributes().get("org.apache.ignite.features")));
    }

    @Test
    public void shouldExportNodeAttributes() {
        TcpDiscoveryNode clusterNode_1 = new TcpDiscoveryNode(UUID.randomUUID(), Collections.singletonList("127.0.0.1"), Collections.emptyList(), 8080, (DiscoveryMetricsProvider)new TestDiscoveryMetricsProvider(), IgniteProductVersion.fromString((String)"1.2.3-0-DEV"), (Serializable)((Object)UUID.randomUUID().toString()));
        Map attrs = U.map((Object)"plugins.gridgain.control.center.agent.present", (Object)true);
        attrs.put("org.apache.ignite.ignite.name", "name");
        attrs.put("org.apache.ignite.build.ver", "version");
        attrs.put("org.apache.ignite.ips", Collections.singletonList("IP"));
        attrs.put("org.apache.ignite.jvm.pid", "pid");
        attrs.put("org.apache.ignite.macs", Collections.singletonList("MAC"));
        clusterNode_1.setAttributes(attrs);
        TopologySnapshot top = TopologyProcessor.buildClusterTopology((long)1L, (Object)UUID.randomUUID(), Collections.singletonList(clusterNode_1), null, (boolean)false);
        Node node = (Node)F.first((Iterable)top.getNodes());
        attrs = node.getAttributes();
        Assert.assertEquals((Object)true, attrs.get("plugins.gridgain.control.center.agent.present"));
        Assert.assertFalse((boolean)F.isEmpty((String)((String)attrs.get("org.apache.ignite.ignite.name"))));
        Assert.assertFalse((boolean)F.isEmpty((String)((String)attrs.get("org.apache.ignite.build.ver"))));
        Assert.assertFalse((boolean)F.isEmpty((Collection)((Collection)attrs.get("org.apache.ignite.ips"))));
        Assert.assertFalse((boolean)F.isEmpty((String)((String)attrs.get("org.apache.ignite.jvm.pid"))));
        Assert.assertFalse((boolean)F.isEmpty((Collection)((Collection)attrs.get("org.apache.ignite.macs"))));
    }

    @Test
    public void shouldCreateTopologyWithDr() {
        UUID sndNodeId = UUID.fromString("b-b-b-b-b");
        String sndNodeConsistentId = UUID.fromString("c-c-c-c-c").toString();
        TcpDiscoveryNode sndNode = new TcpDiscoveryNode(sndNodeId, Collections.singletonList("127.0.0.1"), Collections.singletonList("Host1"), 8080, (DiscoveryMetricsProvider)new TestDiscoveryMetricsProvider(), IgniteProductVersion.fromString((String)"1.2.3-0-DEV"), (Serializable)((Object)sndNodeConsistentId));
        sndNode.order(1L);
        Map sndAttrs = U.map((Object)"plugins.gg.replication.ist.snd.hub", (Object)new DrSenderAttributes());
        sndAttrs.put("plugins.gg.replication.ist.snd.groups", new String[]{"group1", "group2"});
        sndNode.setAttributes(sndAttrs);
        UUID rcvNodeId = UUID.fromString("e-e-e-e-e");
        String rcvNodeConsistentId = UUID.fromString("d-d-d-d-d").toString();
        TcpDiscoveryNode rcvNode = new TcpDiscoveryNode(rcvNodeId, Collections.singletonList("127.0.0.1"), Collections.singletonList("Host2"), 8080, (DiscoveryMetricsProvider)new TestDiscoveryMetricsProvider(), IgniteProductVersion.fromString((String)"1.2.3-0-DEV"), (Serializable)((Object)rcvNodeConsistentId));
        rcvNode.order(2L);
        Map rcvAttrs = U.map((Object)"plugins.gg.replication.rcv.hub", (Object)true);
        rcvAttrs.put("plugins.gg.replication.rcv.hub.inbound.port", 2323);
        rcvNode.setAttributes(rcvAttrs);
        TopologySnapshot top = TopologyProcessor.buildClusterTopology((long)1L, (Object)UUID.randomUUID(), Arrays.asList(sndNode, rcvNode), null, (boolean)true);
        for (Node node : top.getNodes()) {
            if (sndNodeConsistentId.equals(node.getConsistentId())) {
                Assert.assertTrue((boolean)node.isDrSenderHubNode());
                Assert.assertFalse((boolean)node.getDrSenderGroups().isEmpty());
                Assert.assertEquals(Arrays.asList("group1", "group2"), (Object)node.getDrSenderGroups());
                Assert.assertFalse((boolean)node.isDrReceiverHubNode());
                Assert.assertNull((Object)node.getDrReceiverInboundPort());
            }
            if (!rcvNodeConsistentId.equals(node.getConsistentId())) continue;
            Assert.assertTrue((boolean)node.isDrReceiverHubNode());
            Assert.assertEquals((long)2323L, (long)node.getDrReceiverInboundPort().intValue());
            Assert.assertFalse((boolean)node.isDrSenderHubNode());
            Assert.assertTrue((boolean)node.getDrSenderGroups().isEmpty());
        }
    }

    public static class TestDiscoveryMetricsProvider
    implements DiscoveryMetricsProvider {
        public ClusterMetrics metrics() {
            return new ClusterMetricsSnapshot();
        }

        public Map<Integer, CacheMetrics> cacheMetrics() {
            return null;
        }
    }
}

