/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor;

import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.gridgain.control.agent.configuration.DistributedMetricExporterConfiguration;
import org.gridgain.control.agent.processor.MetricRegistryProcessor;
import org.gridgain.control.agent.test.MetricTreeFixture;
import org.gridgain.control.agent.test.TestGridKernalContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

public class MetricRegistryProcessorTest {
    private final Clock clock = (Clock)Mockito.mock(Clock.class);
    private final GridMetricManager metricMgr = (GridMetricManager)Mockito.mock(GridMetricManager.class);
    private final DistributedMetricExporterConfiguration cfg = (DistributedMetricExporterConfiguration)Mockito.mock(DistributedMetricExporterConfiguration.class);
    private final Map<String, ReadOnlyMetricRegistry> registry = MetricTreeFixture.defaultReadOnlyRegistryTestData();
    private volatile MetricRegistryProcessor metricRegistryProcessor;

    @Before
    public void setUp() throws IgniteCheckedException {
        Mockito.when((Object)this.clock.millis()).thenAnswer(ans -> System.currentTimeMillis());
        Mockito.when((Object)this.metricMgr.registries()).thenReturn(this.registry);
        Mockito.when((Object)this.cfg.getMetricCacheTTL()).thenReturn((Object)0);
        this.metricRegistryProcessor = new MetricRegistryProcessor((GridKernalContext)new TestGridKernalContext(), this.metricMgr, this.clock, this.cfg);
    }

    @After
    public void tearDown() {
        Mockito.reset((Object[])new Object[]{this.metricMgr, this.clock, this.cfg});
        this.registry.clear();
    }

    @Test
    public void shouldNotSchemaUpdateWithoutFirstLoading() {
        Assertions.assertFalse((boolean)this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated());
    }

    @Test
    public void shouldSchemaUpdateOnFirstRequest() {
        this.metricRegistryProcessor.loadMetricsByTemplate(MetricTreeFixture.allTemplateByEmptyCollection());
        Assertions.assertTrue((boolean)this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated());
    }

    @Test
    public void shouldRecreateTreeAfterTTL() {
        this.metricRegistryProcessor.loadMetricsByTemplate(MetricTreeFixture.allTemplateByEmptyCollection());
        this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated();
        Mockito.when((Object)this.metricMgr.registries()).thenReturn(new HashMap());
        Mockito.when((Object)this.clock.millis()).thenAnswer(ans -> System.currentTimeMillis() + 0L);
        this.metricRegistryProcessor.loadMetricsByTemplate(MetricTreeFixture.allTemplateByEmptyCollection());
        Assertions.assertTrue((boolean)this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated());
    }

    @Test
    public void shouldRecreateTree() {
        this.metricRegistryProcessor.loadMetricsByTemplate(MetricTreeFixture.allTemplateByEmptyCollection());
        this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated();
        this.metricRegistryProcessor.resetMetricRegistries(this.clock.millis());
        Assertions.assertTrue((boolean)this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated());
    }

    @Test
    public void shouldSendSchemaMessageWhenGetNewMetric() {
        this.metricRegistryProcessor.loadMetricsByTemplate(MetricTreeFixture.allTemplateByEmptyCollection());
        this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated();
        Map<String, ReadOnlyMetricRegistry> updatedReg = MetricTreeFixture.defaultReadOnlyRegistryTestData();
        MetricRegistry registry = MetricTreeFixture.generateMetricRegistry(0);
        updatedReg.put(registry.name(), (ReadOnlyMetricRegistry)registry);
        Mockito.when((Object)this.metricMgr.registries()).thenReturn(updatedReg);
        this.metricRegistryProcessor.loadMetricsByTemplate(MetricTreeFixture.allTemplateByEmptyCollection());
        Assertions.assertTrue((boolean)this.metricRegistryProcessor.checkSchemaUpdateAndMarkAsUpdated());
    }
}

