/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.plugin.PluginConfiguration;
import org.assertj.core.util.Sets;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.action.controller.AbstractActionControllerTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.SnapshotScheduleCreateArgument;
import org.gridgain.control.agent.dto.action.SnapshotScheduleModifyArgument;
import org.gridgain.control.agent.dto.snapshot.GridGainSnapshotScheduleInfo;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.SnapshotsUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotScheduleActionsControllerTest
extends AbstractActionControllerTest {
    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) {
        return super.getConfiguration(igniteInstanceName).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())});
    }

    @Test
    public void shouldGetListOfSnapshots() {
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        SnapshotScheduleProcessor snap = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        snap.start(new SnapshotScheduleV2("1", "test-schedule", SnapshotOperationType.CREATE, "* * * * *", null, cacheNames, 1L, "/destination", true, null, new SnapshotCreateParameters(CompressionOption.SNAPPY, 2), null, -1, -1, null, 0));
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotScheduleActions.reloadList");
        this.executeAction((AbstractRequest)req, res -> true);
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            if (scheduleInfos.size() != 1) {
                return false;
            }
            GridGainSnapshotScheduleInfo info = scheduleInfos.get(0);
            Assert.assertEquals((Object)"1", (Object)info.getId());
            Assert.assertEquals((Object)"test-schedule", (Object)info.getName());
            Assert.assertEquals(Collections.singleton("test-cache"), (Object)info.getCacheNames());
            return true;
        });
    }

    @Test
    public void shouldCreateNewCreateSchedule() {
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        this.createSchedule(new SnapshotScheduleCreateArgument().setId(null).setName("create-schedule").setType(SnapshotOperationType.CREATE.name()).setCacheNames(cacheNames).setFrequency("0 * * * *").setExecAfter(null).setTtl(Long.valueOf(2L)).setForLatest(null).setForOldest(null).setDestination("/destination").setCompressionOption(CompressionOption.ZSTD.name()).setCompressionLevel(Integer.valueOf(5)));
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            if (scheduleInfos.size() != 1) {
                return false;
            }
            GridGainSnapshotScheduleInfo info = scheduleInfos.get(0);
            Assert.assertNotNull((Object)info.getId());
            Assert.assertEquals((Object)"create-schedule", (Object)info.getName());
            Assert.assertEquals(Collections.singleton("test-cache"), (Object)info.getCacheNames());
            Assert.assertTrue((boolean)info.isEnabled());
            Assert.assertEquals((Object)"CREATE", (Object)info.getType());
            Assert.assertEquals((Object)"0 * * * *", (Object)info.getFrequency());
            Assert.assertNull((Object)info.getIncrementalFrequency());
            Assert.assertNull((Object)info.getExecAfter());
            Assert.assertNull((Object)info.getTtl());
            Assert.assertNull((Object)info.getForLatest());
            Assert.assertNull((Object)info.getForOldest());
            Assert.assertEquals((Object)"/destination", (Object)info.getDestination());
            Assert.assertEquals((Object)CompressionOption.ZSTD.name(), (Object)info.getCompressionOption());
            Assert.assertEquals((long)5L, (long)info.getCompressionLevel().intValue());
            return true;
        });
    }

    @Test
    public void shouldCreateNewDeleteSchedule() {
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        this.createSchedule(new SnapshotScheduleCreateArgument().setId(null).setName("delete-schedule").setType(SnapshotOperationType.DELETE.name()).setCacheNames(cacheNames).setFrequency("0 * * * *").setExecAfter(null).setTtl(null).setForLatest(Integer.valueOf(1)).setForOldest(null).setDestination("/destination").setCompressionOption(null).setCompressionLevel(null).setKeepCount(Integer.valueOf(3)));
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            if (scheduleInfos.size() != 1) {
                return false;
            }
            GridGainSnapshotScheduleInfo info = scheduleInfos.get(0);
            Assert.assertNotNull((Object)info.getId());
            Assert.assertEquals((Object)"delete-schedule", (Object)info.getName());
            Assert.assertEquals((Object)"DELETE", (Object)info.getType());
            Assert.assertEquals((Object)"0 * * * *", (Object)info.getFrequency());
            Assert.assertEquals((Object)"0 * * * *", (Object)info.getFrequency());
            Assert.assertNull((Object)info.getExecAfter());
            Assert.assertEquals((long)1L, (long)info.getForLatest().intValue());
            Assert.assertNull((Object)info.getForOldest());
            Assert.assertEquals((Object)"/destination", (Object)info.getDestination());
            Assert.assertEquals((Object)CompressionOption.NONE.name(), (Object)info.getCompressionOption());
            Assert.assertNull((Object)info.getCompressionLevel());
            Assert.assertEquals((long)3L, (long)info.getKeepCount().intValue());
            return true;
        });
    }

    @Test
    public void shouldCreateNewCheckSchedule() {
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        this.createSchedule(new SnapshotScheduleCreateArgument().setId(null).setName("check-schedule").setType(SnapshotOperationType.CHECK.name()).setCacheNames(cacheNames).setFrequency("0 * * * *").setExecAfter(null).setTtl(null).setForLatest(null).setForOldest(Integer.valueOf(1)).setDestination("/destination").setCompressionOption(null).setCompressionLevel(null));
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            if (scheduleInfos.size() != 1) {
                return false;
            }
            GridGainSnapshotScheduleInfo info = scheduleInfos.get(0);
            Assert.assertNotNull((Object)info.getId());
            Assert.assertEquals((Object)"check-schedule", (Object)info.getName());
            Assert.assertEquals((Object)"CHECK", (Object)info.getType());
            Assert.assertEquals((Object)"0 * * * *", (Object)info.getFrequency());
            Assert.assertNull((Object)info.getExecAfter());
            Assert.assertNull((Object)info.getForLatest());
            Assert.assertEquals((long)1L, (long)info.getForOldest().intValue());
            Assert.assertEquals((Object)"/destination", (Object)info.getDestination());
            Assert.assertEquals((Object)CompressionOption.NONE.name(), (Object)info.getCompressionOption());
            Assert.assertNull((Object)info.getCompressionLevel());
            return true;
        });
    }

    @Test
    public void shouldCreateNewMoveSchedule() {
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        SnapshotScheduleCreateArgument createArgument = new SnapshotScheduleCreateArgument().setId(null).setName("parent-schedule").setType(SnapshotOperationType.CREATE.name()).setCacheNames(cacheNames).setFrequency("0 * * * *").setExecAfter(null).setTtl(Long.valueOf(2L)).setForLatest(null).setForOldest(null).setDestination("/destination").setCompressionOption(CompressionOption.ZSTD.name()).setCompressionLevel(Integer.valueOf(5));
        Request createReq = new Request().setId(UUID.randomUUID()).setAction("SnapshotScheduleActions.create").setArgument((Object)createArgument);
        this.executeAction((AbstractRequest)createReq, res -> true);
        this.createSchedule(new SnapshotScheduleCreateArgument().setId(null).setName("move-schedule").setType(SnapshotOperationType.MOVE.name()).setCacheNames(cacheNames).setFrequency(null).setExecAfter("parent-schedule").setTtl(null).setForLatest(null).setForOldest(null).setDestination("/destination").setCompressionOption(null).setCompressionLevel(null));
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            if (scheduleInfos.size() != 2) {
                return false;
            }
            GridGainSnapshotScheduleInfo info = scheduleInfos.stream().filter(i -> "move-schedule".equals(i.getName())).findFirst().get();
            Assert.assertNotNull((Object)info.getId());
            Assert.assertEquals((Object)"MOVE", (Object)info.getType());
            Assert.assertNull((Object)info.getFrequency());
            Assert.assertEquals((Object)"parent-schedule", (Object)info.getExecAfter());
            Assert.assertNull((Object)info.getForLatest());
            Assert.assertNull((Object)info.getForOldest());
            Assert.assertEquals((Object)"/destination", (Object)info.getDestination());
            Assert.assertEquals((Object)CompressionOption.NONE.name(), (Object)info.getCompressionOption());
            Assert.assertNull((Object)info.getCompressionLevel());
            return true;
        });
    }

    @Test
    public void shouldUpdateExistingCreateSchedule() {
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        ignite.getOrCreateCache("test-cache-2");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        String id = UUID.randomUUID().toString();
        this.createSchedule(new SnapshotScheduleCreateArgument().setId(id).setName("create-schedule").setType(SnapshotOperationType.CREATE.name()).setCacheNames(cacheNames).setFrequency("0 * * * *").setExecAfter(null).setTtl(Long.valueOf(2L)).setForLatest(null).setForOldest(null).setDestination("/destination").setCompressionOption(CompressionOption.ZSTD.name()).setCompressionLevel(Integer.valueOf(5)));
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            if (scheduleInfos.size() != 1) {
                return false;
            }
            GridGainSnapshotScheduleInfo info = scheduleInfos.get(0);
            Assert.assertNotNull((Object)info.getId());
            Assert.assertEquals((Object)"create-schedule", (Object)info.getName());
            Assert.assertEquals(Collections.singleton("test-cache"), (Object)info.getCacheNames());
            return true;
        });
        this.createSchedule(new SnapshotScheduleCreateArgument().setId(id).setName("create-schedule").setType(SnapshotOperationType.CREATE.name()).setCacheNames(Sets.set((Object[])new String[]{"test-cache", "test-cache-2"})).setFrequency("0 * * * *").setExecAfter(null).setTtl(Long.valueOf(2L)).setForLatest(null).setForOldest(null).setDestination("/destination").setCompressionOption(CompressionOption.ZSTD.name()).setCompressionLevel(Integer.valueOf(5)));
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            if (scheduleInfos.size() != 1) {
                return false;
            }
            GridGainSnapshotScheduleInfo info = scheduleInfos.get(0);
            Assert.assertNotNull((Object)info.getId());
            Assert.assertEquals((Object)"create-schedule", (Object)info.getName());
            Assert.assertEquals((Object)Sets.set((Object[])new String[]{"test-cache", "test-cache-2"}), (Object)info.getCacheNames());
            return true;
        });
    }

    @Test
    public void shouldDeleteSchedule() {
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        this.createSchedule(new SnapshotScheduleCreateArgument().setId(null).setName("create-schedule").setType(SnapshotOperationType.CREATE.name()).setCacheNames(cacheNames).setFrequency("0 * * * *").setExecAfter(null).setTtl(Long.valueOf(2L)).setForLatest(null).setForOldest(null).setDestination("/destination").setCompressionOption(CompressionOption.ZSTD.name()).setCompressionLevel(Integer.valueOf(5)));
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            if (scheduleInfos.size() != 1) {
                return false;
            }
            GridGainSnapshotScheduleInfo info = scheduleInfos.get(0);
            Assert.assertEquals((Object)"create-schedule", (Object)info.getName());
            return true;
        });
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotScheduleActions.delete").setArgument((Object)new SnapshotScheduleModifyArgument().setName("create-schedule"));
        this.executeAction((AbstractRequest)req, res -> true);
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            return scheduleInfos.size() == 0;
        });
    }

    @Test
    public void shouldEnableAndDisableSchedule() {
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        this.createSchedule(new SnapshotScheduleCreateArgument().setId(null).setName("create-schedule").setType(SnapshotOperationType.CREATE.name()).setCacheNames(cacheNames).setFrequency("0 * * * *").setExecAfter(null).setTtl(Long.valueOf(2L)).setForLatest(null).setForOldest(null).setDestination("/destination").setCompressionOption(CompressionOption.ZSTD.name()).setCompressionLevel(Integer.valueOf(5)));
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            if (scheduleInfos.size() != 1) {
                return false;
            }
            GridGainSnapshotScheduleInfo info = scheduleInfos.get(0);
            Assert.assertTrue((boolean)info.isEnabled());
            return true;
        });
        Request disableReq = new Request().setId(UUID.randomUUID()).setAction("SnapshotScheduleActions.disable").setArgument((Object)new SnapshotScheduleModifyArgument().setName("create-schedule"));
        this.executeAction((AbstractRequest)disableReq, res -> true);
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            return !scheduleInfos.get(0).isEnabled();
        });
        Request enableReq = new Request().setId(UUID.randomUUID()).setAction("SnapshotScheduleActions.enable").setArgument((Object)new SnapshotScheduleModifyArgument().setName("create-schedule"));
        this.executeAction((AbstractRequest)enableReq, res -> true);
        TestUtils.assertWithPoll(() -> {
            List<GridGainSnapshotScheduleInfo> scheduleInfos = this.inInterceptor.getListPayload(SnapshotsUtils.buildSnapshotScheduleDest((UUID)this.cluster.id()), GridGainSnapshotScheduleInfo.class);
            return scheduleInfos.get(0).isEnabled();
        });
    }

    private void createSchedule(SnapshotScheduleCreateArgument arg) {
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotScheduleActions.create").setArgument((Object)arg);
        this.executeAction((AbstractRequest)req, res -> true);
    }
}

