/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.assertj.core.util.Lists;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithGridGainSecurityTest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.SnapshotArgument;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class SnapshotActionsControllerWithPitrWithGridGainSecurityTest
extends AbstractActionControllerWithGridGainSecurityTest {
    private static final String ADMIN_VIEW_CACHE_ACCOUNT = "adminViewCache";

    @Override
    protected Map<SecurityCredentials, String> prepareCustomCredentials() {
        HashMap<SecurityCredentials, String> creds = new HashMap<SecurityCredentials, String>(1);
        creds.put(new SecurityCredentials(ADMIN_VIEW_CACHE_ACCOUNT, "123456"), "{     defaultAllow: false,    {        system:[ADMIN_VIEW, ADMIN_CACHE]    }}");
        return creds;
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.deleteDirectory("custom-snapshot-dir");
        this.deleteDirectory("snapshot");
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        GridGainConfiguration ggCfg = (GridGainConfiguration)cfg.getPluginConfigurations()[0];
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration().setPointInTimeRecoveryEnabled(true));
        return cfg;
    }

    @Test
    public void shouldPerformRecoveryToWithAdminViewCacheAccount() throws InterruptedException {
        this.checkSecureRecoveryTo(ADMIN_VIEW_CACHE_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailRecoveryToWithNoAccessAccount() throws InterruptedException {
        this.checkSecureRecoveryTo("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    private void checkSecureRecoveryTo(String acc, String pwd, Predicate<JobResponse> resChecker) throws InterruptedException {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        SnapshotFuture<Void> fut = TestUtils.createFullSnapshot(this.cluster.ignite(), null, null);
        fut.get(20L, TimeUnit.SECONDS);
        long time = System.currentTimeMillis();
        Thread.sleep(50L);
        IgniteCache cache = this.cluster.ignite().cache("test-cache");
        cache.put((Object)1, (Object)3);
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotActions.recoveryTo").setSessionId(sesId).setArgument((Object)new SnapshotArgument().setTime(time).setPaths((List)Lists.newArrayList((Object[])new File[]{TestUtils.resolveSnapshotDirectory()})).setMessage("Test recovery snapshot"));
        this.executeAction(req, Duration.ofMinutes(2L), res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }
}

