/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithGridGainSecurityTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.Status;
import org.junit.Assert;
import org.junit.Test;

public class SecurityActionsControllerWithGridGainSecurityTest
extends AbstractActionControllerWithGridGainSecurityTest {
    @Test
    public void shouldSuccessfullyAuthenticate() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("SecurityActions.authenticate").setArgument((Object)new AuthenticateCredentials().setCredentials(new SecurityCredentials("admin", "123456")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r.getStatus() == Status.COMPLETED && UUID.fromString((String)r.getResult()) != null;
        });
    }

    @Test
    public void shouldSendErrorResponseWithEmptyCredentials() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("SecurityActions.authenticate").setArgument((Object)new AuthenticateCredentials());
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r.getStatus() == Status.FAILED && r.getError().getCode() == -32001;
        });
    }

    @Test
    public void shouldSendErrorResponseWithInvalidCredentials() {
        Request req = new Request().setId(UUID.randomUUID()).setAction("SecurityActions.authenticate").setArgument((Object)new AuthenticateCredentials().setCredentials(new SecurityCredentials("admin", "1234567")));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r.getStatus() == Status.FAILED && r.getError().getCode() == -32001;
        });
    }

    @Test
    public void shouldExecuteActionUnderAuthenticationUser() {
        String expAuthLogin = "admin";
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(expAuthLogin, "123456")));
        Request req = new Request().setId(UUID.randomUUID()).setAction("IgniteTestActionController.securityLogin").setNodeIds(Collections.singleton(this.cluster.localNode().id())).setSessionId(sesId);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            Assert.assertEquals((Object)expAuthLogin, (Object)r.getResult());
            return r.getStatus() == Status.COMPLETED;
        });
    }
}

