/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.security.rolebased;

import org.apache.ignite.IgniteAuthenticationException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.apache.ignite.spi.IgniteSpiException;
import org.gridgain.control.agent.AbstractSelfTest;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.rolebased.RoleBasedAuthenticator;
import org.gridgain.grid.security.rolebased.UserCredential;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RoleBasedAuthenticatorTest
extends AbstractSelfTest {
    private static final String STATIC_USER = "default";
    private static final String STATIC_ROLE = "default";
    private static final String STATIC_PASSWORD = "default";
    private static final String USERNAME = "user";
    private static final String PASSWORD = "user";

    @Before
    public void setup() {
        this.cleanPersistenceDir();
        IgniteEx ignite = this.startGrid();
        ignite.cluster().state(ClusterState.ACTIVE);
        TestUtils.createRole(ignite, "user", "{defaultAllow:true}");
        TestUtils.createUser(ignite, "user", "user", "user");
    }

    @After
    public void teardown() {
        this.stopAllGrids();
    }

    @Test
    public void serverNodeShouldNotConnect() {
        GridGainConfiguration gCfg;
        try {
            gCfg = new GridGainConfiguration().setAuthenticator((Authenticator)new RoleBasedAuthenticator().setStaticRoles(F.asMap((Object)"default", (Object)"{defaultAllow:false}")).setStaticUsers(F.asMap((Object)"default", (Object)new UserCredential("default", "default")))).setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("wrong", "wrong")));
            this.startGrid(this.getConfiguration(this.instanceName(1)).setPluginConfigurations(new PluginConfiguration[]{gCfg}));
            assert (false);
        }
        catch (IgniteException e) {
            Assert.assertTrue((boolean)X.hasCause((Throwable)e, (String)"Authentication failed", (Class[])new Class[]{IgniteAuthenticationException.class}));
        }
        try {
            gCfg = new GridGainConfiguration().setAuthenticator((Authenticator)new RoleBasedAuthenticator().setStaticRoles(F.asMap((Object)"default", (Object)"{defaultAllow:false}")).setStaticUsers(F.asMap((Object)"default", (Object)new UserCredential("default", "default"))));
            this.startGrid(this.getConfiguration(this.instanceName(1)).setPluginConfigurations(new PluginConfiguration[]{gCfg}));
            assert (false);
        }
        catch (IgniteException e) {
            Assert.assertTrue((boolean)X.hasCause((Throwable)e, (String)"authentication is configured, but security credentials provider is not set", (Class[])new Class[]{IgniteCheckedException.class}));
        }
    }

    @Test
    public void shouldNotJoinWithDifferentConfiguration() {
        GridGainConfiguration gCfg = new GridGainConfiguration().setAuthenticator((Authenticator)new RoleBasedAuthenticator().setStaticRoles(F.asMap((Object)"default", (Object)"{defaultAllow:false}")).setStaticUsers(F.asMap((Object)"default", (Object)new UserCredential("default", "default")))).setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("default", "default")));
        try {
            this.startGrid(this.getConfiguration(this.instanceName(1)).setPluginConfigurations(new PluginConfiguration[]{gCfg}));
            assert (false);
        }
        catch (IgniteException e) {
            Assert.assertTrue((boolean)X.hasCause((Throwable)e, (String)"Local node's authentication token is not equal to remote node's authentication token", (Class[])new Class[]{IgniteSpiException.class}));
        }
        gCfg = new GridGainConfiguration().setAuthenticator((Authenticator)new RoleBasedAuthenticator().setStaticRoles(F.asMap((Object)"default", (Object)"{defaultAllow:true}")).setStaticUsers(F.asMap((Object)"default", (Object)new UserCredential("user", "default")))).setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("default", "default")));
        try {
            this.startGrid(this.getConfiguration(this.instanceName(1)).setPluginConfigurations(new PluginConfiguration[]{gCfg}));
            assert (false);
        }
        catch (IgniteException e) {
            Assert.assertTrue((boolean)X.hasCause((Throwable)e, (String)"Local node's authentication token is not equal to remote node's authentication token", (Class[])new Class[]{IgniteSpiException.class}));
        }
    }

    @Test
    public void clientNodeShouldNotConnect() {
        try {
            this.startGrid(this.getConfiguration(this.instanceName(1)).setClientMode(true).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration()}));
            assert (false);
        }
        catch (IgniteException e) {
            Assert.assertTrue((boolean)X.hasCause((Throwable)e, (String)"Authentication failed", (Class[])new Class[]{IgniteAuthenticationException.class}));
        }
        try {
            this.startGrid(this.getConfiguration(this.instanceName(1)).setClientMode(true).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("wrong", "wrong")))}));
            assert (false);
        }
        catch (IgniteException e) {
            Assert.assertTrue((boolean)X.hasCause((Throwable)e, (String)"Authentication failed", (Class[])new Class[]{IgniteAuthenticationException.class}));
        }
    }

    @Test
    public void clientNodeShouldConnectWithDifferentUsers() {
        IgniteEx ignored = this.startGrid(this.getConfiguration(this.instanceName(1)).setClientMode(true).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("default", "default")))}));
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
        ignored = this.startGrid(this.getConfiguration(this.instanceName(1)).setClientMode(true).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("user", "user")))}));
        throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
            } else {
                ignored.close();
            }
        }
    }

    @Test
    public void thinClientConnectingWithWrongUserName() {
        ClientConfiguration clientCfg = new ClientConfiguration().setAddresses(new String[]{"localhost:10800"}).setUserName("not_exist");
        try {
            IgniteClient client = Ignition.startClient((ClientConfiguration)clientCfg);
            Throwable throwable = null;
            if (client != null) {
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    client.close();
                }
            }
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("The user name or password is incorrect"));
        }
    }

    @Test
    public void thinClientConnectingWithNoPassword() {
        ClientConfiguration clientCfg = new ClientConfiguration().setAddresses(new String[]{"localhost:10800"}).setUserName("user");
        try {
            IgniteClient client = Ignition.startClient((ClientConfiguration)clientCfg);
            Throwable throwable = null;
            if (client != null) {
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    client.close();
                }
            }
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("The user name or password is incorrect"));
        }
    }

    @Test
    public void thinClientConnectingWithWrongPassword() {
        ClientConfiguration clientCfg = new ClientConfiguration().setAddresses(new String[]{"localhost:10800"}).setUserName("user").setUserPassword("wrong");
        try {
            IgniteClient client = Ignition.startClient((ClientConfiguration)clientCfg);
            Throwable throwable = null;
            if (client != null) {
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    client.close();
                }
            }
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("The user name or password is incorrect"));
        }
    }

    @Test
    public void clientNodeShouldNotConnectToInactiveCluster() {
        try {
            IgnitionEx.grid((String)"default").cluster().state(ClusterState.INACTIVE);
            IgniteConfiguration cfg = this.getConfiguration(this.instanceName(1), new GridGainConfiguration().setAuthenticator((Authenticator)new RoleBasedAuthenticator().setStaticRoles(F.asMap((Object)"default", (Object)"{defaultAllow:false}")).setStaticUsers(F.asMap((Object)"default", (Object)new UserCredential("default", "default")))).setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("user", "user")))).setClientMode(true);
            IgniteEx ignored = this.startGrid(cfg);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
            assert (false);
        }
        catch (IgniteException e) {
            Assert.assertTrue((boolean)X.hasCause((Throwable)e, (String)"Authentication failed", (Class[])new Class[]{IgniteAuthenticationException.class}));
        }
    }

    private IgniteConfiguration getConfiguration(String instanceName, GridGainConfiguration gCfg) {
        return super.getConfiguration(instanceName).setCacheConfiguration(new CacheConfiguration[]{TestUtils.nebulaUserCacheConfiguration(), TestUtils.nebulaRoleCacheConfiguration()}).setPluginConfigurations(new PluginConfiguration[]{gCfg});
    }

    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        return this.getConfiguration(instanceName, new GridGainConfiguration().setAuthenticator((Authenticator)new RoleBasedAuthenticator().setStaticRoles(F.asMap((Object)"default", (Object)"{defaultAllow:true}")).setStaticUsers(F.asMap((Object)"default", (Object)new UserCredential("default", "default")))).setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(new SecurityCredentials("default", "default"))));
    }
}

