/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.transport.ws;

import java.util.Collections;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.control.agent.AgentWithProxyAbstractTest;
import org.gridgain.control.agent.test.TestLogger;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.Test;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.TestPropertySource;
import org.testcontainers.containers.GenericContainer;

public class WebSocketManagerWithProxyTest
extends AgentWithProxyAbstractTest {
    @Test
    public void shouldConnectWithProxy() {
        try (GenericContainer proxy = this.startProxy();){
            System.setProperty("http.proxyHost", proxy.getContainerIpAddress());
            System.setProperty("http.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
            IgniteEx ignite = this.startGrid();
            this.changeAgentConfiguration(ignite, true, false, false, true);
        }
    }

    @Test
    public void shouldReconnectOnConnectionLost() throws Exception {
        TestLogger crdLog = new TestLogger();
        IgniteEx crd = this.startNodeWithTestLogger(crdLog, "node-1");
        crd.cluster().state(ClusterState.ACTIVE);
        try (GenericContainer proxy = this.startProxy();){
            System.setProperty("http.proxyHost", proxy.getContainerIpAddress());
            System.setProperty("http.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
            this.changeAgentConfiguration(crd, true, false, false, true);
            this.startNodeAsSeparatedProcess(WebSocketManagerWithProxyTest.withoutInClassPath(Collections.emptySet()), log -> {});
        }
        TestUtils.assertWithPoll(() -> crdLog.contains("Control Center Agent will continue connection attempts in the background"));
    }

    @Test
    public void shouldConnectWithHttpsProxy() {
        try (GenericContainer proxy = this.startHttpsProxy();){
            System.setProperty("http.proxyHost", proxy.getContainerIpAddress());
            System.setProperty("http.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
            IgniteEx ignite = this.startGrid();
            this.changeAgentConfiguration(ignite, true, false, false, true);
        }
    }

    @Test
    public void shouldConnectWithAuthProxy() {
        try (GenericContainer proxy = this.startProxyWithCreds();){
            System.setProperty("http.proxyHost", proxy.getContainerIpAddress());
            System.setProperty("http.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
            System.setProperty("http.proxyUsername", "user");
            System.setProperty("http.proxyPassword", "123456");
            IgniteEx ignite = this.startGrid();
            this.changeAgentConfiguration(ignite, true, false, false, true);
        }
    }

    @Test
    public void shouldConnectWithProxyFromHttpsProperty() {
        try (GenericContainer proxy = this.startProxy();){
            System.setProperty("https.proxyHost", proxy.getContainerIpAddress());
            System.setProperty("https.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
            IgniteEx ignite = this.startGrid();
            this.changeAgentConfiguration(ignite, true, false, false, true);
        }
    }

    @Test
    public void shouldConnectWithHttpsProxyFromHttpsProperty() {
        try (GenericContainer proxy = this.startHttpsProxy();){
            System.setProperty("https.proxyHost", proxy.getContainerIpAddress());
            System.setProperty("https.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
            IgniteEx ignite = this.startGrid();
            this.changeAgentConfiguration(ignite, true, false, false, true);
        }
    }

    @Test
    public void shouldConnectWithAuthProxyFromHttpsProperty() {
        try (GenericContainer proxy = this.startProxyWithCreds();){
            System.setProperty("https.proxyHost", proxy.getContainerIpAddress());
            System.setProperty("https.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
            System.setProperty("https.proxyUsername", "user");
            System.setProperty("https.proxyPassword", "123456");
            IgniteEx ignite = this.startGrid();
            this.changeAgentConfiguration(ignite, true, false, false, true);
        }
    }

    @ActiveProfiles(value={"two-way-ssl"})
    @TestPropertySource(properties={"server.ssl.client-auth=need"})
    public static class WebSocketManagerWithTwoWaySslAndProxyTest
    extends AgentWithProxyAbstractTest {
        @Test
        public void shouldConnectWithProxy() {
            try (GenericContainer proxy = this.startProxy();){
                System.setProperty("http.proxyHost", proxy.getContainerIpAddress());
                System.setProperty("http.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
                IgniteEx ignite = this.startGrid();
                this.changeAgentConfiguration(ignite, true, true, true, true);
            }
        }

        @Test
        public void shouldConnectWithHttpsProxy() {
            try (GenericContainer proxy = this.startHttpsProxy();){
                System.setProperty("http.proxyHost", proxy.getContainerIpAddress());
                System.setProperty("http.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
                IgniteEx ignite = this.startGrid();
                this.changeAgentConfiguration(ignite, true, true, true, true);
            }
        }

        @Test
        public void shouldConnectWithAuthProxy() {
            try (GenericContainer proxy = this.startProxyWithCreds();){
                System.setProperty("http.proxyHost", proxy.getContainerIpAddress());
                System.setProperty("http.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
                System.setProperty("http.proxyUsername", "user");
                System.setProperty("http.proxyPassword", "123456");
                IgniteEx ignite = this.startGrid();
                this.changeAgentConfiguration(ignite, true, true, true, true);
            }
        }
    }

    @ActiveProfiles(value={"two-way-ssl"})
    @TestPropertySource(properties={"server.ssl.client-auth=want"})
    public static class WebSocketManagerWithSslAndProxyTest
    extends AgentWithProxyAbstractTest {
        @Test
        public void shouldConnectWithProxy() {
            try (GenericContainer proxy = this.startProxy();){
                System.setProperty("http.proxyHost", proxy.getContainerIpAddress());
                System.setProperty("http.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
                IgniteEx ignite = this.startGrid();
                this.changeAgentConfiguration(ignite, true, true, false, true);
            }
        }

        @Test
        public void shouldConnectWithHttpsProxy() {
            try (GenericContainer proxy = this.startHttpsProxy();){
                System.setProperty("https.proxyHost", proxy.getContainerIpAddress());
                System.setProperty("https.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
                IgniteEx ignite = this.startGrid();
                this.changeAgentConfiguration(ignite, true, true, false, true);
            }
        }

        @Test
        public void shouldConnectWithAuthProxy() {
            try (GenericContainer proxy = this.startProxyWithCreds();){
                System.setProperty("http.proxyHost", proxy.getContainerIpAddress());
                System.setProperty("http.proxyPort", String.valueOf(proxy.getMappedPort(3128)));
                System.setProperty("http.proxyUsername", "user");
                System.setProperty("http.proxyPassword", "123456");
                IgniteEx ignite = this.startGrid();
                this.changeAgentConfiguration(ignite, true, true, false, true);
            }
        }
    }
}

