/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor.export;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.resource.DependencyResolver;
import org.apache.ignite.internal.processors.task.monitor.ComputeTaskStatus;
import org.apache.ignite.internal.processors.task.monitor.ComputeTaskStatusSnapshot;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.lang.IgniteThrowableConsumer;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.data.MapEntry;
import org.assertj.core.groups.Tuple;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.compute.ComputeTaskPullRequest;
import org.gridgain.control.agent.dto.compute.TaskInfo;
import org.gridgain.control.agent.dto.compute.TaskInfoStatus;
import org.gridgain.control.agent.dto.feature.AbstractFeatureRequest;
import org.gridgain.control.agent.dto.feature.AgentDynamicFeatures;
import org.gridgain.control.agent.dto.feature.DisablingAgentFeatureRequest;
import org.gridgain.control.agent.processor.action.ExecuteActionTask;
import org.gridgain.control.agent.processor.export.task.TaskExporter;
import org.gridgain.control.agent.processor.feature.AgentDynamicFeatureProcessor;
import org.gridgain.control.agent.test.TestTask;
import org.gridgain.control.agent.test.TestUtils;
import org.gridgain.control.agent.utils.AgentObjectMapperFactory;
import org.gridgain.control.agent.utils.AgentUtils;
import org.gridgain.control.agent.utils.RegistryNoopDependencyResolver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExporterTest
extends AgentCommonAbstractTest {
    private final Logger log = LoggerFactory.getLogger(TaskExporterTest.class);
    private final ObjectMapper mapper = AgentObjectMapperFactory.jsonMapper();
    private RegistryNoopDependencyResolver di;

    @Override
    @Before
    public void setup() throws Exception {
        this.di = new RegistryNoopDependencyResolver();
        IgnitionEx.dependencyResolver((DependencyResolver)this.di);
        super.cleanup();
    }

    @Override
    @After
    public void teardown() {
        System.clearProperty("EXPORT_INITIAL_DELAY");
        System.clearProperty("EXPORT_PERIOD");
        System.clearProperty("EXPORT_EXCLUDE_INTERNAL_TASKS");
        System.clearProperty("EXPORT_IGNORED_TASKS");
        System.clearProperty("EXPORT_MONITORED_TASKS");
        IgnitionEx.dependencyResolver(null);
        super.teardown();
    }

    @Test
    public void shouldSendTaskUpdatesToTopic() {
        IgniteEx ignite = this.prepareGrids(1, 100L, 1000L);
        UUID clusterId = ignite.cluster().id();
        IgniteUuid taskSesId = ignite.compute().executeAsync(TestTask.class, (Object)5000L).getTaskSession().getId();
        int taskBatchIdx = 0;
        this.log.info("Assert task is created and set to job nodes");
        this.assertTask(clusterId, taskBatchIdx, taskBatch -> {
            AbstractListAssert cfr_ignored_0 = (AbstractListAssert)((ListAssert)Assertions.assertThat((List)taskBatch).hasSize(1)).extracting(new String[]{"taskName", "status", "attrs"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TestTask.class.getName(), TaskInfoStatus.RUNNING, null})});
        });
        this.assertWithTaskPoll(ignite, taskSesId, 1500L, (IgniteThrowableConsumer & Serializable)fut -> fut.getTaskSession().setAttribute((Object)"attr", (Object)"attrValue"));
        this.log.info("Assert task is populated with an attribute");
        this.assertTask(clusterId, ++taskBatchIdx, taskBatch -> {
            AbstractListAssert cfr_ignored_0 = (AbstractListAssert)((ListAssert)Assertions.assertThat((List)taskBatch).hasSize(1)).extracting(new String[]{"taskName", "status", "attrs", "failedReason", "stacktrace"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TestTask.class.getName(), TaskInfoStatus.RUNNING, U.map((Object)"attr", (Object)"attrValue"), null, null})});
        });
        this.log.info("Assert task is finished");
        this.assertTask(clusterId, ++taskBatchIdx, taskBatch -> {
            AbstractListAssert cfr_ignored_0 = (AbstractListAssert)((ListAssert)Assertions.assertThat((List)taskBatch).hasSize(1)).extracting(new String[]{"taskName", "status", "attrs", "failedReason", "stacktrace"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TestTask.class.getName(), TaskInfoStatus.FINISHED, U.map((Object)"attr", (Object)"attrValue"), null, null})});
        });
    }

    @Test
    public void shouldSendTaskUpdatesInSingleBatch() {
        IgniteEx ignite = this.prepareGrids(1, 100L, 2000L);
        UUID clusterId = ignite.cluster().id();
        IgniteUuid taskSesId = ignite.compute().executeAsync(TestTask.class, (Object)7000L).getTaskSession().getId();
        this.assertWithTaskPoll(ignite, taskSesId, 2500L, (IgniteThrowableConsumer & Serializable)fut -> fut.getTaskSession().setAttribute((Object)"attr", (Object)"attrValue"));
        this.assertWithTaskPoll(ignite, taskSesId, 100L, (IgniteThrowableConsumer & Serializable)fut -> fut.getTaskSession().setAttribute((Object)"attr2", (Object)"attrValue2"));
        this.assertWithTaskPoll(ignite, taskSesId, 100L, (IgniteThrowableConsumer & Serializable)fut -> fut.getTaskSession().setAttribute((Object)"attr3", (Object)"attrValue3"));
        this.log.info("Assert task is populated with an attribute");
        this.assertSeriesOfTaskBatches(clusterId, (prevBatch, newBatch) -> {
            boolean noAttrsInPrevBatch = F.isEmpty((Collection)prevBatch) || prevBatch.stream().allMatch(task -> F.isEmpty((Map)task.getAttributes()));
            boolean allAttrsInNewBatch = newBatch.stream().allMatch(task -> !F.isEmpty((Map)task.getAttributes()) && task.getAttributes().size() == 3 && task.getAttributes().entrySet().containsAll(GridFunc.asList((Object[])new MapEntry[]{MapEntry.entry((Object)"attr", (Object)"attrValue"), MapEntry.entry((Object)"attr2", (Object)"attrValue2"), MapEntry.entry((Object)"attr3", (Object)"attrValue3")})));
            return noAttrsInPrevBatch && allAttrsInNewBatch;
        });
    }

    @Test
    public void shouldSendCancelledStatusToTopic() {
        IgniteEx ignite = this.prepareGrids(1, 100L, 500L);
        UUID clusterId = ignite.cluster().id();
        IgniteUuid taskSesId = ignite.compute().executeAsync(TestTask.class, (Object)10000L).getTaskSession().getId();
        this.assertWithTaskPoll(ignite, taskSesId, 500L, (IgniteThrowableConsumer & Serializable)fut -> fut.cancel());
        TestUtils.assertWithPoll(() -> {
            List tasks = AgentUtils.fromNullableCollection(this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class)).flatMap(Collection::stream).collect(Collectors.toList());
            if (tasks.size() < 2) {
                return false;
            }
            Assertions.assertThat(tasks).extracting(new String[]{"taskName", "status", "failedReason", "stacktrace"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TestTask.class.getName(), TaskInfoStatus.RUNNING, null, null}), Assertions.tuple((Object[])new Object[]{TestTask.class.getName(), TaskInfoStatus.CANCELED, null, null})});
            return true;
        });
    }

    @Test
    public void shouldSendTasksFromOtherNodes() {
        IgniteEx ignite = this.prepareGrids(2, 100L, 500L);
        UUID clusterId = ignite.cluster().id();
        this.ignite(0).compute().executeAsync(TestTask.class, (Object)1000L).getTaskSession().getId();
        this.ignite(1).compute().executeAsync(TestTask.class, (Object)1000L).getTaskSession().getId();
        TestUtils.assertWithPoll(() -> {
            List tasks = this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class).stream().flatMap(Collection::stream).collect(Collectors.toList());
            if (tasks.size() < 2) {
                return false;
            }
            ((ListAssert)Assertions.assertThat(tasks).usingRecursiveFieldByFieldElementComparatorOnFields(new String[]{"taskName", "status", "reducerId"})).containsExactlyInAnyOrder((Object[])new TaskInfo[]{new TaskInfo().setTaskName(TestTask.class.getName()).setStatus(TaskInfoStatus.RUNNING).setReducerId(this.ignite(0).localNode().id()), new TaskInfo().setTaskName(TestTask.class.getName()).setStatus(TaskInfoStatus.RUNNING).setReducerId(this.ignite(1).localNode().id())});
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSendBatchImmediatelly() {
        int testBatchSize = 5;
        ArrayList testStatuses = new ArrayList(testBatchSize);
        try {
            System.setProperty("TASK_BATCH_SIZE", String.valueOf(testBatchSize));
            IgniteEx ignite = this.prepareGrids(1, 25000L, 25000L);
            UUID clusterId = ignite.cluster().id();
            TaskExporter exporter = this.di.getDependency(TaskExporter.class);
            IntStream.range(0, testBatchSize).forEach(ignored -> testStatuses.add(ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite))));
            exporter.processStatusSnapshots(testStatuses);
            TestUtils.assertWithPoll(() -> this.checkPackageSent(clusterId, 1, testBatchSize, TaskInfoStatus.RUNNING));
            testStatuses.clear();
            IntStream.range(0, testBatchSize).forEach(ignored -> testStatuses.add(ComputeTaskStatus.onFinishTask((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite), null)));
            exporter.processStatusSnapshots(testStatuses);
            TestUtils.assertWithPoll(() -> this.checkPackageSent(clusterId, 2, testBatchSize, TaskInfoStatus.FINISHED));
        }
        finally {
            System.clearProperty("TASK_BATCH_SIZE");
            IgnitionEx.dependencyResolver(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLimitMaximumTaskInfoBuffer() {
        int rateLimit = 5;
        ArrayList<IgniteUuid> oldestTasks = new ArrayList<IgniteUuid>(rateLimit);
        ArrayList<ComputeTaskStatus> testStatuses = new ArrayList<ComputeTaskStatus>();
        try {
            System.setProperty("EXPORT_BUFFER_SIZE", String.valueOf(rateLimit));
            IgniteEx ignite = this.prepareGrids(1, 500L, 500L);
            UUID clusterId = ignite.cluster().id();
            testStatuses.add(ComputeTaskStatus.onFinishTask((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite), null));
            oldestTasks.add(((ComputeTaskStatusSnapshot)testStatuses.get(0)).sessionId());
            IntStream.range(0, 3).forEach(idx -> {
                ComputeTaskStatus taskInfo = ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite));
                testStatuses.add(taskInfo);
                if (idx == 0) {
                    oldestTasks.add(((ComputeTaskStatusSnapshot)testStatuses.get(1)).sessionId());
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            IntStream.range(0, 3).forEach(ignored -> {
                ComputeTaskStatus taskInfo = ComputeTaskStatus.onFinishTask((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite), null);
                testStatuses.add(taskInfo);
                oldestTasks.add(taskInfo.sessionId());
            });
            this.di.getDependency(TaskExporter.class).processStatusSnapshots(testStatuses);
            TestUtils.assertWithPoll(() -> {
                List<TaskInfo> last = this.inInterceptor.getListPayload(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class);
                return last.size() == rateLimit && last.stream().allMatch(task -> oldestTasks.contains(task.getSessionId()));
            });
        }
        finally {
            System.clearProperty("EXPORT_BUFFER_SIZE");
            IgnitionEx.dependencyResolver(null);
        }
    }

    @Test
    public void pullTaskStatusAgain() throws JsonProcessingException {
        IgniteEx ignite = this.prepareGrids(1, 100L, 1000L);
        UUID clusterId = ignite.cluster().id();
        IgniteUuid taskSesId = ignite.compute().executeAsync(TestTask.class, (Object)500000L).getTaskSession().getId();
        TestUtils.assertWithPoll(() -> {
            List<List<TaskInfo>> payloads = this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class);
            if (payloads.size() != 1) {
                return false;
            }
            List<TaskInfo> infos = payloads.get(0);
            return infos.size() == 1 && infos.get(0).getStatus() == TaskInfoStatus.RUNNING && infos.get(0).getSessionId().equals((Object)taskSesId);
        });
        TaskInfo taskInfo = this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class).get(0).get(0);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildComputeTaskPullTopic((UUID)clusterId), (Object)this.mapper.writeValueAsString(Collections.singletonList(new ComputeTaskPullRequest(taskSesId, ignite.localNode().id()))));
        TestUtils.assertWithPoll(() -> this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class).stream().flatMap(Collection::stream).anyMatch(p -> p.getStatus() == TaskInfoStatus.RUNNING && p.getSessionId().equals((Object)taskSesId) && p.getVersion() != taskInfo.getVersion()));
    }

    @Test
    public void shouldFilterInternalTasks() {
        IgniteEx ignite = this.prepareGrids(1, 100L, 500L);
        UUID clusterId = ignite.cluster().id();
        TaskExporter exporter = this.di.getDependency(TaskExporter.class);
        exporter.processStatusSnapshots((Collection)GridFunc.asList((Object[])new ComputeTaskStatusSnapshot[]{ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, ExecuteActionTask.class.getName(), true))}));
        TestUtils.assertWithPoll(() -> {
            List<TaskInfo> tasks = this.inInterceptor.getListPayload(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class);
            if (tasks.size() == 0) {
                return false;
            }
            Assertions.assertThat(tasks).extracting(TaskInfo::getTaskName).containsExactlyInAnyOrder((Object[])new String[]{TestTask.class.getSimpleName()});
            return true;
        });
    }

    @Test
    public void shouldIgnoreTasksByRegExp() {
        System.setProperty("EXPORT_IGNORED_TASKS", ".*MetadataTask;.*JdbcTask");
        IgniteEx ignite = this.prepareGrids(1, 100L, 500L);
        UUID clusterId = ignite.cluster().id();
        TaskExporter exporter = this.di.getDependency(TaskExporter.class);
        exporter.processStatusSnapshots((Collection)GridFunc.asList((Object[])new ComputeTaskStatusSnapshot[]{ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, "org.ignite.GridCacheQueryJdbcMetadataTask", false)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, "org.ignite.GridCacheQueryJdbcTask", false)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, "org.ignite.GridCacheQueryJdbcValidationTask", false)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, ExecuteActionTask.class.getName(), true))}));
        TestUtils.assertWithPoll(() -> {
            List<TaskInfo> tasks = this.inInterceptor.getListPayload(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class);
            if (tasks.size() == 0) {
                return false;
            }
            Assertions.assertThat(tasks).extracting(TaskInfo::getTaskName).containsExactlyInAnyOrder((Object[])new String[]{"TestTask", "GridCacheQueryJdbcValidationTask"});
            return true;
        });
    }

    @Test
    public void shouldFilterTasks() {
        System.setProperty("EXPORT_IGNORED_TASKS", ".*Metadata.*");
        System.setProperty("EXPORT_MONITORED_TASKS", ".*Jdbc.*");
        IgniteEx ignite = this.prepareGrids(1, 100L, 500L);
        UUID clusterId = ignite.cluster().id();
        TaskExporter exporter = this.di.getDependency(TaskExporter.class);
        exporter.processStatusSnapshots((Collection)GridFunc.asList((Object[])new ComputeTaskStatusSnapshot[]{ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, "org.ignite.GridCacheQueryJdbcMetadataTask", false)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, "org.ignite.GridCacheQueryJdbcTask", false)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, "org.ignite.GridCacheQueryJdbcValidationTask", false)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, ExecuteActionTask.class.getName(), true))}));
        TestUtils.assertWithPoll(() -> {
            List<TaskInfo> tasks = this.inInterceptor.getListPayload(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class);
            if (tasks.size() == 0) {
                return false;
            }
            Assertions.assertThat(tasks).extracting(TaskInfo::getTaskName).containsExactlyInAnyOrder((Object[])new String[]{"GridCacheQueryJdbcTask", "GridCacheQueryJdbcValidationTask"});
            return true;
        });
    }

    @Test
    public void shouldMonitorTasksByRegExp() {
        System.setProperty("EXPORT_MONITORED_TASKS", ".*MetadataTask;.*JdbcTask");
        IgniteEx ignite = this.prepareGrids(1, 100L, 500L);
        UUID clusterId = ignite.cluster().id();
        TaskExporter exporter = this.di.getDependency(TaskExporter.class);
        exporter.processStatusSnapshots((Collection)GridFunc.asList((Object[])new ComputeTaskStatusSnapshot[]{ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, "org.ignite.GridCacheQueryJdbcMetadataTask", false)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, "org.ignite.GridCacheQueryJdbcTask", false)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, "org.ignite.GridCacheQueryJdbcValidationTask", false)), ComputeTaskStatus.snapshot((GridTaskSessionImpl)this.prepareTestTaskStatus(ignite, ExecuteActionTask.class.getName(), true))}));
        TestUtils.assertWithPoll(() -> {
            List<TaskInfo> tasks = this.inInterceptor.getListPayload(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class);
            if (tasks.size() == 0) {
                return false;
            }
            Assertions.assertThat(tasks).extracting(TaskInfo::getTaskName).containsExactlyInAnyOrder((Object[])new String[]{"GridCacheQueryJdbcMetadataTask", "GridCacheQueryJdbcTask"});
            return true;
        });
    }

    @Test
    public void shouldNotPullTasksIfNotEnabled() throws JsonProcessingException {
        System.setProperty("EXPORT_INITIAL_DELAY", String.valueOf(500));
        System.setProperty("EXPORT_PERIOD", String.valueOf(500));
        IgniteEx ignite = this.prepareGrids(1, 100L, 500L);
        UUID clusterId = ignite.cluster().id();
        AgentDynamicFeatureProcessor agentDynamicFeatureProcessor = this.di.getDependency(AgentDynamicFeatureProcessor.class);
        agentDynamicFeatureProcessor.onRequest((AbstractFeatureRequest)new DisablingAgentFeatureRequest(AgentDynamicFeatures.COMPUTE.getValue(), false));
        Assert.assertFalse((boolean)agentDynamicFeatureProcessor.isAvailable(AgentDynamicFeatures.COMPUTE));
        IgniteUuid taskSesId = ignite.compute().executeAsync(TestTask.class, (Object)1000L).getTaskSession().getId();
        this.template.convertAndSend((Object)StompDestinationsUtils.buildComputeTaskPullTopic((UUID)clusterId), (Object)this.mapper.writeValueAsString(Collections.singletonList(new ComputeTaskPullRequest(taskSesId, ignite.localNode().id()))));
        TestUtils.assertTimesWithPoll(10, 200L, 1000L, () -> this.checkPackageNotSent(clusterId));
    }

    private IgniteEx prepareGrids(int gridCnt, long initDelay, long period) {
        System.setProperty("EXPORT_INITIAL_DELAY", String.valueOf(initDelay));
        System.setProperty("EXPORT_PERIOD", String.valueOf(period));
        IgniteEx ignite = this.startGrids(gridCnt);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        TestUtils.assertWithPoll(() -> this.inInterceptor.getListPayload(StompDestinationsUtils.buildSaveTaskDest((UUID)cluster.id()), TaskInfo.class).isEmpty());
        return ignite;
    }

    private GridTaskSessionImpl prepareTestTaskStatus(IgniteEx ignite, String taskCls, boolean internal) {
        return new GridTaskSessionImpl(ignite.context().localNodeId(), (String)F.last(Arrays.asList(taskCls.split("\\."))), null, taskCls, IgniteUuid.randomUuid(), (Collection)ignite.cluster().nodes().stream().map(ClusterNode::id).collect(Collectors.toList()), null, System.currentTimeMillis(), 0L, null, null, ignite.context(), true, internal, UUID.randomUUID(), null, null);
    }

    private GridTaskSessionImpl prepareTestTaskStatus(IgniteEx ignite) {
        return this.prepareTestTaskStatus(ignite, TestTask.class.getName(), false);
    }

    private boolean checkPackageSent(UUID clusterId, int pkgIdx, int testBatchSize, TaskInfoStatus status) {
        List<List<TaskInfo>> taskBatches = this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class);
        if (taskBatches.size() != pkgIdx) {
            return false;
        }
        List<TaskInfo> batch = taskBatches.get(pkgIdx - 1);
        if (batch.size() != testBatchSize) {
            return false;
        }
        return batch.stream().allMatch(info -> info.getStatus() == status);
    }

    private boolean checkPackageNotSent(UUID clusterId) {
        List<List<TaskInfo>> taskBatches = this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class);
        return taskBatches.size() == 0;
    }

    private void assertWithTaskPoll(IgniteEx ignite, IgniteUuid taskSesId, long delay, IgniteThrowableConsumer<ComputeTaskInternalFuture<?>> taskFutConsumer) {
        TestUtils.assertWithPoll(100L, delay, 20000L, () -> {
            ComputeTaskInternalFuture fut = ignite.context().task().taskFuture(taskSesId);
            if (fut == null) {
                return false;
            }
            try {
                taskFutConsumer.accept((Object)fut);
                return true;
            }
            catch (Exception e) {
                this.log.error("Failed to perform operation", (Throwable)e);
                return false;
            }
        });
    }

    private void assertTask(UUID clusterId, int taskBatchIdx, Consumer<List<TaskInfo>> taskBatchConsumer) {
        TestUtils.assertWithPoll(() -> {
            List<List<TaskInfo>> taskBatches = this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class);
            if (taskBatchIdx >= taskBatches.size()) {
                return false;
            }
            taskBatchConsumer.accept(taskBatches.get(taskBatchIdx));
            return true;
        });
    }

    private void assertSeriesOfTaskBatches(UUID clusterId, BiFunction<List<TaskInfo>, List<TaskInfo>, Boolean> taskBiFunction) {
        TestUtils.assertWithPoll(1000L, 100L, 10000L, () -> {
            List<List<TaskInfo>> taskBatches = this.inInterceptor.getAllListPayloads(StompDestinationsUtils.buildSaveTaskDest((UUID)clusterId), TaskInfo.class);
            boolean res = false;
            if (!F.isEmpty(taskBatches)) {
                int i = 0;
                for (int j = 1; j < taskBatches.size(); ++j) {
                    res |= ((Boolean)taskBiFunction.apply(taskBatches.get(i), taskBatches.get(j))).booleanValue();
                    ++i;
                }
            }
            return res;
        });
    }
}

