/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.tracing.Scope;
import org.apache.ignite.spi.tracing.TracingConfigurationCoordinates;
import org.apache.ignite.spi.tracing.TracingConfigurationParameters;
import org.assertj.core.api.Assertions;
import org.awaitility.core.ConditionTimeoutException;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.dto.tracing.TracingConfiguration;
import org.gridgain.control.agent.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TracingConfigurationProcessorTest
extends AgentCommonAbstractTest {
    @Test
    public void shouldSendInitialConfiguration() {
        IgniteEx ignite = this.startGrid();
        UUID clusterId = ignite.cluster().id();
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)clusterId), (Object)true);
        String dest = StompDestinationsUtils.buildTracingConfigurationDest((UUID)clusterId);
        TestUtils.assertWithPoll(() -> {
            List<TracingConfiguration> res = this.inInterceptor.getPayload(dest, new TypeReference<List<TracingConfiguration>>(){});
            Assert.assertNotNull(res);
            Assertions.assertThat((int)res.size()).isGreaterThanOrEqualTo(6);
            Assert.assertTrue((boolean)this.containsTraceConfiguration(res, Scope.COMMUNICATION, null, 0.0, Collections.emptySet()));
            Assert.assertTrue((boolean)this.containsTraceConfiguration(res, Scope.TX, null, 0.0, Collections.emptySet()));
            Assert.assertTrue((boolean)this.containsTraceConfiguration(res, Scope.EXCHANGE, null, 0.0, Collections.emptySet()));
            Assert.assertTrue((boolean)this.containsTraceConfiguration(res, Scope.DISCOVERY, null, 0.0, Collections.emptySet()));
            Assert.assertTrue((boolean)this.containsTraceConfiguration(res, Scope.CACHE_API_READ, null, 0.0, Collections.emptySet()));
            Assert.assertTrue((boolean)this.containsTraceConfiguration(res, Scope.CACHE_API_WRITE, null, 0.0, Collections.emptySet()));
        });
    }

    @Test
    public void shouldSendUpdatedConfiguration() {
        IgniteEx ignite = this.startGrid();
        UUID clusterId = ignite.cluster().id();
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)clusterId), (Object)true);
        String dest = StompDestinationsUtils.buildTracingConfigurationDest((UUID)clusterId);
        ignite.tracingConfiguration().set(new TracingConfigurationCoordinates.Builder(Scope.TX).withLabel("test").build(), new TracingConfigurationParameters.Builder().withSamplingRate(1.0).withIncludedScopes(Collections.singleton(Scope.COMMUNICATION)).build());
        TestUtils.assertWithPoll(() -> {
            List<TracingConfiguration> res = this.inInterceptor.getPayload(dest, new TypeReference<List<TracingConfiguration>>(){});
            Assertions.assertThat(res).isNotEmpty();
            Assert.assertTrue((boolean)this.containsTraceConfiguration(res, Scope.TX, "test", 1.0, Collections.singleton(Scope.COMMUNICATION)));
        });
    }

    @Test
    public void shouldNotSendConfigurationIfNotAttached() {
        IgniteEx ignite = this.startGrid();
        UUID clusterId = ignite.cluster().id();
        this.changeAgentConfiguration(ignite);
        String dest = StompDestinationsUtils.buildTracingConfigurationDest((UUID)clusterId);
        Assert.assertThrows(ConditionTimeoutException.class, () -> TestUtils.assertWithPoll(500L, 1000L, 10000L, () -> !F.isEmpty(this.inInterceptor.getAllPayloads(dest, List.class))));
    }

    @Test
    public void shouldNotSendConfigurationIfNotConnected() {
        IgniteEx ignite = this.startGrid();
        UUID clusterId = ignite.cluster().id();
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)clusterId), (Object)true);
        String dest = StompDestinationsUtils.buildTracingConfigurationDest((UUID)clusterId);
        Assert.assertThrows(ConditionTimeoutException.class, () -> TestUtils.assertWithPoll(500L, 1000L, 10000L, () -> !F.isEmpty(this.inInterceptor.getAllPayloads(dest, List.class))));
    }

    @Test
    public void shouldSendConfigurationOnReconnected() {
        IgniteEx ignite = this.startGrid();
        UUID clusterId = ignite.cluster().id();
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)clusterId), (Object)true);
        String dest = StompDestinationsUtils.buildTracingConfigurationDest((UUID)clusterId);
        TestUtils.assertWithPoll(() -> {
            List<TracingConfiguration> res = this.inInterceptor.getPayload(dest, new TypeReference<List<TracingConfiguration>>(){});
            Assert.assertNotNull(res);
            Assertions.assertThat((int)res.size()).isGreaterThanOrEqualTo(6);
        });
        this.inInterceptor.clearMessages();
        this.websocketDecoratedFactory.disconnectAllClients();
        TestUtils.assertWithPoll(() -> {
            List<TracingConfiguration> res = this.inInterceptor.getPayload(dest, new TypeReference<List<TracingConfiguration>>(){});
            Assert.assertNotNull(res);
            Assertions.assertThat((int)res.size()).isGreaterThanOrEqualTo(6);
        });
    }

    @Test
    public void shouldNotSendConfigIfTracingDisabled() {
        IgniteEx ignite = this.startGrid(this.getConfiguration("ignite").setTracingSpi(null));
        UUID clusterId = ignite.cluster().id();
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)clusterId), (Object)true);
        String dest = StompDestinationsUtils.buildTracingConfigurationDest((UUID)clusterId);
        Assert.assertThrows(ConditionTimeoutException.class, () -> TestUtils.assertWithPoll(500L, 1000L, 10000L, () -> !F.isEmpty(this.inInterceptor.getAllPayloads(dest, List.class))));
    }

    private boolean containsTraceConfiguration(List<TracingConfiguration> list, Scope scope, String lbl, double rate, Set<Scope> subScopes) {
        return list.stream().filter(cfg -> cfg.getScope() == scope && Objects.equals(cfg.getLabel(), lbl) && Double.compare(cfg.getSamplingRate(), rate) == 0 && cfg.getIncludedScopes().equals(subScopes)).count() == 1L;
    }
}

