/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.dto.metric;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.gridgain.control.agent.AgentCommonAbstractTest;
import org.gridgain.control.agent.dto.metric.MetricRequest;
import org.gridgain.control.agent.dto.metric.MetricResponse;
import org.gridgain.control.agent.dto.metric.MetricSchema;
import org.gridgain.control.agent.dto.metric.MetricValueConsumer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MetricProtocolTest
extends AgentCommonAbstractTest {
    @Override
    protected IgniteConfiguration getConfiguration(String instanceName) {
        return super.getConfiguration(instanceName).setConsistentId((Serializable)((Object)instanceName)).setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("test_cache").setNearConfiguration(null).setStatisticsEnabled(true)});
    }

    @Override
    @Before
    public void setup() {
        this.stopAllGrids();
    }

    @Override
    @After
    public void teardown() {
        this.stopAllGrids();
    }

    @Test
    public void testRequestMetrics() throws Exception {
        IgniteEx ignite = this.startGrid();
        this.changeAgentConfiguration(ignite);
        IgniteClusterEx cluster = ignite.cluster();
        this.attachCluster(cluster);
        GridKernalContext ctx = ignite.context();
        CountDownLatch latch = new CountDownLatch(1);
        ctx.io().addMessageListener(GridTopic.TOPIC_METRICS, (nodeId, msg, plc) -> {
            final IgniteLogger log = ignite.log();
            if (msg instanceof MetricResponse) {
                MetricResponse res = (MetricResponse)msg;
                log.info("Time: " + res.timestamp());
                MetricSchema schema = res.schema();
                res.processData(schema, new MetricValueConsumer(){

                    public void onBoolean(String name, boolean val) {
                        log.info("Metric value: " + name + " - " + val);
                    }

                    public void onInt(String name, int val) {
                        log.info("Metric value: " + name + " - " + val);
                    }

                    public void onLong(String name, long val) {
                        log.info("Metric value: " + name + " - " + val);
                    }

                    public void onDouble(String name, double val) {
                        log.info("Metric value: " + name + " - " + val);
                    }
                });
                latch.countDown();
            }
        });
        MetricRequest req = new MetricRequest();
        ctx.io().sendToGridTopic(ignite.localNode().id(), GridTopic.TOPIC_METRICS, (Message)req, (byte)2);
        latch.await(5L, TimeUnit.SECONDS);
    }
}

