/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.control.agent.action.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.assertj.core.util.Sets;
import org.gridgain.control.agent.StompDestinationsUtils;
import org.gridgain.control.agent.action.controller.AbstractActionControllerWithGridGainSecurityTest;
import org.gridgain.control.agent.dto.action.AbstractRequest;
import org.gridgain.control.agent.dto.action.AuthenticateCredentials;
import org.gridgain.control.agent.dto.action.JobResponse;
import org.gridgain.control.agent.dto.action.Request;
import org.gridgain.control.agent.dto.action.SnapshotScheduleCreateArgument;
import org.gridgain.control.agent.dto.action.SnapshotScheduleModifyArgument;
import org.gridgain.control.agent.dto.action.Status;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.junit.Test;

public class SnapshotScheduleActionsControllerWithGridGainSecurityTest
extends AbstractActionControllerWithGridGainSecurityTest {
    private static final String ADMIN_OPS_ACCOUNT = "adminOps";
    private static final String ADMIN_VIEW_ACCOUNT = "adminView";

    @Override
    protected Map<SecurityCredentials, String> prepareCustomCredentials() {
        HashMap<SecurityCredentials, String> creds = new HashMap<SecurityCredentials, String>(2);
        creds.put(new SecurityCredentials(ADMIN_OPS_ACCOUNT, "123456"), "{     defaultAllow: false,    {        system:[ADMIN_OPS]    }}");
        creds.put(new SecurityCredentials(ADMIN_VIEW_ACCOUNT, "123456"), "{     defaultAllow: false,    {        system:[ADMIN_VIEW]    }}");
        return creds;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        GridGainConfiguration ggCfg = (GridGainConfiguration)cfg.getPluginConfigurations()[0];
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration());
        return cfg;
    }

    @Test
    public void shouldPerformGetListOfSnapshotsWithAdminViewAccount() {
        this.checkSecureGetListOfSnapshots(ADMIN_VIEW_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailGetListOfSnapshotsWithNoAccessAccount() {
        this.checkSecureGetListOfSnapshots("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformCreateScheduleWithAdminOpsAccount() {
        this.checkSecureCreateSchedule(ADMIN_OPS_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailCreateScheduleWithNoAccessAccount() {
        this.checkSecureCreateSchedule("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformDeleteScheduleWithAdminOpsAccount() {
        this.shouldDeleteSchedule(ADMIN_OPS_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailDeleteScheduleWithNoAccessAccount() {
        this.shouldDeleteSchedule("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    @Test
    public void shouldPerformEnableAndDisableScheduleWithAdminOpsAccount() {
        this.shouldEnableAndDisableSchedule(ADMIN_OPS_ACCOUNT, "123456", r -> Status.COMPLETED == r.getStatus());
    }

    @Test
    public void shouldFailEnableAndDisableScheduleWithNoAccessAccount() {
        this.shouldEnableAndDisableSchedule("no_access", "123456", r -> Status.FAILED == r.getStatus() && -32002 == r.getError().getCode());
    }

    private void checkSecureGetListOfSnapshots(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        SnapshotScheduleProcessor snap = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        snap.start(new SnapshotScheduleV2("1", "test-schedule", SnapshotOperationType.CREATE, "* * * * *", null, cacheNames, 1L, "/destination", true, null, new SnapshotCreateParameters(CompressionOption.SNAPPY, 2), null, -1, -1, null, 0));
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotScheduleActions.reloadList").setSessionId(sesId);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void checkSecureCreateSchedule(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        this.createSchedule(sesId, cacheNames, resChecker);
    }

    private void shouldDeleteSchedule(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        this.createSchedule(sesId, cacheNames, null);
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotScheduleActions.delete").setSessionId(sesId).setArgument((Object)new SnapshotScheduleModifyArgument().setName("create-schedule"));
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void shouldEnableAndDisableSchedule(String acc, String pwd, Predicate<JobResponse> resChecker) {
        UUID sesId = this.authenticate(new AuthenticateCredentials().setCredentials(new SecurityCredentials(acc, pwd)));
        IgniteEx ignite = (IgniteEx)this.cluster.ignite();
        ignite.getOrCreateCache("test-cache");
        Set cacheNames = Sets.set((Object[])new String[]{"test-cache"});
        this.changeAgentConfiguration(ignite);
        this.template.convertAndSend((Object)StompDestinationsUtils.buildAccountsAttachedTopic((UUID)this.cluster.id()), (Object)true);
        this.inInterceptor.clearMessages();
        this.createSchedule(sesId, cacheNames, null);
        Request disableReq = new Request().setId(UUID.randomUUID()).setAction("SnapshotScheduleActions.disable").setSessionId(sesId).setArgument((Object)new SnapshotScheduleModifyArgument().setName("create-schedule"));
        this.executeAction((AbstractRequest)disableReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
        Request enableReq = new Request().setId(UUID.randomUUID()).setAction("SnapshotScheduleActions.enable").setSessionId(sesId).setArgument((Object)new SnapshotScheduleModifyArgument().setName("create-schedule"));
        this.executeAction((AbstractRequest)enableReq, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && resChecker.test(r);
        });
    }

    private void createSchedule(UUID sesId, Set<String> cacheNames, Predicate<JobResponse> resChecker) {
        SnapshotScheduleCreateArgument arg = new SnapshotScheduleCreateArgument().setId(null).setName("create-schedule").setType(SnapshotOperationType.CREATE.name()).setCacheNames(cacheNames).setFrequency("0 * * * *").setExecAfter(null).setTtl(Long.valueOf(2L)).setForLatest(null).setForOldest(null).setDestination("/destination").setCompressionOption(CompressionOption.ZSTD.name()).setCompressionLevel(Integer.valueOf(5));
        Request req = new Request().setId(UUID.randomUUID()).setAction("SnapshotScheduleActions.create").setSessionId(sesId).setArgument((Object)arg);
        this.executeAction((AbstractRequest)req, res -> {
            JobResponse r = (JobResponse)F.first((List)res);
            return r != null && (resChecker == null || resChecker.test(r));
        });
    }
}

